/*
 * Decompiled with CFR 0.152.
 */
package cyano.lootable.events;

import cyano.lootable.LootableBodies;
import cyano.lootable.entities.EntityLootableBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerDeathEventHandler {
    private static final Map<EntityPlayer, Map<ItemStack, EntityEquipmentSlot>> equipmentCache = new HashMap<EntityPlayer, Map<ItemStack, EntityEquipmentSlot>>();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void entityDeathEvent(LivingDeathEvent e) {
        if (e.getEntity() instanceof EntityPlayer && e.getResult() != Event.Result.DENY && !e.getEntity().func_130014_f_().field_72995_K) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            if (player.func_175149_v()) {
                return;
            }
            Map cache = equipmentCache.computeIfAbsent(player, p -> new HashMap());
            for (EntityEquipmentSlot slot : EntityLootableBody.EQUIPMENT_SLOTS) {
                cache.put(player.func_184582_a(slot), slot);
            }
            if (player.func_184591_cq() == EnumHandSide.LEFT) {
                cache.put(player.func_184582_a(EntityEquipmentSlot.MAINHAND), EntityEquipmentSlot.OFFHAND);
                cache.put(player.func_184582_a(EntityEquipmentSlot.OFFHAND), EntityEquipmentSlot.MAINHAND);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void entityDropEvent(LivingDropsEvent e) {
        if (e.getEntity() instanceof EntityPlayer && e.getResult() != Event.Result.DENY && !e.getEntity().func_130014_f_().field_72995_K) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            if (player.func_175149_v()) {
                return;
            }
            World w = player.func_130014_f_();
            Map cache = equipmentCache.computeIfAbsent(player, p -> new HashMap());
            EntityLootableBody corpse = new EntityLootableBody(player);
            corpse.field_98038_p = true;
            corpse.setUserName(player.func_70005_c_());
            corpse.setRotation(player.field_70177_z);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (EntityItem itemEntity : e.getDrops()) {
                ItemStack item = itemEntity.func_92059_d();
                if (item != null && cache.containsKey(item)) {
                    corpse.func_184201_a((EntityEquipmentSlot)cache.get(item), item);
                    continue;
                }
                items.add(item);
            }
            corpse.initializeItems(items.toArray(new ItemStack[0]));
            if (LootableBodies.addBonesToCorpse) {
                corpse.addItem(new ItemStack(Items.field_151103_aS, 1 + w.field_73012_v.nextInt(3)));
                corpse.addItem(new ItemStack(Items.field_151078_bh, 1 + w.field_73012_v.nextInt(3)));
            }
            w.func_72838_d((Entity)corpse);
            e.getDrops().clear();
        }
    }

    private static void log(String s, Object ... o) {
        FMLLog.info((String)"%s: %s", (Object[])new Object[]{"lootablebodies", String.format(s, o)});
    }

    private static void log(Object o) {
        FMLLog.info((String)"%s: %s", (Object[])new Object[]{"lootablebodies", String.valueOf(o)});
    }
}

