/*
 * Decompiled with CFR 0.152.
 */
package arlyon.veining;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="veining")
public class Configuration {
    @Config.Name(value="Multiple Vein Types")
    @Config.Comment(value={"Determines whether the veining enchantment destroys other connected veins of different ores, or only of the original type mined."})
    public static boolean multiOre = false;
    @Config.Name(value="Disable When Crouching")
    @Config.Comment(value={"When true, the enchantment won't take effect when crouched."})
    public static boolean disableWhenCrouched = true;
    @Config.Name(value="Disable When Standing")
    @Config.Comment(value={"When true, the enchantment won't take effect when stood up."})
    public static boolean disableWhenStanding = false;
    @Config.Name(value="Veining Durability Cost")
    @Config.Comment(value={"Controls how much damage is done to the pickaxe per ore when the enchantment crumbles a vein."})
    @Config.RangeInt(min=0, max=5)
    public static int durabilityDamage = 2;
    @Config.Name(value="Rarity (%)")
    @Config.Comment(value={"Controls how rare the enchantment is (with 100% being as the mod was intended). It is recommended to keep it between 80% and 120%, and more statistics can be found on the wiki."})
    @Config.RangeInt(min=0, max=200)
    public static int enchantmentRarity = 100;

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("veining")) {
                ConfigManager.sync((String)"veining", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

