/*
 * Decompiled with CFR 0.152.
 */
package arlyon.veining;

import arlyon.veining.Configuration;
import arlyon.veining.Constants;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandler {

    @Mod.EventBusSubscriber(modid="veining")
    public static class EnchantmentHandler {
        @SubscribeEvent
        public static void registerEnchantment(RegistryEvent.Register<Enchantment> event) {
            event.getRegistry().register((IForgeRegistryEntry)Constants.veining);
        }
    }

    @Mod.EventBusSubscriber(modid="veining")
    public static class VeiningEventHandler {
        @SubscribeEvent
        public static void veiningSubscriber(BlockEvent.BreakEvent event) {
            if (event.getWorld().field_72995_K) {
                return;
            }
            EntityPlayer thePlayer = event.getPlayer();
            ItemStack mainHandItem = thePlayer.func_184614_ca();
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Constants.veining, (ItemStack)mainHandItem);
            if (enchantmentLevel == 0) {
                return;
            }
            IBlockState blockState = event.getState();
            String veinType = VeiningEventHandler.getOreDictType(blockState);
            if (!VeiningEventHandler.shouldBreak(veinType, blockState)) {
                return;
            }
            if (thePlayer.func_70093_af() && Configuration.disableWhenCrouched || !thePlayer.func_70093_af() && Configuration.disableWhenStanding) {
                return;
            }
            World world = event.getWorld();
            BlockPos blockPosition = event.getPos();
            VeiningEventHandler.veiningAlgorithm(blockState, blockPosition, world, mainHandItem, thePlayer, veinType);
        }

        private static String getOreDictType(IBlockState blockState) {
            if (blockState.toString().matches("ic2:resource|actuallyadditions:block_misc")) {
                UnmodifiableIterator keySetIter = blockState.func_177228_b().keySet().iterator();
                UnmodifiableIterator valueIter = blockState.func_177228_b().values().iterator();
                for (int i = 0; i < blockState.func_177228_b().size(); ++i) {
                    Comparable value = (Comparable)valueIter.next();
                    if (!((IProperty)keySetIter.next()).func_177701_a().equals("type")) continue;
                    return value.toString().matches("^.*_ore$|^ORE_.*$") ? value.toString() : null;
                }
                return null;
            }
            Block defaultBlock = blockState.func_177230_c() == Blocks.field_150439_ay ? Blocks.field_150450_ax : blockState.func_177230_c();
            ItemStack stack = new ItemStack(defaultBlock, 1);
            if (stack.func_190926_b()) {
                return null;
            }
            int[] blockIDs = OreDictionary.getOreIDs((ItemStack)stack);
            if (blockIDs.length == 0 && blockState.toString().matches("^.*:.*_ore$")) {
                Pattern p = Pattern.compile("^.*:(.*)_ore$");
                Matcher m = p.matcher(blockState.toString());
                m.matches();
                OreDictionary.registerOre((String)("ore" + m.group(1).substring(0, 1).toUpperCase() + m.group(1).substring(1)), (Block)blockState.func_177230_c());
                blockIDs = OreDictionary.getOreIDs((ItemStack)stack);
            }
            return Arrays.stream(blockIDs).mapToObj(OreDictionary::getOreName).filter(name -> name.matches("^ore(.+)")).findFirst().orElse(null);
        }

        private static boolean shouldBreak(String veinType, IBlockState blockState) {
            String oreType = VeiningEventHandler.getOreDictType(blockState);
            return veinType != null && oreType != null && (Configuration.multiOre || oreType.equals(veinType));
        }

        private static void veiningAlgorithm(IBlockState blockState, BlockPos blockPosition, World world, ItemStack mainHandItem, EntityPlayer thePlayer, String veinType) {
            if (!VeiningEventHandler.tryBreakBlock(blockState, blockPosition, world, mainHandItem, thePlayer)) {
                return;
            }
            for (EnumFacing direction : EnumFacing.values()) {
                BlockPos nextBlockPosition = blockPosition.func_177972_a(direction);
                IBlockState nextBlockState = world.func_180495_p(nextBlockPosition);
                if (!VeiningEventHandler.shouldBreak(veinType, nextBlockState)) continue;
                VeiningEventHandler.veiningAlgorithm(nextBlockState, nextBlockPosition, world, mainHandItem, thePlayer, veinType);
            }
        }

        private static boolean tryBreakBlock(IBlockState blockState, BlockPos blockPosition, World world, ItemStack mainHandItem, EntityPlayer thePlayer) {
            world.func_175698_g(blockPosition);
            if (thePlayer.field_71075_bZ.field_75098_d) {
                return true;
            }
            blockState.func_177230_c().func_176226_b(world, blockPosition, blockState, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)mainHandItem));
            if (mainHandItem.func_96631_a(Configuration.durabilityDamage, new Random(), (EntityPlayerMP)thePlayer)) {
                thePlayer.field_71071_by.func_184437_d(mainHandItem);
                return false;
            }
            return true;
        }
    }
}

