/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.apiculture.worldgen.HiveGen;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HiveGenGround
extends HiveGen {
    private final Set<Material> groundMaterials = new HashSet<Material>();

    public HiveGenGround(Block ... groundBlocks) {
        for (Block block : groundBlocks) {
            IBlockState blockState = block.func_176223_P();
            Material blockMaterial = blockState.func_185904_a();
            this.groundMaterials.add(blockMaterial);
        }
    }

    @Override
    public boolean isValidLocation(World world, BlockPos pos) {
        IBlockState groundBlockState = world.func_180495_p(pos.func_177977_b());
        Material groundBlockMaterial = groundBlockState.func_185904_a();
        return this.groundMaterials.contains(groundBlockMaterial);
    }

    @Override
    public BlockPos getPosForHive(World world, int x, int z) {
        BlockPos topPos = world.func_175645_m(new BlockPos(x, 0, z));
        if (topPos.func_177956_o() == 0) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);
        IBlockState blockState = world.func_180495_p((BlockPos)pos);
        while (HiveGenGround.isTreeBlock(blockState, world, (BlockPos)pos) || this.canReplace(blockState, world, (BlockPos)pos)) {
            pos.func_189536_c(EnumFacing.DOWN);
            if (pos.func_177956_o() <= 0) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)pos);
        }
        return pos.func_177984_a();
    }
}

