/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui.elements;

import forestry.api.gui.events.GuiEvent;
import forestry.book.data.structure.BlockData;
import forestry.book.data.structure.StructureBlockAccess;
import forestry.book.data.structure.StructureInfo;
import forestry.core.gui.elements.GuiElement;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MultiblockElement
extends GuiElement {
    private float scale = 50.0f;
    private float xTranslate = 0.0f;
    private float yTranslate = 0.0f;
    private boolean canTick = false;
    private int tick = 0;
    private float rotX;
    private float rotY;
    private StructureInfo structureData;
    private StructureBlockAccess blockAccess;
    @Nullable
    private int[] lastClick = null;
    private int fullStructureSteps = 5;

    public MultiblockElement(int x, int y, int width, int height, int[] size, BlockData[] structure) {
        super(x, y, width, height);
        if (size.length == 3) {
            this.scale = 100.0f / (float)IntStream.of(size).max().getAsInt();
            float sx = (float)width / 108.0f;
            float sy = (float)height / 155.0f;
            this.scale *= Math.min(sx, sy);
            this.xTranslate = (float)x + (float)width / 2.0f;
            this.yTranslate = (float)y + (float)height / 2.0f;
        }
        this.structureData = new StructureInfo(size[0], size[1], size[2], structure);
        this.blockAccess = new StructureBlockAccess(this.structureData);
        this.rotX = 25.0f;
        this.rotY = -45.0f;
        this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
            this.lastClick = new int[]{event.getX(), event.getY()};
        });
        this.addSelfEventHandler(GuiEvent.UpEvent.class, event -> {
            this.lastClick = null;
        });
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        if (this.lastClick != null) {
            if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
                int dx = mouseX - this.lastClick[0];
                int dy = mouseY - this.lastClick[1];
                float maxSpeed = 10.0f;
                float changeY = Math.min(maxSpeed, (float)dx / 10.0f);
                float changeX = Math.min(maxSpeed, (float)dy / 10.0f);
                this.rotY += changeY;
                this.rotX += changeX;
            } else {
                this.lastClick = null;
            }
        }
        if (this.canTick) {
            if (++this.tick % 20 == 0 && (this.structureData.canStep() || ++this.fullStructureSteps >= 5)) {
                this.structureData.step();
                this.fullStructureSteps = 0;
            }
        } else {
            this.structureData.reset();
            this.structureData.setShowLayer(9);
        }
        int structureLength = this.structureData.structureLength;
        int structureWidth = this.structureData.structureWidth;
        int structureHeight = this.structureData.structureHeight;
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179109_b((float)this.xTranslate, (float)this.yTranslate, (float)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
        GlStateManager.func_179152_a((float)this.scale, (float)(-this.scale), (float)1.0f);
        GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)((float)structureLength / -2.0f), (float)((float)structureHeight / -2.0f), (float)((float)structureWidth / -2.0f));
        GlStateManager.func_179140_f();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        textureManager.func_110577_a(TextureMap.field_110575_b);
        for (int h = 0; h < this.structureData.structureHeight; ++h) {
            for (int l = 0; l < this.structureData.structureLength; ++l) {
                for (int w = 0; w < this.structureData.structureWidth; ++w) {
                    BlockPos pos = new BlockPos(l, h, w);
                    if (this.blockAccess.func_175623_d(pos)) continue;
                    IBlockState state = this.blockAccess.func_180495_p(pos);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder buffer = tessellator.func_178180_c();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    blockRender.func_175018_a(state, pos, (IBlockAccess)this.blockAccess, buffer);
                    tessellator.func_78381_a();
                }
            }
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
    }
}

