/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.api.gui.IGuiElement;
import forestry.core.gui.elements.layouts.AbstractElementLayout;

public class HorizontalLayout
extends AbstractElementLayout {
    public HorizontalLayout(int xPos, int yPos, int height) {
        super(xPos, yPos, 0, height);
    }

    @Override
    public <E extends IGuiElement> E add(E element) {
        this.elements.add(element);
        element.setParent(this);
        element.setXPosition(this.width);
        this.setWidth(this.width + (element.getWidth() + this.distance));
        element.onCreation();
        return element;
    }

    @Override
    public <E extends IGuiElement> E remove(E element) {
        this.elements.remove(element);
        this.setWidth(this.width - (element.getWidth() + this.distance));
        element.setXPosition(0);
        element.onDeletion();
        return element;
    }

    @Override
    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        int height = 0;
        for (IGuiElement element : this.elements) {
            int elementHeight = element.getHeight();
            if (elementHeight <= height) continue;
            height = elementHeight;
        }
        return height;
    }
}

