/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.gui.widgets;

import forestry.core.gui.widgets.ItemStackWidgetBase;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.SoundUtil;
import forestry.worktable.gui.ContainerWorktable;
import forestry.worktable.recipes.RecipeMemory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;

public class MemorizedRecipeSlot
extends ItemStackWidgetBase {
    private static final TextureAtlasSprite lockIcon = TextureManagerForestry.getInstance().getDefault("slots/locked");
    private final RecipeMemory recipeMemory;
    private final int slotNumber;

    public MemorizedRecipeSlot(WidgetManager manager, int xPos, int yPos, RecipeMemory recipeMemory, int slot) {
        super(manager, xPos, yPos);
        this.recipeMemory = recipeMemory;
        this.slotNumber = slot;
    }

    @Override
    public ItemStack getItemStack() {
        return this.recipeMemory.getRecipeDisplayOutput(this.slotNumber);
    }

    @Override
    public void draw(int startX, int startY) {
        super.draw(startX, startY);
        GlStateManager.func_179097_i();
        if (this.recipeMemory.isLocked(this.slotNumber)) {
            TextureManagerForestry.getInstance().bindGuiTextureMap();
            this.manager.gui.func_175175_a(startX + this.xPos, startY + this.yPos, lockIcon, 16, 16);
        }
        GlStateManager.func_179126_j();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.getItemStack().func_190926_b()) {
            ContainerWorktable.sendRecipeClick(mouseButton, this.slotNumber);
            SoundUtil.playButtonClick();
        }
    }
}

