/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.EncodedText;
import com.mpatric.mp3agic.InvalidDataException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ID3v2PictureFrameData
extends AbstractID3v2FrameData {
    protected String mimeType;
    protected byte pictureType;
    protected EncodedText description;
    protected byte[] imageData;

    public ID3v2PictureFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2PictureFrameData(boolean unsynchronisation, String mimeType, byte pictureType, EncodedText description, byte[] imageData) {
        super(unsynchronisation);
        this.mimeType = mimeType;
        this.pictureType = pictureType;
        this.description = description;
        this.imageData = imageData;
    }

    public ID3v2PictureFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        int marker = BufferTools.indexOfTerminator(bytes, 1, 1);
        if (marker >= 0) {
            try {
                this.mimeType = BufferTools.byteBufferToString(bytes, 1, marker - 1);
            }
            catch (UnsupportedEncodingException e) {
                this.mimeType = "image/unknown";
            }
        } else {
            this.mimeType = "image/unknown";
        }
        this.pictureType = bytes[marker + 1];
        int marker2 = BufferTools.indexOfTerminatorForEncoding(bytes, marker += 2, bytes[0]);
        if (marker2 >= 0) {
            this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, marker, marker2 - marker));
            marker2 += this.description.getTerminator().length;
        } else {
            this.description = new EncodedText(bytes[0], "");
            marker2 = marker;
        }
        this.imageData = BufferTools.copyBuffer(bytes, marker2, bytes.length - marker2);
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        bytes[0] = this.description != null ? this.description.getTextEncoding() : (byte)0;
        int mimeTypeLength = 0;
        if (this.mimeType != null && this.mimeType.length() > 0) {
            mimeTypeLength = this.mimeType.length();
            try {
                BufferTools.stringIntoByteBuffer(this.mimeType, 0, mimeTypeLength, bytes, 1);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        int marker = mimeTypeLength + 1;
        bytes[marker++] = 0;
        bytes[marker++] = this.pictureType;
        if (this.description != null && this.description.toBytes().length > 0) {
            byte[] descriptionBytes = this.description.toBytes(true, true);
            BufferTools.copyIntoByteBuffer(descriptionBytes, 0, descriptionBytes.length, bytes, marker);
            marker += descriptionBytes.length;
        } else {
            bytes[marker++] = 0;
        }
        if (this.imageData != null && this.imageData.length > 0) {
            BufferTools.copyIntoByteBuffer(this.imageData, 0, this.imageData.length, bytes, marker);
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 3;
        if (this.mimeType != null) {
            length += this.mimeType.length();
        }
        length = this.description != null ? (length += this.description.toBytes(true, true).length) : ++length;
        if (this.imageData != null) {
            length += this.imageData.length;
        }
        return length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public byte getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(byte pictureType) {
        this.pictureType = pictureType;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText description) {
        this.description = description;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + Arrays.hashCode(this.imageData);
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + this.pictureType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2PictureFrameData other = (ID3v2PictureFrameData)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (!Arrays.equals(this.imageData, other.imageData)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        return this.pictureType == other.pictureType;
    }
}

