/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.EncodedText;
import com.mpatric.mp3agic.InvalidDataException;

public class ID3v2TextFrameData
extends AbstractID3v2FrameData {
    protected EncodedText text;

    public ID3v2TextFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2TextFrameData(boolean unsynchronisation, EncodedText text) {
        super(unsynchronisation);
        this.text = text;
    }

    public ID3v2TextFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        this.text = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 1, bytes.length - 1));
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        if (this.text != null) {
            bytes[0] = this.text.getTextEncoding();
            byte[] textBytes = this.text.toBytes(true, false);
            if (textBytes.length > 0) {
                BufferTools.copyIntoByteBuffer(textBytes, 0, textBytes.length, bytes, 1);
            }
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 1;
        if (this.text != null) {
            length += this.text.toBytes(true, false).length;
        }
        return length;
    }

    public EncodedText getText() {
        return this.text;
    }

    public void setText(EncodedText text) {
        this.text = text;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2TextFrameData other = (ID3v2TextFrameData)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

