/*
 * Decompiled with CFR 0.152.
 */
package kj.dsp;

public class KJFFT {
    private float[] xre;
    private float[] xim;
    private float[] mag;
    private float[] fftSin;
    private float[] fftCos;
    private int[] fftBr;
    private int ss;
    private int ss2;
    private int nu;
    private int nu1;

    public KJFFT(int pSampleSize) {
        this.ss = pSampleSize;
        this.ss2 = this.ss >> 1;
        this.xre = new float[this.ss];
        this.xim = new float[this.ss];
        this.mag = new float[this.ss2];
        this.nu = (int)(Math.log(this.ss) / Math.log(2.0));
        this.nu1 = this.nu - 1;
        this.prepareFFTTables();
    }

    private int bitrev(int j, int nu) {
        int j1 = j;
        int k = 0;
        for (int i = 1; i <= nu; ++i) {
            int j2 = j1 >> 1;
            k = (k << 1) + j1 - (j2 << 1);
            j1 = j2;
        }
        return k;
    }

    public float[] calculate(float[] pSample) {
        int i;
        int k;
        int n2 = this.ss2;
        int nu1 = this.nu - 1;
        int wAps = pSample.length / this.ss;
        int a = 0;
        int b = 0;
        while (a < pSample.length) {
            this.xre[b] = pSample[a];
            this.xim[b] = 0.0f;
            a += wAps;
            ++b;
        }
        int x = 0;
        for (int l = 1; l <= this.nu; ++l) {
            for (k = 0; k < this.ss; k += n2) {
                for (i = 1; i <= n2; ++i) {
                    float c = this.fftCos[x];
                    float s = this.fftSin[x];
                    int kn2 = k + n2;
                    float tr = this.xre[kn2] * c + this.xim[kn2] * s;
                    float ti = this.xim[kn2] * c - this.xre[kn2] * s;
                    this.xre[kn2] = this.xre[k] - tr;
                    this.xim[kn2] = this.xim[k] - ti;
                    int n = k;
                    this.xre[n] = this.xre[n] + tr;
                    int n3 = k++;
                    this.xim[n3] = this.xim[n3] + ti;
                    ++x;
                }
            }
            --nu1;
            n2 >>= 1;
        }
        for (k = 0; k < this.ss; ++k) {
            int r = this.fftBr[k];
            if (r <= k) continue;
            float tr = this.xre[k];
            float ti = this.xim[k];
            this.xre[k] = this.xre[r];
            this.xim[k] = this.xim[r];
            this.xre[r] = tr;
            this.xim[r] = ti;
        }
        this.mag[0] = (float)Math.sqrt(this.xre[0] * this.xre[0] + this.xim[0] * this.xim[0]) / (float)this.ss;
        for (i = 1; i < this.ss2; ++i) {
            this.mag[i] = 2.0f * (float)Math.sqrt(this.xre[i] * this.xre[i] + this.xim[i] * this.xim[i]) / (float)this.ss;
        }
        return this.mag;
    }

    private void prepareFFTTables() {
        int n2 = this.ss2;
        int nu1 = this.nu - 1;
        this.fftSin = new float[this.nu * n2];
        this.fftCos = new float[this.nu * n2];
        int k = 0;
        int x = 0;
        for (int l = 1; l <= this.nu; ++l) {
            while (k < this.ss) {
                for (int i = 1; i <= n2; ++i) {
                    float p = this.bitrev(k >> nu1, this.nu);
                    float arg = (float)Math.PI * 2 * p / (float)this.ss;
                    this.fftSin[x] = (float)Math.sin(arg);
                    this.fftCos[x] = (float)Math.cos(arg);
                    ++k;
                    ++x;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 >>= 1;
        }
        this.fftBr = new int[this.ss];
        for (k = 0; k < this.ss; ++k) {
            this.fftBr[k] = this.bitrev(k, this.nu);
        }
    }
}

