/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.playlist;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.minetunes.config.MTConfig;
import vazkii.minetunes.gui.GuiPlaylistManager;
import vazkii.minetunes.playlist.MP3Metadata;
import vazkii.minetunes.playlist.provider.IProviderStateCallback;
import vazkii.minetunes.playlist.provider.PlaylistProvider;
import vazkii.minetunes.playlist.provider.ProviderDirectory;
import vazkii.minetunes.playlist.provider.ProviderM3U;

public class Playlist {
    private static final String TAG_NAME = "name";
    private static final String TAG_FILE_PATH = "filePath";
    private static final String TAG_SONG_COUNT = "songCount";
    private static final String TAG_SONG_PREFIX = "song";
    public final List<MP3Metadata> metadataList;
    public final File file;
    public String storeName = "";
    Random rand = new Random();

    public Playlist(File file, Collection<MP3Metadata> metaSet) {
        this.file = file;
        this.metadataList = new ArrayList<MP3Metadata>(metaSet);
    }

    public static Playlist build(File file, IProviderStateCallback callback) {
        ProviderDirectory provider = file.isDirectory() ? ProviderDirectory.instance : (file.getName().endsWith(".m3u") ? ProviderM3U.instance : null);
        return provider == null ? null : ((PlaylistProvider)provider).provide(file, callback);
    }

    public static Playlist build(NBTTagCompound cmp) {
        String name = cmp.func_74779_i(TAG_NAME);
        String filePath = cmp.func_74779_i(TAG_FILE_PATH);
        int count = cmp.func_74762_e(TAG_SONG_COUNT);
        TreeSet<MP3Metadata> metadataSet = new TreeSet<MP3Metadata>();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound cmp1 = cmp.func_74775_l(TAG_SONG_PREFIX + i);
            metadataSet.add(new MP3Metadata(cmp1));
        }
        Playlist playlist = new Playlist(new File(filePath), metadataSet);
        playlist.storeName = name;
        return playlist;
    }

    public void writeToNBT(NBTTagCompound cmp, String name) {
        cmp.func_74778_a(TAG_NAME, name);
        cmp.func_74778_a(TAG_FILE_PATH, this.file.getAbsolutePath());
        cmp.func_74768_a(TAG_SONG_COUNT, this.metadataList.size());
        int i = 0;
        for (MP3Metadata meta : this.metadataList) {
            NBTTagCompound cmp1 = new NBTTagCompound();
            meta.writeToNBT(cmp1);
            cmp.func_74782_a(TAG_SONG_PREFIX + i, (NBTBase)cmp1);
            ++i;
        }
    }

    public MP3Metadata nextSong() {
        boolean valid;
        int index = this.nextSongIndex();
        boolean bl = valid = index >= 0 && index < this.metadataList.size();
        if (valid) {
            GuiPlaylistManager.selectCurrentSong(index);
            return this.metadataList.get(index);
        }
        return null;
    }

    public int nextSongIndex() {
        switch (MTConfig.playMode) {
            case 1: {
                return this.repeat();
            }
            case 2: {
                return this.loop();
            }
            case 3: {
                return this.shuffle();
            }
        }
        return this.stop();
    }

    public int stop() {
        return -1;
    }

    public int repeat() {
        return GuiPlaylistManager.getCurrentSong();
    }

    public int loop() {
        int selected = GuiPlaylistManager.getCurrentSong();
        int index = selected + 1;
        if (index >= this.metadataList.size()) {
            index = 0;
        }
        return index;
    }

    public int shuffle() {
        int selected = GuiPlaylistManager.getCurrentSong();
        int size = this.metadataList.size();
        if (size < 2) {
            return selected;
        }
        int index = selected;
        int next = this.loop();
        for (int tries = 0; (index == selected || index == next) && tries < 50; ++tries) {
            index = this.rand.nextInt(size);
        }
        return index;
    }
}

