/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.CommonProxy;
import electroblob.wizardry.Settings;
import electroblob.wizardry.WizardryGuiHandler;
import electroblob.wizardry.block.BlockBookshelf;
import electroblob.wizardry.command.CommandCastSpell;
import electroblob.wizardry.command.CommandDiscoverSpell;
import electroblob.wizardry.command.CommandSetAlly;
import electroblob.wizardry.command.CommandViewAllies;
import electroblob.wizardry.data.DispenserCastingData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.integration.antiqueatlas.WizardryAntiqueAtlasIntegration;
import electroblob.wizardry.integration.baubles.WizardryBaublesIntegration;
import electroblob.wizardry.inventory.ContainerBookshelf;
import electroblob.wizardry.misc.DonationPerksHandler;
import electroblob.wizardry.misc.Forfeit;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryLoot;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.worldgen.WorldGenCrystalFlower;
import electroblob.wizardry.worldgen.WorldGenCrystalOre;
import electroblob.wizardry.worldgen.WorldGenLibraryRuins;
import electroblob.wizardry.worldgen.WorldGenObelisk;
import electroblob.wizardry.worldgen.WorldGenShrine;
import electroblob.wizardry.worldgen.WorldGenUndergroundLibraryRuins;
import electroblob.wizardry.worldgen.WorldGenWizardTower;
import java.io.File;
import java.util.Calendar;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="ebwizardry", name="Electroblob's Wizardry", version="4.3.4", acceptedMinecraftVersions="[1.12.2]", guiFactory="electroblob.wizardry.WizardryGuiFactory", dependencies="required-after:forge@[14.23.5.2847,);after:jei@[4.15.0,);after:baubles@[1.5.2,);after:antiqueatlas@[4.6,)")
public class Wizardry {
    public static final String MODID = "ebwizardry";
    public static final String NAME = "Electroblob's Wizardry";
    public static final String VERSION = "4.3.4";
    public static final Settings settings = new Settings();
    public static Logger logger;
    public static File configDirectory;
    public static boolean tisTheSeason;
    @Mod.Instance(value="ebwizardry")
    public static Wizardry instance;
    @SidedProxy(clientSide="electroblob.wizardry.client.ClientProxy", serverSide="electroblob.wizardry.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.registerResourceReloadListeners();
        configDirectory = new File(event.getModConfigurationDirectory(), MODID);
        settings.initConfig(event);
        Calendar calendar = Calendar.getInstance();
        tisTheSeason = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        WizardData.register();
        DispenserCastingData.register();
        WizardryBlocks.registerTileEntities();
        WizardryLoot.register();
        WizardryAdvancementTriggers.register();
        Forfeit.register();
        BlockBookshelf.registerStandardBookModelTextures();
        proxy.registerRenderers();
        proxy.registerKeyBindings();
        WizardrySounds.SPELLS = SoundCategory.PLAYERS;
        WizardryBaublesIntegration.init();
        WizardryAntiqueAtlasIntegration.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        settings.initConfigExtras();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCrystalOre(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCrystalFlower(), (int)50);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenWizardTower(), (int)20);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenObelisk(), (int)20);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenShrine(), (int)20);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenLibraryRuins(), (int)20);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenUndergroundLibraryRuins(), (int)20);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new WizardryGuiHandler());
        WizardryPacketHandler.initPackets();
        BlockBookshelf.compileBookModelTextures();
        ContainerBookshelf.initDefaultBookItems();
        WizardryItems.registerDispenseBehaviours();
        WizardryItems.registerBannerPatterns();
        WandHelper.populateUpgradeMap();
        Spell.registry.forEach(Spell::init);
        SpellProperties.init();
        proxy.initGuiBits();
        proxy.registerParticles();
        proxy.registerSoundEventListener();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.initialiseLayers();
        proxy.initialiseAnimations();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCastSpell());
        event.registerServerCommand((ICommand)new CommandSetAlly());
        event.registerServerCommand((ICommand)new CommandViewAllies());
        event.registerServerCommand((ICommand)new CommandDiscoverSpell());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            settings.saveConfigChanges();
            if (event.isWorldRunning() && DonationPerksHandler.isDonor(proxy.getThePlayer())) {
                DonationPerksHandler.sendToServer(proxy.getThePlayer());
            }
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappingEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            Item replacement;
            if (!mapping.key.func_110624_b().equals(MODID)) continue;
            switch (mapping.key.func_110623_a()) {
                case "wand_basic": {
                    replacement = WizardryItems.magic_wand;
                    break;
                }
                case "wand_basic_fire": {
                    replacement = WizardryItems.novice_fire_wand;
                    break;
                }
                case "wand_basic_ice": {
                    replacement = WizardryItems.novice_ice_wand;
                    break;
                }
                case "wand_basic_lightning": {
                    replacement = WizardryItems.novice_lightning_wand;
                    break;
                }
                case "wand_basic_necromancy": {
                    replacement = WizardryItems.novice_necromancy_wand;
                    break;
                }
                case "wand_basic_earth": {
                    replacement = WizardryItems.novice_earth_wand;
                    break;
                }
                case "wand_basic_sorcery": {
                    replacement = WizardryItems.novice_sorcery_wand;
                    break;
                }
                case "wand_basic_healing": {
                    replacement = WizardryItems.novice_healing_wand;
                    break;
                }
                case "basic_fire_wand": {
                    replacement = WizardryItems.novice_fire_wand;
                    break;
                }
                case "basic_ice_wand": {
                    replacement = WizardryItems.novice_ice_wand;
                    break;
                }
                case "basic_lightning_wand": {
                    replacement = WizardryItems.novice_lightning_wand;
                    break;
                }
                case "basic_necromancy_wand": {
                    replacement = WizardryItems.novice_necromancy_wand;
                    break;
                }
                case "basic_earth_wand": {
                    replacement = WizardryItems.novice_earth_wand;
                    break;
                }
                case "basic_sorcery_wand": {
                    replacement = WizardryItems.novice_sorcery_wand;
                    break;
                }
                case "basic_healing_wand": {
                    replacement = WizardryItems.novice_healing_wand;
                    break;
                }
                case "wand_apprentice": {
                    replacement = WizardryItems.apprentice_wand;
                    break;
                }
                case "wand_apprentice_fire": {
                    replacement = WizardryItems.apprentice_fire_wand;
                    break;
                }
                case "wand_apprentice_ice": {
                    replacement = WizardryItems.apprentice_ice_wand;
                    break;
                }
                case "wand_apprentice_lightning": {
                    replacement = WizardryItems.apprentice_lightning_wand;
                    break;
                }
                case "wand_apprentice_necromancy": {
                    replacement = WizardryItems.apprentice_necromancy_wand;
                    break;
                }
                case "wand_apprentice_earth": {
                    replacement = WizardryItems.apprentice_earth_wand;
                    break;
                }
                case "wand_apprentice_sorcery": {
                    replacement = WizardryItems.apprentice_sorcery_wand;
                    break;
                }
                case "wand_apprentice_healing": {
                    replacement = WizardryItems.apprentice_healing_wand;
                    break;
                }
                case "wand_advanced": {
                    replacement = WizardryItems.advanced_wand;
                    break;
                }
                case "wand_advanced_fire": {
                    replacement = WizardryItems.advanced_fire_wand;
                    break;
                }
                case "wand_advanced_ice": {
                    replacement = WizardryItems.advanced_ice_wand;
                    break;
                }
                case "wand_advanced_lightning": {
                    replacement = WizardryItems.advanced_lightning_wand;
                    break;
                }
                case "wand_advanced_necromancy": {
                    replacement = WizardryItems.advanced_necromancy_wand;
                    break;
                }
                case "wand_advanced_earth": {
                    replacement = WizardryItems.advanced_earth_wand;
                    break;
                }
                case "wand_advanced_sorcery": {
                    replacement = WizardryItems.advanced_sorcery_wand;
                    break;
                }
                case "wand_advanced_healing": {
                    replacement = WizardryItems.advanced_healing_wand;
                    break;
                }
                case "wand_master": {
                    replacement = WizardryItems.master_wand;
                    break;
                }
                case "wand_master_fire": {
                    replacement = WizardryItems.master_fire_wand;
                    break;
                }
                case "wand_master_ice": {
                    replacement = WizardryItems.master_ice_wand;
                    break;
                }
                case "wand_master_lightning": {
                    replacement = WizardryItems.master_lightning_wand;
                    break;
                }
                case "wand_master_necromancy": {
                    replacement = WizardryItems.master_necromancy_wand;
                    break;
                }
                case "wand_master_earth": {
                    replacement = WizardryItems.master_earth_wand;
                    break;
                }
                case "wand_master_sorcery": {
                    replacement = WizardryItems.master_sorcery_wand;
                    break;
                }
                case "wand_master_healing": {
                    replacement = WizardryItems.master_healing_wand;
                    break;
                }
                case "upgrade_storage": {
                    replacement = WizardryItems.storage_upgrade;
                    break;
                }
                case "upgrade_siphon": {
                    replacement = WizardryItems.siphon_upgrade;
                    break;
                }
                case "upgrade_condenser": {
                    replacement = WizardryItems.condenser_upgrade;
                    break;
                }
                case "upgrade_range": {
                    replacement = WizardryItems.range_upgrade;
                    break;
                }
                case "upgrade_duration": {
                    replacement = WizardryItems.duration_upgrade;
                    break;
                }
                case "upgrade_cooldown": {
                    replacement = WizardryItems.cooldown_upgrade;
                    break;
                }
                case "upgrade_blast": {
                    replacement = WizardryItems.blast_upgrade;
                    break;
                }
                case "upgrade_attunement": {
                    replacement = WizardryItems.attunement_upgrade;
                    break;
                }
                default: {
                    return;
                }
            }
            mapping.remap((IForgeRegistryEntry)replacement);
        }
    }

    @SubscribeEvent
    public static void onMissingSpellMappingEvent(RegistryEvent.MissingMappings<Spell> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110624_b().equals(MODID) || !mapping.key.func_110623_a().equals("firestorm")) continue;
            mapping.remap((IForgeRegistryEntry)Spells.fire_breath);
        }
    }
}

