/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.data;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.packet.PacketGlyphData;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.RandomStringUtils;

@Mod.EventBusSubscriber
public class SpellGlyphData
extends WorldSavedData {
    public static final String NAME = "ebwizardry_glyphData";
    public Map<Spell, String> randomNames = new HashMap<Spell, String>(Spell.getTotalSpellCount());
    public Map<Spell, String> randomDescriptions = new HashMap<Spell, String>(Spell.getTotalSpellCount());

    public SpellGlyphData() {
        this(NAME);
    }

    public SpellGlyphData(String name) {
        super(name);
    }

    public void generateGlyphNames(World world) {
        for (Spell spell : Spell.getAllSpells()) {
            if (this.randomNames.containsKey(spell)) continue;
            this.randomNames.put(spell, this.generateRandomName(world.field_73012_v));
        }
        for (Spell spell : Spell.getAllSpells()) {
            if (this.randomDescriptions.containsKey(spell)) continue;
            this.randomDescriptions.put(spell, this.generateRandomDescription(world.field_73012_v));
        }
        this.func_76185_a();
    }

    private String generateRandomName(Random random) {
        String name = "";
        for (int i = 0; i < random.nextInt(2) + 2; ++i) {
            name = name + RandomStringUtils.random((int)(3 + random.nextInt(5)), (String)"abcdefghijklmnopqrstuvwxyz") + " ";
        }
        return name.trim();
    }

    private String generateRandomDescription(Random random) {
        String name = "";
        for (int i = 0; i < random.nextInt(16) + 8; ++i) {
            name = name + RandomStringUtils.random((int)(2 + random.nextInt(7)), (String)"abcdefghijklmnopqrstuvwxyz") + " ";
        }
        return name.trim();
    }

    public static SpellGlyphData get(World world) {
        SpellGlyphData instance = (SpellGlyphData)world.func_72943_a(SpellGlyphData.class, NAME);
        if (instance == null) {
            instance = new SpellGlyphData();
        }
        if (instance.randomNames.size() < Spell.getTotalSpellCount() || instance.randomDescriptions.size() < Spell.getTotalSpellCount()) {
            instance.generateGlyphNames(world);
            world.func_72823_a(NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public void sync(EntityPlayerMP player) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> descriptions = new ArrayList<String>();
        for (int id = 0; id < Spell.getTotalSpellCount(); ++id) {
            Spell spell = Spell.byNetworkID(id + 1);
            names.add(this.randomNames.get(spell));
            descriptions.add(this.randomDescriptions.get(spell));
        }
        PacketGlyphData.Message msg = new PacketGlyphData.Message(names, descriptions);
        WizardryPacketHandler.net.sendTo((IMessage)msg, player);
        Wizardry.logger.info("Synchronising spell glyph data for " + player.func_70005_c_());
    }

    public static String getGlyphName(Spell spell, World world) {
        Map<Spell, String> names = SpellGlyphData.get((World)world).randomNames;
        return names == null ? "" : names.get(spell);
    }

    public static String getGlyphDescription(Spell spell, World world) {
        Map<Spell, String> descriptions = SpellGlyphData.get((World)world).randomDescriptions;
        return descriptions == null ? "" : descriptions.get(spell);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.randomNames = new HashMap<Spell, String>();
        this.randomDescriptions = new HashMap<Spell, String>();
        NBTTagList tagList = nbt.func_150295_c("spellGlyphData", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            this.randomNames.put(Spell.byMetadata(tag.func_74762_e("spell")), tag.func_74779_i("name"));
            this.randomDescriptions.put(Spell.byMetadata(tag.func_74762_e("spell")), tag.func_74779_i("description"));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Spell spell : Spell.getAllSpells()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("spell", spell.metadata());
            tag.func_74778_a("name", this.randomNames.get(spell));
            tag.func_74778_a("description", this.randomDescriptions.get(spell));
            tagList.func_74742_a((NBTBase)tag);
        }
        NBTExtras.storeTagSafely(nbt, "spellGlyphData", (NBTBase)tagList);
        return nbt;
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            SpellGlyphData.get(event.getWorld());
        }
    }
}

