/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.EntityLevitatingBlock;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlackHole
extends EntityScaledConstruct {
    private static final double SUCTION_STRENGTH = 0.075;
    private static final int BLOCK_UNHOOK_LIMIT = 3;
    public int[] randomiser;
    public int[] randomiser2;

    public EntityBlackHole(World world) {
        super(world);
        int i;
        float r = Spells.black_hole.getProperty("effect_radius").floatValue();
        this.func_70105_a(r * 2.0f, r);
        this.randomiser = new int[30];
        for (i = 0; i < this.randomiser.length; ++i) {
            this.randomiser[i] = this.field_70146_Z.nextInt(10);
        }
        this.randomiser2 = new int[30];
        for (i = 0; i < this.randomiser2.length; ++i) {
            this.randomiser2[i] = this.field_70146_Z.nextInt(10);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.randomiser = nbttagcompound.func_74759_k("randomiser");
        this.randomiser2 = nbttagcompound.func_74759_k("randomiser2");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74783_a("randomiser", this.randomiser);
        nbttagcompound.func_74783_a("randomiser2", this.randomiser2);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa + 40 < this.lifetime) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, (this.field_70146_Z.nextDouble() - 0.5) * 4.0, (this.field_70146_Z.nextDouble() - 0.5) * 4.0 - 1.0, (this.field_70146_Z.nextDouble() - 0.5) * 4.0, new int[0]);
            }
        }
        if (this.lifetime - this.field_70173_aa == 75) {
            this.func_184185_a(WizardrySounds.ENTITY_BLACK_HOLE_VANISH, 1.5f, 1.0f);
        } else if (this.field_70173_aa % 80 == 1 && this.field_70173_aa + 80 < this.lifetime) {
            this.func_184185_a(WizardrySounds.ENTITY_BLACK_HOLE_AMBIENT, 1.5f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean suckInBlocks;
            double radius = 2.0f * this.field_70131_O * this.sizeMultiplier;
            boolean bl = suckInBlocks = this.getCaster() instanceof EntityPlayer && EntityUtils.canDamageBlocks((Entity)this.getCaster(), this.field_70170_p) && ItemArtefact.isArtefactActive((EntityPlayer)this.getCaster(), WizardryItems.charm_black_hole);
            if (suckInBlocks) {
                List<BlockPos> sphere = BlockUtils.getBlockSphere(new BlockPos((Entity)this), radius);
                int blocksUnhooked = 0;
                for (BlockPos pos : sphere) {
                    if (this.field_70146_Z.nextInt(Math.max(1, (int)this.func_174818_b(pos) * 3)) != 0 || BlockUtils.isBlockUnbreakable(this.field_70170_p, pos) || this.field_70170_p.func_175623_d(pos) || !this.field_70170_p.func_175677_d(pos, false) || !BlockUtils.canBreakBlock((Entity)this.getCaster(), this.field_70170_p, pos)) continue;
                    EntityLevitatingBlock fallingBlock = new EntityLevitatingBlock(this.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.field_70170_p.func_180495_p(pos));
                    fallingBlock.field_145812_b = 1;
                    this.field_70170_p.func_72838_d((Entity)fallingBlock);
                    this.field_70170_p.func_175698_g(pos);
                    if (++blocksUnhooked < 3) continue;
                    break;
                }
            }
            List<Entity> targets = EntityUtils.getEntitiesWithinRadius(radius, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p, Entity.class);
            targets.removeIf(t -> !(t instanceof EntityLivingBase) && (!suckInBlocks || !(t instanceof EntityFallingBlock)));
            for (Entity target : targets) {
                if (!this.isValidTarget(target)) continue;
                if (!(target instanceof EntityPlayer) || (!(this.getCaster() instanceof EntityPlayer) || Wizardry.settings.playersMoveEachOther) && !ItemArtefact.isArtefactActive((EntityPlayer)target, WizardryItems.amulet_anchoring)) {
                    EntityUtils.undoGravity(target);
                    if (target instanceof EntityLevitatingBlock) {
                        ((EntityLevitatingBlock)target).suspend();
                    }
                    if (this.field_70165_t > target.field_70165_t && target.field_70159_w < 1.0) {
                        target.field_70159_w += 0.075;
                    } else if (this.field_70165_t < target.field_70165_t && target.field_70159_w > -1.0) {
                        target.field_70159_w -= 0.075;
                    }
                    if (this.field_70163_u > target.field_70163_u && target.field_70181_x < 1.0) {
                        target.field_70181_x += 0.075;
                    } else if (this.field_70163_u < target.field_70163_u && target.field_70181_x > -1.0) {
                        target.field_70181_x -= 0.075;
                    }
                    if (this.field_70161_v > target.field_70161_v && target.field_70179_y < 1.0) {
                        target.field_70179_y += 0.075;
                    } else if (this.field_70161_v < target.field_70161_v && target.field_70179_y > -1.0) {
                        target.field_70179_y -= 0.075;
                    }
                    if (target instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
                    }
                }
                if (!(this.func_70032_d(target) <= 2.0f)) continue;
                if (target instanceof EntityFallingBlock) {
                    target.func_184185_a(WizardrySounds.ENTITY_BLACK_HOLE_BREAK_BLOCK, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    IBlockState state = ((EntityFallingBlock)target).func_175131_l();
                    if (state != null) {
                        this.field_70170_p.func_175718_b(2001, new BlockPos(target), Block.func_176210_f((IBlockState)state));
                    }
                    target.func_70106_y();
                    continue;
                }
                if (this.getCaster() != null) {
                    target.func_70097_a(MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.MAGIC), 2.0f * this.damageMultiplier);
                    continue;
                }
                target.func_70097_a(DamageSource.field_76376_m, 2.0f * this.damageMultiplier);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

