/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.event;

import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class SpellCastEvent
extends Event {
    private final Spell spell;
    private final SpellModifiers modifiers;
    private final Source source;
    private final EntityLivingBase caster;
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final EnumFacing direction;

    public SpellCastEvent(Source source, Spell spell, EntityLivingBase caster, SpellModifiers modifiers) {
        this.spell = spell;
        this.modifiers = modifiers;
        this.source = source;
        this.caster = caster;
        this.world = caster.field_70170_p;
        this.x = Double.NaN;
        this.y = Double.NaN;
        this.z = Double.NaN;
        this.direction = null;
    }

    public SpellCastEvent(Source source, Spell spell, World world, double x, double y, double z, EnumFacing direction, SpellModifiers modifiers) {
        this.spell = spell;
        this.modifiers = modifiers;
        this.source = source;
        this.caster = null;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellModifiers getModifiers() {
        return this.modifiers;
    }

    public Source getSource() {
        return this.source;
    }

    @Nullable
    public EntityLivingBase getCaster() {
        return this.caster;
    }

    public World getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Nullable
    public EnumFacing getDirection() {
        return this.direction;
    }

    public static class Finish
    extends SpellCastEvent {
        private final int count;

        public Finish(Source source, Spell spell, EntityLivingBase caster, SpellModifiers modifiers, int count) {
            super(source, spell, caster, modifiers);
            this.count = count;
        }

        public Finish(Source source, Spell spell, World world, double x, double y, double z, EnumFacing direction, SpellModifiers modifiers, int count) {
            super(source, spell, world, x, y, z, direction, modifiers);
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    @Cancelable
    public static class Tick
    extends SpellCastEvent {
        private final int count;

        public Tick(Source source, Spell spell, EntityLivingBase caster, SpellModifiers modifiers, int count) {
            super(source, spell, caster, modifiers);
            this.count = count;
        }

        public Tick(Source source, Spell spell, World world, double x, double y, double z, EnumFacing direction, SpellModifiers modifiers, int count) {
            super(source, spell, world, x, y, z, direction, modifiers);
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class Post
    extends SpellCastEvent {
        public Post(Source source, Spell spell, EntityLivingBase caster, SpellModifiers modifiers) {
            super(source, spell, caster, modifiers);
        }

        public Post(Source source, Spell spell, World world, double x, double y, double z, EnumFacing direction, SpellModifiers modifiers) {
            super(source, spell, world, x, y, z, direction, modifiers);
        }
    }

    @Cancelable
    public static class Pre
    extends SpellCastEvent {
        public Pre(Source source, Spell spell, EntityLivingBase caster, SpellModifiers modifiers) {
            super(source, spell, caster, modifiers);
        }

        public Pre(Source source, Spell spell, World world, double x, double y, double z, EnumFacing direction, SpellModifiers modifiers) {
            super(source, spell, world, x, y, z, direction, modifiers);
        }
    }

    public static enum Source {
        WAND,
        SCROLL,
        COMMAND,
        NPC,
        DISPENSER,
        OTHER;

    }
}

