/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.inventory;

import electroblob.wizardry.block.BlockBookshelf;
import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.inventory.SlotBookList;
import electroblob.wizardry.inventory.SlotItemClassList;
import electroblob.wizardry.inventory.SlotItemList;
import electroblob.wizardry.inventory.SlotWorkbenchItem;
import electroblob.wizardry.inventory.VirtualSlot;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.util.ISpellSortable;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ContainerArcaneWorkbench
extends Container
implements ISpellSortable {
    public TileEntityArcaneWorkbench tileentity;
    public static final ResourceLocation EMPTY_SLOT_CRYSTAL = new ResourceLocation("ebwizardry", "gui/container/empty_slot_crystal");
    public static final ResourceLocation EMPTY_SLOT_UPGRADE = new ResourceLocation("ebwizardry", "gui/container/empty_slot_upgrade");
    public static final int CRYSTAL_SLOT = 8;
    public static final int CENTRE_SLOT = 9;
    public static final int UPGRADE_SLOT = 10;
    public static final int SLOT_RADIUS = 42;
    public static final int BOOKSHELF_SLOTS_X = 5;
    public static final int BOOKSHELF_SLOTS_Y = 10;
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public static final int BOOKSHELF_UI_WIDTH = 122;
    private List<VirtualSlot> bookshelfSlots = new ArrayList<VirtualSlot>();
    private List<VirtualSlot> activeBookshelfSlots = new ArrayList<VirtualSlot>();
    private boolean hasBookshelves;
    private int scroll = 0;
    private ISpellSortable.SortType sortType = ISpellSortable.SortType.TIER;
    private boolean sortDescending = false;
    private String searchText = "";
    public boolean needsRefresh;

    public ContainerArcaneWorkbench(IInventory inventory, TileEntityArcaneWorkbench tileentity) {
        int x;
        int y;
        this.tileentity = tileentity;
        ItemStack wand = tileentity.func_70301_a(9);
        for (int i = 0; i < 8; ++i) {
            SlotItemClassList slot = new SlotItemClassList(tileentity, i, -999, -999, 1, ItemSpellBook.class);
            this.func_75146_a(slot);
        }
        this.func_75146_a(new SlotItemList(tileentity, 8, 13, 101, 64, WizardryItems.magic_crystal, WizardryItems.crystal_shard, WizardryItems.grand_crystal)).setBackgroundName(EMPTY_SLOT_CRYSTAL.toString());
        this.func_75146_a(new SlotWorkbenchItem(tileentity, 9, 80, 64, this));
        HashSet<Item> upgrades = new HashSet<Item>(WandHelper.getSpecialUpgrades());
        upgrades.add(WizardryItems.arcane_tome);
        upgrades.add(WizardryItems.resplendent_thread);
        upgrades.add(WizardryItems.crystal_silver_plating);
        upgrades.add(WizardryItems.ethereal_crystalweave);
        this.func_75146_a(new SlotItemList(tileentity, 10, 147, 17, 1, upgrades.toArray(new Item[0]))).setBackgroundName(EMPTY_SLOT_UPGRADE.toString());
        for (int x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot(inventory, x2, 8 + x2 * 18, 196));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(inventory, 9 + x + y * 9, 8 + x * 18, 138 + y * 18));
            }
        }
        for (y = 0; y < 10; ++y) {
            for (x = 0; x < 5; ++x) {
                int index = x + y * 5;
                this.func_75146_a(new SlotBookList((IInventory)tileentity, 11 + index, 8 + x * 18, 34 + y * 18, this, index));
            }
        }
        this.refreshBookshelfSlots();
        this.onSlotChanged(9, wand, null);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileentity.func_70300_a(player);
    }

    private void showSlot(int index, int x, int y) {
        Slot slot = this.func_75139_a(index);
        slot.field_75223_e = x;
        slot.field_75221_f = y;
    }

    private void hideSlot(int index, EntityPlayer player) {
        Slot slot = this.func_75139_a(index);
        slot.field_75223_e = -999;
        slot.field_75221_f = -999;
        ItemStack stack = slot.func_75211_c();
        ItemStack remainder = this.func_82846_b(player, index);
        if (remainder == ItemStack.field_190927_a && stack != ItemStack.field_190927_a) {
            slot.func_75215_d(ItemStack.field_190927_a);
            if (player != null) {
                player.func_71019_a(stack, false);
            }
        }
    }

    public void onSlotChanged(int slotNumber, ItemStack stack, EntityPlayer player) {
        block3: {
            int i;
            block4: {
                if (slotNumber != 9) break block3;
                if (!stack.func_190926_b()) break block4;
                for (int i2 = 0; i2 < 8; ++i2) {
                    this.hideSlot(i2, player);
                }
                break block3;
            }
            if (!(stack.func_77973_b() instanceof IWorkbenchItem)) break block3;
            int spellSlots = ((IWorkbenchItem)stack.func_77973_b()).getSpellSlotCount(stack);
            int centreX = this.func_75139_a((int)9).field_75223_e;
            int centreY = this.func_75139_a((int)9).field_75221_f;
            for (i = 0; i < spellSlots; ++i) {
                int x = centreX + ContainerArcaneWorkbench.getBookSlotXOffset(i, spellSlots);
                int y = centreY + ContainerArcaneWorkbench.getBookSlotYOffset(i, spellSlots);
                this.showSlot(i, x, y);
            }
            for (i = spellSlots; i < 8; ++i) {
                this.hideSlot(i, player);
            }
        }
    }

    public static int getBookSlotXOffset(int i, int bookSlotCount) {
        float angle = (float)i * ((float)Math.PI * 2) / (float)bookSlotCount;
        return Math.round(42.0f * MathHelper.func_76126_a((float)angle));
    }

    public static int getBookSlotYOffset(int i, int bookSlotCount) {
        float angle = (float)i * ((float)Math.PI * 2) / (float)bookSlotCount;
        return Math.round(42.0f * -MathHelper.func_76134_b((float)angle));
    }

    public ItemStack func_82846_b(EntityPlayer player, int clickedSlotId) {
        ItemStack remainder = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlotId);
        if (slot != null && slot.func_75216_d()) {
            int[] slotRange;
            ItemStack stack = slot.func_75211_c();
            remainder = stack.func_77946_l();
            if (clickedSlotId <= 10 ? !this.mergeStackIntoBookshelves(stack) && !this.func_75135_a(stack, 11, 47, true) : (this.func_75139_a(clickedSlotId) instanceof VirtualSlot ? ((slotRange = this.findSlotRangeForItem(stack)) == null || !this.func_75135_a(stack, slotRange[0], slotRange[1] + 1, false)) && !this.func_75135_a(stack, 11, 47, true) : ((slotRange = this.findSlotRangeForItem(stack)) == null || !this.func_75135_a(stack, slotRange[0], slotRange[1] + 1, false)) && !this.mergeStackIntoBookshelves(stack))) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == remainder.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return remainder;
    }

    @Nullable
    private int[] findSlotRangeForItem(ItemStack stack) {
        if (this.func_75139_a(0).func_75214_a(stack)) {
            int spellSlots;
            ItemStack centreStack = this.func_75139_a(9).func_75211_c();
            if (centreStack.func_77973_b() instanceof IWorkbenchItem && (spellSlots = ((IWorkbenchItem)centreStack.func_77973_b()).getSpellSlotCount(centreStack)) > 0) {
                return new int[]{0, spellSlots - 1};
            }
        } else {
            if (this.func_75139_a(8).func_75214_a(stack)) {
                return new int[]{8, 8};
            }
            if (this.func_75139_a(9).func_75214_a(stack)) {
                return new int[]{9, 9};
            }
            if (this.func_75139_a(10).func_75214_a(stack)) {
                return new int[]{10, 10};
            }
        }
        return null;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stack;
        if (slotId > 0 && this.func_75139_a(slotId) instanceof SlotBookList && !(stack = player.field_71071_by.func_70445_o()).func_190926_b() && !this.getBookshelfSlots().isEmpty()) {
            this.mergeStackIntoBookshelves(stack);
            return stack;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private boolean mergeStackIntoBookshelves(ItemStack stack) {
        if (this.tileentity.func_145831_w().field_72995_K) {
            this.needsRefresh = true;
        }
        LinkedHashSet<VirtualSlot> slots = new LinkedHashSet<VirtualSlot>(this.bookshelfSlots.size());
        slots.addAll(this.bookshelfSlots.stream().filter(s -> InventoryUtils.canMerge(stack, s.func_75211_c())).collect(Collectors.toList()));
        slots.addAll(this.bookshelfSlots.stream().filter(s -> InventoryUtils.canMerge(stack, s.getPrevStack())).collect(Collectors.toList()));
        slots.addAll(this.bookshelfSlots.stream().filter(s -> s.getPrevStack().func_190926_b()).collect(Collectors.toList()));
        slots.addAll(this.bookshelfSlots.stream().filter(s -> !s.func_75216_d()).collect(Collectors.toList()));
        slots.removeIf(s -> !s.func_75214_a(stack));
        for (Slot slot : slots) {
            int maxSize;
            ItemStack contents = slot.func_75211_c();
            if (contents.func_190926_b()) {
                slot.func_75215_d(stack.func_77979_a(contents.func_77976_d()));
                if (!stack.func_190926_b()) continue;
                return true;
            }
            int totalItemCount = contents.func_190916_E() + stack.func_190916_E();
            if (totalItemCount <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                stack.func_190920_e(0);
                contents.func_190920_e(totalItemCount);
                slot.func_75218_e();
                return true;
            }
            if (contents.func_190916_E() >= maxSize) continue;
            stack.func_190918_g(maxSize - contents.func_190916_E());
            contents.func_190920_e(maxSize);
            slot.func_75218_e();
        }
        return false;
    }

    public void onApplyButtonPressed(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellBindEvent(player, this))) {
            return;
        }
        Slot centre = this.func_75139_a(9);
        if (centre.func_75211_c().func_77973_b() instanceof IWorkbenchItem) {
            Slot[] spellBooks = this.field_75151_b.subList(0, 8).toArray(new Slot[8]);
            if (((IWorkbenchItem)centre.func_75211_c().func_77973_b()).onApplyButtonPressed(player, centre, this.func_75139_a(8), this.func_75139_a(10), spellBooks) && player instanceof EntityPlayerMP) {
                WizardryAdvancementTriggers.arcane_workbench.trigger((EntityPlayerMP)player, centre.func_75211_c());
            }
        }
    }

    public void scrollTo(int row) {
        this.scroll = row;
    }

    public void setSortType(ISpellSortable.SortType sortType) {
        if (this.sortType == sortType) {
            this.sortDescending = !this.sortDescending;
        } else {
            this.sortType = sortType;
            this.sortDescending = false;
        }
        this.updateActiveBookshelfSlots();
    }

    @Override
    public ISpellSortable.SortType getSortType() {
        return this.sortType;
    }

    @Override
    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public void setSearchText(@Nonnull String searchText) {
        this.searchText = searchText;
        this.scrollTo(0);
        this.updateActiveBookshelfSlots();
    }

    public List<VirtualSlot> getBookshelfSlots() {
        ArrayList<VirtualSlot> validSlots = new ArrayList<VirtualSlot>(this.bookshelfSlots);
        validSlots.removeIf(s -> !s.isValid());
        return validSlots;
    }

    public void updateActiveBookshelfSlots() {
        this.activeBookshelfSlots = this.bookshelfSlots.stream().filter(s -> s.isValid() && !s.func_75211_c().func_190926_b() && this.func_75139_a(0).func_75214_a(s.func_75211_c()) && Spell.byMetadata(s.func_75211_c().func_77960_j()).matches(this.searchText)).sorted(Comparator.comparing(s -> Spell.byMetadata(s.func_75211_c().func_77960_j()), this.sortDescending ? this.sortType.comparator.reversed() : this.sortType.comparator)).collect(Collectors.toList());
    }

    public List<VirtualSlot> getActiveBookshelfSlots() {
        return this.activeBookshelfSlots;
    }

    public List<VirtualSlot> getVisibleBookshelfSlots() {
        List<VirtualSlot> activeSlots = this.getActiveBookshelfSlots();
        return activeSlots.subList(5 * this.scroll, activeSlots.size());
    }

    public boolean hasBookshelves() {
        return this.hasBookshelves;
    }

    public void refreshBookshelfSlots() {
        this.field_75151_b.removeIf(s -> s instanceof VirtualSlot && !((VirtualSlot)((Object)s)).isValid());
        this.bookshelfSlots.removeIf(s -> !s.isValid());
        List<IInventory> bookshelves = BlockBookshelf.findNearbyBookshelves(this.tileentity.func_145831_w(), this.tileentity.func_174877_v(), this.tileentity);
        if (bookshelves.isEmpty() == this.hasBookshelves) {
            for (Slot slot : this.field_75151_b) {
                if (slot instanceof SlotBookList || slot instanceof VirtualSlot) continue;
                slot.field_75223_e = slot.field_75223_e + (bookshelves.isEmpty() ? -122 : 122);
            }
            this.hasBookshelves = !bookshelves.isEmpty();
        }
        bookshelves.removeIf(b -> this.bookshelfSlots.stream().anyMatch(s -> s.field_75224_c == b));
        if (!bookshelves.isEmpty()) {
            for (IInventory bookshelf : bookshelves) {
                for (int i = 0; i < bookshelf.func_70302_i_(); ++i) {
                    VirtualSlot slot = new VirtualSlot(bookshelf, i);
                    this.bookshelfSlots.add(slot);
                    this.func_75146_a(slot);
                }
            }
        }
        if (this.tileentity.func_145831_w().field_72995_K) {
            this.updateActiveBookshelfSlots();
        }
    }
}

