/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.potion;

import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.NBTExtras;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PotionContainment
extends PotionMagicEffect {
    public static final String ENTITY_TAG = "containmentPos";
    private static final double RUBBERBAND_THRESHOLD = 0.24;

    public PotionContainment(boolean isBadEffect, int liquidColour) {
        super(isBadEffect, liquidColour, new ResourceLocation("ebwizardry", "textures/gui/potion_icons/containment.png"));
        this.func_76390_b("potion.ebwizardry:containment");
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public static float getContainmentDistance(int effectStrength) {
        return 15 - effectStrength * 4;
    }

    @Override
    public void func_76394_a(EntityLivingBase target, int strength) {
        float maxDistance = PotionContainment.getContainmentDistance(strength);
        if (!target.getEntityData().func_74764_b(ENTITY_TAG)) {
            NBTExtras.storeTagSafely(target.getEntityData(), ENTITY_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)new BlockPos(target.func_174791_d().func_178786_a(0.5, 0.5, 0.5))));
        }
        Vec3d origin = GeometryUtils.getCentre(NBTUtil.func_186861_c((NBTTagCompound)target.getEntityData().func_74775_l(ENTITY_TAG)));
        double x = target.field_70165_t;
        double y = target.field_70163_u;
        double z = target.field_70161_v;
        if (target.func_174813_aQ().field_72336_d > origin.field_72450_a + (double)maxDistance) {
            x = origin.field_72450_a + (double)maxDistance - (double)(target.field_70130_N / 2.0f);
        }
        if (target.func_174813_aQ().field_72340_a < origin.field_72450_a - (double)maxDistance) {
            x = origin.field_72450_a - (double)maxDistance + (double)(target.field_70130_N / 2.0f);
        }
        if (target.func_174813_aQ().field_72337_e > origin.field_72448_b + (double)maxDistance) {
            y = origin.field_72448_b + (double)maxDistance - (double)target.field_70131_O;
        }
        if (target.func_174813_aQ().field_72338_b < origin.field_72448_b - (double)maxDistance) {
            y = origin.field_72448_b - (double)maxDistance;
        }
        if (target.func_174813_aQ().field_72334_f > origin.field_72449_c + (double)maxDistance) {
            z = origin.field_72449_c + (double)maxDistance - (double)(target.field_70130_N / 2.0f);
        }
        if (target.func_174813_aQ().field_72339_c < origin.field_72449_c - (double)maxDistance) {
            z = origin.field_72449_c - (double)maxDistance + (double)(target.field_70130_N / 2.0f);
        }
        if (x != target.field_70165_t || y != target.field_70163_u || z != target.field_70161_v) {
            if (target instanceof EntityPlayer) {
                x = MathHelper.func_151237_a((double)x, (double)(target.field_70165_t - 0.24), (double)(target.field_70165_t + 0.24));
                y = MathHelper.func_151237_a((double)y, (double)(target.field_70163_u - 0.24), (double)(target.field_70163_u + 0.24));
                z = MathHelper.func_151237_a((double)z, (double)(target.field_70161_v - 0.24), (double)(target.field_70161_v + 0.24));
            }
            EntityUtils.undoGravity((Entity)target);
            target.func_70024_g(0.35 * Math.signum(x - target.field_70165_t), 0.35 * Math.signum(y - target.field_70163_u), 0.35 * Math.signum(z - target.field_70161_v));
            target.func_70634_a(x, y, z);
            if (target instanceof EntityPlayerMP) {
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
            }
        }
        if (target.func_70660_b((Potion)this).func_76459_b() <= 1) {
            target.getEntityData().func_82580_o(ENTITY_TAG);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70173_aa % 20 == 0 && event.getEntityLiving().getEntityData().func_74764_b(ENTITY_TAG) && !event.getEntityLiving().func_70644_a(WizardryPotions.containment)) {
            event.getEntityLiving().getEntityData().func_82580_o(ENTITY_TAG);
        }
    }
}

