/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EmpoweringPresence
extends SpellAreaEffect {
    public EmpoweringPresence() {
        super("empowering_presence", SpellActions.POINT_UP, false);
        this.alwaysSucceed(true);
        this.targetAllies(true);
        this.addProperties("effect_duration", "effect_strength");
    }

    @Override
    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityPlayer || target instanceof ISpellCaster) {
            int bonusAmplifier = SpellBuff.getStandardBonusAmplifier(modifiers.get("potency"));
            target.func_70690_d(new PotionEffect(WizardryPotions.empowerment, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + bonusAmplifier));
        }
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z) {
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.03, 0.0).time(50).clr(0.5f, 0.4f, 0.75f).spawn(world);
    }

    @Override
    protected String getTranslationKey() {
        return Wizardry.tisTheSeason ? super.getTranslationKey() + "_festive" : super.getTranslationKey();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() != null && event.getCaster().func_70644_a(WizardryPotions.empowerment) && !(event.getSpell() instanceof EmpoweringPresence)) {
            float potency = 1.0f + 0.25f * (float)(event.getCaster().func_70660_b(WizardryPotions.empowerment).func_76458_c() + 1);
            event.getModifiers().set("potency", event.getModifiers().get("potency") * potency, true);
        }
    }
}

