/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.tileentity;

import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryLoot;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.tileentity.TileEntityReceptacle;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityImbuementAltar
extends TileEntity
implements ITickable {
    private static final int IMBUEMENT_DURATION = 140;
    private ItemStack stack = ItemStack.field_190927_a;
    private int imbuementTimer;
    private Element displayElement;
    private EntityPlayer lastUser;
    private UUID lastUserUUID;

    public void setStack(ItemStack stack) {
        this.stack = stack;
        this.checkRecipe();
    }

    public void setLastUser(EntityPlayer player) {
        this.lastUser = player;
    }

    public void checkRecipe() {
        if (this.getResult().func_190926_b()) {
            this.imbuementTimer = 0;
        } else if (this.imbuementTimer == 0) {
            this.imbuementTimer = 1;
        } else {
            return;
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void func_73660_a() {
        if (this.lastUserUUID != null && this.lastUser == null) {
            this.lastUser = this.field_145850_b.func_152378_a(this.lastUserUUID);
        }
        if (this.imbuementTimer > 0) {
            ItemStack result;
            if (this.imbuementTimer == 1) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, WizardrySounds.BLOCK_IMBUEMENT_ALTAR_IMBUE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if ((result = this.getResult()).func_190926_b()) {
                this.imbuementTimer = 0;
            } else {
                if (this.imbuementTimer++ >= 140) {
                    this.stack = result;
                    this.consumeReceptacleContents();
                    this.imbuementTimer = 0;
                    this.displayElement = null;
                    if (this.lastUser instanceof EntityPlayerMP) {
                        WizardryAdvancementTriggers.imbuement_altar.trigger((EntityPlayerMP)this.lastUser, this.stack);
                    }
                }
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(2) == 0) {
                    Element[] elements = this.getReceptacleElements();
                    Vec3d centre = GeometryUtils.getCentre(this.field_174879_c.func_177984_a());
                    for (int i = 0; i < elements.length; ++i) {
                        if (elements[i] == null) continue;
                        Vec3d offset = new Vec3d(EnumFacing.func_176731_b((int)i).func_176730_m());
                        Vec3d vec = GeometryUtils.getCentre(this.field_174879_c).func_72441_c(0.0, 0.3, 0.0).func_178787_e(offset.func_186678_a(0.7));
                        int[] colours = BlockReceptacle.PARTICLE_COLOURS.get((Object)elements[i]);
                        ParticleBuilder.create(ParticleBuilder.Type.DUST, this.field_145850_b.field_73012_v, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.1, false).vel(centre.func_178788_d(vec).func_186678_a(0.02)).clr(colours[1]).fade(colours[2]).time(50).spawn(this.field_145850_b);
                    }
                }
            }
        }
    }

    public Element getDisplayElement() {
        return this.displayElement;
    }

    public float getImbuementProgress() {
        return (float)this.imbuementTimer / 140.0f;
    }

    private ItemStack getResult() {
        boolean actuallyCrafting = this.imbuementTimer >= 139 && this.field_145850_b instanceof WorldServer;
        Element[] elements = this.getReceptacleElements();
        ItemStack result = TileEntityImbuementAltar.getImbuementResult(this.stack, elements, actuallyCrafting, this.field_145850_b, this.lastUser);
        this.displayElement = result.func_190926_b() ? null : (Arrays.stream(elements).distinct().count() == 1L ? elements[0] : Element.MAGIC);
        return result;
    }

    private Element[] getReceptacleElements() {
        Element[] elements = new Element[4];
        for (EnumFacing side : EnumFacing.field_176754_o) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            elements[side.func_176736_b()] = tileEntity instanceof TileEntityReceptacle ? ((TileEntityReceptacle)tileEntity).getElement() : null;
        }
        return elements;
    }

    private void consumeReceptacleContents() {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (!(tileEntity instanceof TileEntityReceptacle)) continue;
            ((TileEntityReceptacle)tileEntity).setElement(null);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound itemTag = new NBTTagCompound();
        this.stack.func_77955_b(itemTag);
        nbt.func_74782_a("item", (NBTBase)itemTag);
        nbt.func_74768_a("imbuementTimer", this.imbuementTimer);
        if (this.lastUser != null) {
            nbt.func_186854_a("lastUser", this.lastUser.func_110124_au());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound itemTag = nbt.func_74775_l("item");
        this.stack = new ItemStack(itemTag);
        this.imbuementTimer = nbt.func_74762_e("imbuementTimer");
        this.lastUserUUID = nbt.func_186857_a("lastUser");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public static ItemStack getImbuementResult(ItemStack input, Element[] receptacleElements, boolean fullLootGen, World world, EntityPlayer lastUser) {
        if (input.func_77973_b() instanceof ItemWizardArmour && ((ItemWizardArmour)input.func_77973_b()).element == null && Arrays.stream(receptacleElements).distinct().count() == 1L && receptacleElements[0] != null) {
            ItemStack result = new ItemStack(ItemWizardArmour.getArmour(receptacleElements[0], ((ItemWizardArmour)input.func_77973_b()).armourClass, ((ItemWizardArmour)input.func_77973_b()).field_77881_a));
            result.func_77982_d(input.func_77978_p());
            ((IManaStoringItem)result.func_77973_b()).setMana(result, ((ItemWizardArmour)input.func_77973_b()).getMana(input));
            return result;
        }
        if ((input.func_77973_b() == WizardryItems.magic_crystal || input.func_77973_b() == Item.func_150898_a((Block)WizardryBlocks.crystal_block)) && input.func_77960_j() == 0 && Arrays.stream(receptacleElements).distinct().count() == 1L && receptacleElements[0] != null) {
            return new ItemStack(input.func_77973_b(), input.func_190916_E(), receptacleElements[0].ordinal());
        }
        if (input.func_77973_b() == WizardryItems.ruined_spell_book && !ArrayUtils.contains((Object[])receptacleElements, null)) {
            if (fullLootGen) {
                Element element = receptacleElements[world.field_73012_v.nextInt(receptacleElements.length)];
                LootTable table = world.func_184146_ak().func_186521_a(WizardryLoot.RUINED_SPELL_BOOK_LOOT_TABLES[element.ordinal() - 1]);
                LootContext context = new LootContext.Builder((WorldServer)world).func_186470_a(lastUser).func_186469_a(lastUser == null ? 0.0f : lastUser.func_184817_da()).func_186471_a();
                List stacks = table.func_186462_a(world.field_73012_v, context);
                return stacks.isEmpty() ? ItemStack.field_190927_a : (ItemStack)stacks.get(0);
            }
            return new ItemStack(WizardryItems.spell_book);
        }
        return ItemStack.field_190927_a;
    }
}

