/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.items;

import galaxyspace.core.handler.GSItemCanisterGenericHandler;
import galaxyspace.core.util.GSCreativeTabs;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.JavaUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidCanisterGS
extends ItemCanisterGeneric
implements ISortableItem {
    private Fluid fluid;
    private int amount;

    public ItemFluidCanisterGS(String assetName, Fluid fluid) {
        this(assetName, fluid, 1001);
    }

    public ItemFluidCanisterGS(String assetName, Fluid fluid, int amount) {
        super(assetName);
        this.fluid = fluid;
        this.amount = amount;
        this.setAllowedFluid(fluid.getName());
        this.func_77656_e(amount);
    }

    public CreativeTabs func_77640_w() {
        return GSCreativeTabs.GSItemsTab;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.COMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GSCreativeTabs.GSItemsTab || tab == CreativeTabs.field_78027_g) {
            list.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (par1ItemStack.func_77958_k() - par1ItemStack.func_77952_i() > 0) {
            tooltip.add(GCCoreUtil.translate((String)this.fluid.getUnlocalizedName()) + ": " + (par1ItemStack.func_77958_k() - par1ItemStack.func_77952_i()));
        }
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.CANISTER;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new GSItemCanisterGenericHandler(stack, this.amount);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (CompatibilityManager.isTELoaded() && JavaUtil.instance.isCalledBy("thermalexpansion.block.machine.TileTransposer")) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(this.func_77668_q(), 1, this.amount);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (this.amount == par1ItemStack.func_77952_i()) {
            if (par1ItemStack.func_77973_b() != GCItems.oilCanister) {
                this.replaceEmptyCanisterItem(par1ItemStack, GCItems.oilCanister);
            }
            par1ItemStack.func_77982_d(null);
        } else if (par1ItemStack.func_77952_i() <= 0) {
            par1ItemStack.func_77964_b(1);
        }
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || resource.amount <= 0 || container == null || container.func_77952_i() <= 1 || !(container.func_77973_b() instanceof ItemCanisterGeneric)) {
            return 0;
        }
        String fluidName = resource.getFluid().getName();
        int capacityPlusOne = container.func_77952_i();
        if (capacityPlusOne <= 1) {
            if (capacityPlusOne < 1) {
                container.func_77964_b(1);
            }
            return 0;
        }
        if (capacityPlusOne >= this.amount) {
            for (ItemCanisterGeneric i : GCItems.canisterTypes) {
                if (!fluidName.equalsIgnoreCase(i.getAllowedFluid())) continue;
                if (!doFill) {
                    return Math.min(resource.amount, this.capacity);
                }
                this.replaceEmptyCanisterItem(container, (Item)i);
                break;
            }
            if (capacityPlusOne > this.amount) {
                capacityPlusOne = 1001;
                container.func_77964_b(capacityPlusOne);
            }
        }
        if (fluidName.equalsIgnoreCase(((ItemCanisterGeneric)container.func_77973_b()).getAllowedFluid())) {
            int added = Math.min(resource.amount, capacityPlusOne - 1);
            if (doFill && added > 0) {
                container.func_77964_b(Math.max(1, container.func_77952_i() - added));
            }
            return added;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.getAllowedFluid() == null || container.func_77952_i() >= this.amount) {
            return null;
        }
        FluidStack used = this.getFluid(container);
        if (used != null && used.amount > maxDrain) {
            used.amount = maxDrain;
        }
        if (doDrain && used != null && used.amount > 0) {
            this.setNewDamage(container, container.func_77952_i() + used.amount);
        }
        return used;
    }

    protected void setNewDamage(ItemStack container, int newDamage) {
        newDamage = Math.min(newDamage, this.amount);
        container.func_77964_b(newDamage);
        if (newDamage == this.amount && container.func_77973_b() != GCItems.oilCanister) {
            this.replaceEmptyCanisterItem(container, GCItems.oilCanister);
            return;
        }
    }

    private void replaceEmptyCanisterItem(ItemStack container, Item newItem) {
        try {
            Class<?> itemStack = container.getClass();
            Field itemId = itemStack.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "item" : "field_151002_e");
            itemId.setAccessible(true);
            itemId.set(container, newItem);
            Method forgeInit = itemStack.getDeclaredMethod("forgeInit", new Class[0]);
            forgeInit.setAccessible(true);
            forgeInit.invoke((Object)container, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

