/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.miranda.blocks;

import galaxyspace.core.GSItems;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MirandaBlocks
extends Block
implements ISortableBlock {
    public static final PropertyEnum<EnumMirandaBlocks> BASIC_TYPE = PropertyEnum.func_177709_a((String)"type", EnumMirandaBlocks.class);

    public MirandaBlocks() {
        super(Material.field_151576_e);
        this.func_149663_c("mirandablocks");
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumMirandaBlocks blockBasic : EnumMirandaBlocks.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockBasic.getMeta()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        if (state == this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumMirandaBlocks.MIRANDA_ICE))) {
            return 0.98f;
        }
        return this.field_149765_K;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        EnumMirandaBlocks type = (EnumMirandaBlocks)((Object)state.func_177229_b(BASIC_TYPE));
        switch (type) {
            case MIRANDA_ICE: {
                return Items.field_190931_a;
            }
            case MIRANDA_DOLOMITE_ORE: {
                return GSItems.BASIC;
            }
            case MIRANDA_DIAMOND_ORE: {
                return Items.field_151045_i;
            }
            case MIRANDA_QUARTZ_ORE: {
                return Items.field_151128_bU;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        block5: for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            EnumMirandaBlocks type = (EnumMirandaBlocks)((Object)state.func_177229_b(BASIC_TYPE));
            switch (type) {
                case MIRANDA_DOLOMITE_ORE: {
                    drops.add((Object)new ItemStack(item, 1, 3));
                    continue block5;
                }
                case MIRANDA_DIAMOND_ORE: {
                    drops.add((Object)new ItemStack(item, 1, 0));
                    continue block5;
                }
                case MIRANDA_QUARTZ_ORE: {
                    drops.add((Object)new ItemStack(item, 1, 0));
                    continue block5;
                }
                default: {
                    drops.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumMirandaBlocks.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMirandaBlocks)((Object)state.func_177229_b(BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    public static enum EnumMirandaBlocks implements IStringSerializable
    {
        MIRANDA_GRUNT(0, "miranda_grunt"),
        MIRANDA_SUBGRUNT(1, "miranda_subgrunt"),
        MIRANDA_STONE(2, "miranda_stone"),
        MIRANDA_IRON_ORE(3, "miranda_iron_ore"),
        MIRANDA_DOLOMITE_ORE(4, "miranda_dolomite_ore"),
        MIRANDA_DIAMOND_ORE(5, "miranda_diamond_ore"),
        MIRANDA_QUARTZ_ORE(6, "miranda_quartz_ore"),
        MIRANDA_COBALT_ORE(7, "miranda_cobalt_ore"),
        MIRANDA_NICKEL_ORE(8, "miranda_nickel_ore"),
        MIRANDA_GRUNT_2(9, "miranda_grunt_2"),
        MIRANDA_GRUNT_3(10, "miranda_grunt_3"),
        MIRANDA_SUBGRUNT_2(11, "miranda_subgrunt_2"),
        MIRANDA_SUBGRUNT_3(12, "miranda_subgrunt_3"),
        MIRANDA_STONE_2(13, "miranda_stone_2"),
        MIRANDA_STONE_3(14, "miranda_stone_3"),
        MIRANDA_ICE(15, "miranda_ice");

        private final int meta;
        private final String name;
        private static final EnumMirandaBlocks[] values;

        private EnumMirandaBlocks(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumMirandaBlocks byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumMirandaBlocks.values();
        }
    }
}

