/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.satellites.venus.dimension;

import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.planets.ceres.world.gen.BiomeProviderCeres;
import galaxyspace.systems.SolarSystem.satellites.venus.dimension.ChunkProviderVenusSS;
import galaxyspace.systems.SolarSystem.satellites.venus.dimension.sky.SkyProviderVenusSS;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderVenusSS
extends WorldProviderSpaceStation
implements IOrbitDimension,
ISolarLevel,
IExitHeight {
    public DimensionType func_186058_p() {
        return GSDimensions.VENUS_SS;
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3 getFogColor() {
        float night = this.getStarBrightness(1.0f);
        float day = 1.0f - this.getStarBrightness(1.0f);
        float dayColR = 0.79607844f;
        float dayColG = 0.5764706f;
        float dayColB = 0.0f;
        float nightColR = 0.003921569f;
        float nightColG = 0.003921569f;
        float nightColB = 0.003921569f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3 getSkyColor() {
        float night = this.getStarBrightness(1.0f);
        float day = 1.0f - this.getStarBrightness(1.0f);
        float dayColR = 0.4117647f;
        float dayColG = 0.41960785f;
        float dayColB = 1.1019608f;
        float nightColR = 0.007843138f;
        float nightColG = 0.007843138f;
        float nightColB = 0.007843138f;
        return new Vector3((double)(dayColR * day + nightColR * night), (double)(dayColG * day + nightColG * night), (double)(dayColB * day + nightColB * night));
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 24000L;
    }

    public boolean isDaytime() {
        float a = this.field_76579_a.func_72826_c(0.0f);
        return a < 0.42f || a > 0.58f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.2f;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 64;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.venusSpaceStation;
    }

    public float getGravity() {
        return 0.068f;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    public String getPlanetToOrbit() {
        return VenusModule.planetVenus.getUnlocalizedName();
    }

    public int getYCoordToTeleportToPlanet() {
        return 30;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderVenusSS.class;
    }

    public String getSaveFolder() {
        return "DIM_SPACESTATION_VENUS" + this.getDimension();
    }

    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar;
    }

    public double getYCoordinateToTeleport() {
        return 1000.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > 0;
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public void updateWeather() {
        super.updateWeather();
    }

    @SideOnly(value=Side.CLIENT)
    public void setSpinDeltaPerTick(float angle) {
        SkyProviderVenusSS skyProvider = (SkyProviderVenusSS)this.getSkyRenderer();
        if (skyProvider != null) {
            skyProvider.spinDeltaPerTick = angle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getSkyRotation() {
        SkyProviderVenusSS skyProvider = (SkyProviderVenusSS)this.getSkyRenderer();
        return skyProvider.spinAngle;
    }

    @SideOnly(value=Side.CLIENT)
    public void createSkyProvider() {
        this.setSkyRenderer((IRenderHandler)new SkyProviderVenusSS());
        this.setSpinDeltaPerTick(this.getSpinManager().getSpinRate());
        if (this.getCloudRenderer() == null) {
            this.setCloudRenderer(super.getCloudRenderer());
        }
    }

    public int getDungeonSpacing() {
        return 0;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasure.MOONCHEST;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return BiomeProviderCeres.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 10.0f;
    }

    public float getThermalLevelModifier() {
        float angle = this.field_76579_a.func_72826_c((float)this.getDayLength());
        float value = MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * this.getThermalValueMod();
        float def = this.getCelestialBody().atmosphere.thermalLevel();
        if ((double)def < 0.0) {
            value *= -1.0f;
        }
        return def == 0.0f ? value : value * def + def;
    }

    protected float getThermalValueMod() {
        return 0.5f;
    }
}

