/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class FindMachinesCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        MachineRegistry tile = null;
        try {
            tile = MachineRegistry.valueOf(args[0].toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EntityPlayerMP ep = FindMachinesCommand.func_71521_c((ICommandSender)ics);
        if (tile == null) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)(EnumChatFormatting.RED + "'" + args[0] + "' is not a valid RC machine."));
            return;
        }
        Class c = tile.getTEClass();
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        Collection<World> worlds = this.getWorlds(ep, args);
        for (World world : worlds) {
            for (Object o : world.field_147482_g) {
                if (!c.isAssignableFrom(o.getClass())) continue;
                tiles.add((TileEntity)o);
            }
            char e = tiles.isEmpty() ? (char)'.' : ':';
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)(tiles.size() + " " + tile.getName() + " found in world '" + world.field_73011_w.func_80007_l() + "'" + e));
            if (tiles.isEmpty()) continue;
            for (TileEntity te : tiles) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)te.toString());
            }
        }
    }

    private Collection<World> getWorlds(EntityPlayerMP ep, String[] args) {
        ArrayList<World> li = new ArrayList<World>();
        if (args.length == 1) {
            li.add(ep.field_70170_p);
        } else if (args[1].equals("*")) {
            WorldServer[] ids = DimensionManager.getWorlds();
            for (int i = 0; i < ids.length; ++i) {
                li.add((World)ids[i]);
            }
        } else {
            try {
                int dim = Integer.parseInt(args[1]);
                WorldServer world = DimensionManager.getWorld((int)dim);
                if (world != null) {
                    li.add((World)world);
                }
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)(EnumChatFormatting.RED.toString() + "No world exists with dimension ID " + dim + "."));
            }
            catch (NumberFormatException e) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)(EnumChatFormatting.RED.toString() + "\"" + args[1] + "\" is not an integer."));
            }
        }
        return li;
    }

    public String getCommandString() {
        return "findmachines";
    }

    protected boolean isAdminOnly() {
        return true;
    }
}

