/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Instantiable.Recipe.FlexibleIngredient;
import Reika.DragonAPI.Instantiable.Recipe.RecipePattern;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesBlastFurnace
extends RecipeHandler
implements RecipeInterface.BlastFurnaceManager {
    private static final RecipesBlastFurnace BlastFurnaceBase = new RecipesBlastFurnace();
    private final ArrayList<BlastRecipe> recipeList = new ArrayList();
    private final ArrayList<BlastCrafting> craftingList = new ArrayList();
    private final ItemHashMap<HashSet<Integer>> itemInputTypes = new ItemHashMap();

    private RecipesBlastFurnace() {
        super(MachineRegistry.BLASTFURNACE);
        RecipeInterface.blastfurn = this;
        FlexibleIngredient in1 = new FlexibleIngredient(new ItemStack(Items.field_151044_h), 100.0f, 1);
        FlexibleIngredient in2 = new FlexibleIngredient(Items.field_151016_H, 3.6f, 1);
        FlexibleIngredient in3 = new FlexibleIngredient((Block)Blocks.field_150354_m, 0.2f, 1);
        BlastRecipe hsla = new BlastRecipe(in1, in2, in3, Items.field_151042_j, ItemStacks.steelingot, 0.0f, 0.6f, 600);
        this.addRecipe(hsla, RecipeHandler.RecipeLevel.CORE);
        in1 = new FlexibleIngredient(ReikaItemHelper.charcoal, 100.0f, 1);
        in2 = new FlexibleIngredient(Items.field_151016_H, 3.2f, 1);
        in3 = new FlexibleIngredient((Block)Blocks.field_150354_m, 0.2f, 1);
        BlastRecipe hsla1b = new BlastRecipe(in1, in2, in3, Items.field_151042_j, ItemStacks.steelingot, 0.0f, 0.6f, 600);
        this.addRecipe(hsla1b, RecipeHandler.RecipeLevel.CORE);
        in1 = new FlexibleIngredient(ItemStacks.coke, 100.0f, 1);
        in2 = new FlexibleIngredient(Items.field_151016_H, 1.8f, 1);
        in3 = new FlexibleIngredient((Block)Blocks.field_150354_m, 0.1f, 1);
        BlastRecipe hsla2 = new BlastRecipe(in1, in2, in3, Items.field_151042_j, ItemStacks.steelingot, 1.0f, 0.6f, 600);
        this.addRecipe(hsla2, RecipeHandler.RecipeLevel.CORE);
        in1 = new FlexibleIngredient(ItemStacks.coke, 100.0f, 1);
        in2 = new FlexibleIngredient(Items.field_151016_H, 16.199999f, 1);
        in3 = new FlexibleIngredient((Block)Blocks.field_150354_m, 0.90000004f, 1);
        BlastRecipe hslablock = new BlastRecipe(in1, in2, in3, Blocks.field_150339_S, ItemStacks.steelblock, 0.0f, 5.4f, 600);
        hslablock.setNeedsEmpty();
        this.addRecipe(hslablock, RecipeHandler.RecipeLevel.CORE);
        in1 = new FlexibleIngredient(ItemStacks.bedrockdust, 100.0f, 4);
        in2 = FlexibleIngredient.EMPTY;
        in3 = FlexibleIngredient.EMPTY;
        BlastRecipe bedrock = new BlastRecipe(in1, in2, in3, ItemStacks.steelingot, 1, ItemStacks.bedingot, 0.0f, 0.0f, 1450);
        this.addRecipe(bedrock.setAlloy(), RecipeHandler.RecipeLevel.CORE);
        in1 = FlexibleIngredient.EMPTY;
        in2 = FlexibleIngredient.EMPTY;
        in3 = FlexibleIngredient.EMPTY;
        BlastRecipe scrap = new BlastRecipe(in1, in2, in3, ItemStacks.scrap, 9, ItemStacks.steelingot, 0.0f, 0.0f, 600);
        this.addRecipe(scrap, RecipeHandler.RecipeLevel.PROTECTED);
        in1 = FlexibleIngredient.EMPTY;
        in2 = FlexibleIngredient.EMPTY;
        in3 = FlexibleIngredient.EMPTY;
        BlastRecipe coke = new BlastRecipe(in1, in2, in3, new ItemStack(Items.field_151044_h), ItemStacks.coke, 0.0f, 0.0f, 400);
        this.addRecipe(coke, RecipeHandler.RecipeLevel.CORE);
        in1 = ConfigRegistry.OREALUDUST.getState() ? new FlexibleIngredient("dustAluminum", 25.0f, 1) : new FlexibleIngredient(ItemStacks.aluminumpowder, 25.0f, 1);
        in2 = new FlexibleIngredient(Items.field_151065_br, 2.5f, 1);
        in3 = FlexibleIngredient.EMPTY;
        BlastRecipe sili = new BlastRecipe(in1, in2, in3, (Block)Blocks.field_150354_m, ItemStacks.silicondust, 0.8f, 0.0f, 700);
        this.addRecipe(sili, RecipeHandler.RecipeLevel.CORE);
        in1 = new FlexibleIngredient(ItemStacks.coke, 75.0f, 1);
        in2 = new FlexibleIngredient(Items.field_151137_ax, 40.0f, 1);
        in3 = FlexibleIngredient.EMPTY;
        BlastRecipe spring = new BlastRecipe(in1, in2, in3, ItemStacks.steelingot, ItemStacks.springingot, 0.0f, 0.0f, 1000);
        this.addRecipe(spring, RecipeHandler.RecipeLevel.CORE);
        in1 = new FlexibleIngredient(ItemStacks.silicondust, 20.0f, 1);
        in2 = FlexibleIngredient.EMPTY;
        in3 = FlexibleIngredient.EMPTY;
        BlastRecipe silu = new BlastRecipe(in1, in2, in3, "ingotAluminum", ItemStacks.silumin, 0.0f, 0.0f, 900);
        this.addRecipe(silu, RecipeHandler.RecipeLevel.CORE);
        in1 = new FlexibleIngredient(ItemStacks.tungstenflakes, 5.0f, 1);
        in2 = FlexibleIngredient.EMPTY;
        in3 = new FlexibleIngredient(Blocks.field_150343_Z, 20.0f, 1);
        BlastRecipe springtung = new BlastRecipe(in1, in2, in3, ItemStacks.springingot, ItemStacks.springtungsten, 0.0f, 0.0f, 1100);
        this.addRecipe(springtung, RecipeHandler.RecipeLevel.CORE);
    }

    private void addRecipe(BlastRecipe br, RecipeHandler.RecipeLevel rl) {
        this.recipeList.add(br);
        this.itemInputTypes.clear();
        this.onAddRecipe(br, rl);
    }

    public static final RecipesBlastFurnace getRecipes() {
        return BlastFurnaceBase;
    }

    public void addRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        BlastCrafting c = new BlastCrafting(out, temperature, speed, in, xp);
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    public void addAlloyingRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        BlastCrafting c = new BlastCrafting(out, temperature, speed, in, xp).setAlloying();
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    public void add3x3AlloyingRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        ShapedRecipes r = ReikaRecipeHelper.getShapedRecipeFor((ItemStack)out, (Object[])new Object[]{in});
        BlastCrafting c = new BlastCrafting(out, temperature, speed, (IRecipe)r, xp).setAlloying();
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    public void add3x3Crafting(ItemStack out, int temperature, int speed, float xp, Object ... in) {
        ShapedRecipes r = ReikaRecipeHelper.getShapedRecipeFor((ItemStack)out, (Object[])in);
        BlastCrafting c = new BlastCrafting(out, temperature, speed, (IRecipe)r, xp);
        this.addCrafting(c, RecipeHandler.RecipeLevel.CORE);
    }

    private void addCrafting(BlastCrafting cr, RecipeHandler.RecipeLevel rl) {
        this.craftingList.add(cr);
        this.itemInputTypes.clear();
        this.onAddRecipe(cr, rl);
    }

    public BlastCrafting getCrafting(ItemStack[] main, int temp) {
        RecipePattern ic = new RecipePattern(main);
        for (int i = 0; i < this.craftingList.size(); ++i) {
            BlastCrafting c = this.craftingList.get(i);
            if (!c.matches((InventoryCrafting)ic, temp)) continue;
            return c;
        }
        return null;
    }

    public BlastRecipe getRecipe(ItemStack in1, ItemStack in2, ItemStack in3, ItemStack[] main, int temp) {
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (temp < r.temperature || !this.matchRecipe(r, in1, in2, in3, main)) continue;
            return r;
        }
        return null;
    }

    private boolean matchRecipe(BlastRecipe r, ItemStack in1, ItemStack in2, ItemStack in3, ItemStack[] main) {
        if (!r.primary.matchWithSize(in1)) {
            return false;
        }
        if (!r.secondary.matchWithSize(in2)) {
            return false;
        }
        if (!r.tertiary.matchWithSize(in3)) {
            return false;
        }
        int num = 0;
        for (int i = 0; i < main.length; ++i) {
            ItemStack is = main[i];
            if (is == null) continue;
            if (r.isValidMainItem(is)) {
                ++num;
                continue;
            }
            return false;
        }
        return r.matchNumberExactly ? num == ((BlastRecipe)r).main.numberToUse : num >= ((BlastRecipe)r).main.numberToUse;
    }

    public boolean isProduct(ItemStack result) {
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)r.outputItem())) continue;
            return true;
        }
        return false;
    }

    public boolean isInput(ItemStack ingredient) {
        return !this.getInputTypesForItem(ingredient).isEmpty();
    }

    public Set<Integer> getInputTypesForItem(ItemStack is) {
        HashSet<Integer> set = (HashSet<Integer>)this.itemInputTypes.get(is);
        if (set == null) {
            set = new HashSet<Integer>();
            for (int i = 0; i < this.recipeList.size(); ++i) {
                BlastRecipe r = this.recipeList.get(i);
                if (r.isValidMainItem(is)) {
                    set.add(0);
                    continue;
                }
                if (r.primary.match(is)) {
                    set.add(1);
                    continue;
                }
                if (r.secondary.match(is)) {
                    set.add(2);
                    continue;
                }
                if (!r.tertiary.match(is)) continue;
                set.add(3);
            }
            this.itemInputTypes.put(is, set);
        }
        return Collections.unmodifiableSet(set);
    }

    public ArrayList<BlastRecipe> getAllRecipesUsing(ItemStack is) {
        ArrayList<BlastRecipe> li = new ArrayList<BlastRecipe>();
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (r.isValidMainItem(is)) {
                li.add(r);
            }
            if (r.primary.match(is)) {
                li.add(r);
            }
            if (r.secondary.match(is)) {
                li.add(r);
            }
            if (!r.tertiary.match(is)) continue;
            li.add(r);
        }
        return li;
    }

    public ArrayList<BlastRecipe> getAllRecipesMaking(ItemStack is) {
        ArrayList<BlastRecipe> li = new ArrayList<BlastRecipe>();
        for (int i = 0; i < this.recipeList.size(); ++i) {
            BlastRecipe r = this.recipeList.get(i);
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)r.outputItem())) continue;
            li.add(r);
        }
        return li;
    }

    public ArrayList<BlastCrafting> getAllCraftingUsing(ItemStack is) {
        ArrayList<BlastCrafting> li = new ArrayList<BlastCrafting>();
        for (int i = 0; i < this.craftingList.size(); ++i) {
            BlastCrafting r = this.craftingList.get(i);
            if (!r.usesItem(is)) continue;
            li.add(r.copy());
        }
        return li;
    }

    public ArrayList<BlastCrafting> getAllCraftingMaking(ItemStack is) {
        ArrayList<BlastCrafting> li = new ArrayList<BlastCrafting>();
        for (int i = 0; i < this.craftingList.size(); ++i) {
            BlastCrafting r = this.craftingList.get(i);
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)r.outputItem())) continue;
            li.add(r.copy());
        }
        return li;
    }

    public ArrayList<BlastFurnacePattern> getAllAlloyingRecipes() {
        ArrayList<BlastFurnacePattern> li = new ArrayList<BlastFurnacePattern>();
        for (BlastRecipe br : this.recipeList) {
            if (!br.isAlloying()) continue;
            li.add(br);
        }
        for (BlastCrafting bc : this.craftingList) {
            if (!bc.isAlloying()) continue;
            li.add(bc);
        }
        return li;
    }

    public Collection<BlastRecipe> getAllMainlineRecipes() {
        return Collections.unmodifiableCollection(this.recipeList);
    }

    public Collection<BlastCrafting> getAllCraftingRecipes() {
        return Collections.unmodifiableCollection(this.craftingList);
    }

    public Collection<BlastFurnacePattern> getAllRecipes() {
        ArrayList<BlastFurnacePattern> c = new ArrayList<BlastFurnacePattern>();
        c.addAll(this.recipeList);
        c.addAll(this.craftingList);
        return c;
    }

    @Override
    public void addAPIAlloying(Collection<ItemStack> in1, float c1, int decr1, Collection<ItemStack> in2, float c2, int decr2, Collection<ItemStack> in3, float c3, int decr3, ItemStack main, ItemStack out, int req, float bonus, float xp, int temp) {
        FlexibleIngredient b1 = new FlexibleIngredient(in1, in1 != null ? c1 : 0.0f, decr1);
        FlexibleIngredient b2 = new FlexibleIngredient(in2, in2 != null ? c2 : 0.0f, decr2);
        FlexibleIngredient b3 = new FlexibleIngredient(in3, in3 != null ? c3 : 0.0f, decr3);
        BlastRecipe br = req > 0 ? new BlastRecipe(b1, b2, b3, main, req, out, bonus, xp, temp) : new BlastRecipe(b1, b2, b3, main, out, bonus, xp, temp);
        this.addRecipe(br, RecipeHandler.RecipeLevel.API);
    }

    @Override
    public void addAPIRecipe(ItemStack out, int temperature, IRecipe in, int speed, float xp) {
        BlastCrafting bc = new BlastCrafting(out, temperature, speed, in, xp);
        this.addCrafting(bc, RecipeHandler.RecipeLevel.API);
    }

    @Override
    public void addPostLoadRecipes() {
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        this.itemInputTypes.clear();
        return this.recipeList.remove(recipe) | this.craftingList.remove(recipe);
    }

    @Override
    protected boolean addCustomRecipe(String n, LuaBlock lb, CustomRecipeList crl) throws Exception {
        LuaBlock third;
        ItemStack out = CustomRecipeList.parseItemString((String)lb.getString("output"), (LuaBlock)lb.getChild("output_nbt"), (boolean)false);
        this.verifyOutputItem(out);
        Collection main = CustomRecipeList.parseItemCollection((Collection)lb.getChild("main_item").getDataValues(), (boolean)true);
        if (main.isEmpty()) {
            throw new IllegalArgumentException("You need at least one main item!");
        }
        int req = lb.getInt("required_main_item");
        boolean match = lb.getBoolean("match_number_exactly");
        boolean bonus_basic = lb.getBoolean("has_bonus");
        float bonus = (float)lb.getDouble("bonus_yield");
        if (bonus <= 0.0f && bonus_basic) {
            bonus = 1.0f;
        }
        float xp = (float)lb.getDouble("xp");
        int temp = lb.getInt("temperature");
        if (temp > 2000) {
            throw new IllegalArgumentException("Recipe temperature exceeds max temperature (2000)!");
        }
        boolean alloy = lb.getBoolean("alloying");
        LuaBlock first = lb.getChild("primary_input");
        LuaBlock second = lb.hasChild("secondary_input") ? lb.getChild("secondary_input") : null;
        LuaBlock luaBlock = third = lb.hasChild("tertiary_input") ? lb.getChild("tertiary_input") : null;
        if (first == null || second == null && third != null) {
            throw new IllegalArgumentException("Secondary inputs must be specified sequentially: Primary-secondary-tertiary!");
        }
        BlastRecipe br = new BlastRecipe(FlexibleIngredient.parseLua((CustomRecipeList)crl, (LuaBlock)first, (boolean)false), FlexibleIngredient.parseLua((CustomRecipeList)crl, (LuaBlock)second, (boolean)false), FlexibleIngredient.parseLua((CustomRecipeList)crl, (LuaBlock)third, (boolean)false), main, req, out, bonus, xp, temp);
        br.matchNumberExactly = match;
        if (alloy) {
            br.setAlloy();
        }
        this.addRecipe(br, RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    public static final class BlastRecipe
    implements BlastFurnacePattern,
    FlexibleIngredient.IngredientIDHandler {
        public final FlexibleIngredient primary;
        public final FlexibleIngredient secondary;
        public final FlexibleIngredient tertiary;
        private final FlexibleIngredient main;
        private boolean matchNumberExactly;
        private final ItemStack output;
        public final float bonusYield;
        public final float xp;
        public final int temperature;
        private boolean alloy;
        private boolean needsEmpty;

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, Item main, ItemStack out, float bonus, float xp, int temp) {
            this(in1, in2, in3, new ItemStack(main), out, bonus, xp, temp);
        }

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, Block main, ItemStack out, float bonus, float xp, int temp) {
            this(in1, in2, in3, new ItemStack(main), out, bonus, xp, temp);
        }

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, Collection<ItemStack> main, ItemStack out, float bonus, float xp, int temp) {
            this(in1, in2, in3, main, 1, out, bonus, xp, temp);
            this.matchNumberExactly = false;
        }

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, String main, ItemStack out, float bonus, float xp, int temp) {
            this(in1, in2, in3, main, 1, out, bonus, xp, temp);
            this.matchNumberExactly = false;
        }

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, ItemStack main, ItemStack out, float bonus, float xp, int temp) {
            this(in1, in2, in3, main, 1, out, bonus, xp, temp);
            this.matchNumberExactly = false;
        }

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, ItemStack main, int req, ItemStack out, float bonus, float xp, int temp) {
            this(in1, in2, in3, ReikaJavaLibrary.makeListFrom((Object)main), req, out, bonus, xp, temp);
        }

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, String main, int req, ItemStack out, float bonus, float xp, int temp) {
            this(in1, in2, in3, OreDictionary.getOres((String)main), req, out, bonus, xp, temp);
        }

        private BlastRecipe(FlexibleIngredient in1, FlexibleIngredient in2, FlexibleIngredient in3, Collection<ItemStack> main, int req, ItemStack out, float bonus, float xp, int temp) {
            this.primary = in1.lock();
            this.secondary = in2.lock();
            this.tertiary = in3.lock();
            this.bonusYield = bonus;
            this.xp = xp;
            this.output = out;
            this.matchNumberExactly = true;
            this.temperature = temp;
            if (main.isEmpty()) {
                throw new IllegalArgumentException("Empty item list for main item in Blast Recipe " + this.toString());
            }
            this.main = new FlexibleIngredient(main, 100.0f, req).lock();
        }

        private BlastRecipe setAlloy() {
            this.alloy = true;
            return this;
        }

        private BlastRecipe setNeedsEmpty() {
            this.needsEmpty = true;
            return this;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack mainItemForDisplay() {
            return this.main.getItemForDisplay(false);
        }

        @Override
        public ItemStack outputItem() {
            return this.output != null ? this.output.func_77946_l() : null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.primary + " + ");
            sb.append(this.secondary + " + ");
            sb.append(this.tertiary + " + ");
            sb.append(this.matchNumberExactly ? "== " : ">= ");
            sb.append(this.main.numberToUse + " of ");
            sb.append(this.main);
            sb.append(" >> ");
            sb.append(this.output);
            if (this.bonusYield > 0.0f) {
                sb.append("*" + this.bonusYield);
            }
            return sb.toString();
        }

        public int getNumberProduced(int main) {
            return this.main.numberToUse > 1 ? main / this.main.numberToUse : main;
        }

        public boolean matchInputExactly() {
            return this.matchNumberExactly;
        }

        public ArrayList<Integer> getValidInputNumbers() {
            ArrayList<Integer> li = new ArrayList<Integer>();
            for (int i = this.main.numberToUse; i <= 9; i += this.main.numberToUse) {
                if (i != this.main.numberToUse && this.matchInputExactly()) continue;
                li.add(i);
            }
            return li;
        }

        @Override
        public boolean isValidInputForSlot(int slot, ItemStack is) {
            if (slot == 0) {
                return this.primary.match(is);
            }
            if (slot == 11) {
                return this.secondary.match(is);
            }
            if (slot == 14) {
                return this.tertiary.match(is);
            }
            if (slot >= 1 && slot < 10) {
                return this.isValidMainItem(is);
            }
            return false;
        }

        public boolean isValidMainItem(ItemStack is) {
            return this.main.match(is);
        }

        public Collection<ItemStack> getMainItems() {
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (ItemStack ks : this.main.getItems()) {
                c.add(ks);
            }
            return c;
        }

        @Override
        public float getXPPerProduct() {
            return this.xp;
        }

        @Override
        public boolean isAlloying() {
            return this.alloy;
        }

        @Override
        public int getRequiredTemperature() {
            return this.temperature;
        }

        @Override
        public String getUniqueID() {
            return "RECIPE/" + this.primary.fullID((FlexibleIngredient.IngredientIDHandler)this) + "&" + this.secondary.fullID((FlexibleIngredient.IngredientIDHandler)this) + "&" + this.tertiary.fullID((FlexibleIngredient.IngredientIDHandler)this) + ">" + this.main.fullID((FlexibleIngredient.IngredientIDHandler)this) + "^" + RecipeHandler.fullID(this.output) + "?" + this.bonusYield;
        }

        @Override
        public String getAllInfo() {
            return "Mainline production, " + this.toString();
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            if (this.primary != null) {
                li.addAll(this.primary.getItems());
            }
            if (this.secondary != null) {
                li.addAll(this.secondary.getItems());
            }
            if (this.tertiary != null) {
                li.addAll(this.tertiary.getItems());
            }
            li.addAll(this.getMainItems());
            li.add(this.output);
            return li;
        }

        @Override
        public boolean requiresEmptyOutput() {
            return this.needsEmpty;
        }

        @Override
        public boolean usesSlot(int i) {
            return true;
        }

        public final String fullIDForItems(Collection<KeyedItemStack> c) {
            return RecipeHandler.fullIDKeys(c);
        }
    }

    public static interface BlastFurnacePattern
    extends RecipeHandler.MachineRecipe {
        public ItemStack outputItem();

        public boolean isValidInputForSlot(int var1, ItemStack var2);

        public float getXPPerProduct();

        public boolean isAlloying();

        public int getRequiredTemperature();

        public boolean requiresEmptyOutput();

        public boolean usesSlot(int var1);
    }

    public static final class BlastCrafting
    implements BlastFurnacePattern {
        public final int temperature;
        private final IRecipe recipe;
        private final ItemStack output;
        public final int speed;
        public final float xp;
        private boolean alloy;

        private BlastCrafting(ItemStack out, int temp, int speed, IRecipe ir, float xp) {
            this.recipe = ir;
            this.output = out;
            this.temperature = temp;
            this.speed = speed;
            this.xp = xp;
        }

        private BlastCrafting setAlloying() {
            this.alloy = true;
            return this;
        }

        @Override
        public final ItemStack outputItem() {
            return this.output.func_77946_l();
        }

        public BlastCrafting copy() {
            BlastCrafting bc = new BlastCrafting(this.output, this.temperature, this.speed, this.recipe, this.xp);
            bc.alloy = this.alloy;
            return bc;
        }

        public boolean matches(InventoryCrafting ic, int temperature) {
            return temperature >= this.temperature && this.recipe.func_77569_a(ic, null);
        }

        public boolean usesItem(ItemStack is) {
            return ReikaItemHelper.collectionContainsItemStack((Collection)ReikaRecipeHelper.getAllItemsInRecipe((IRecipe)this.recipe), (ItemStack)is);
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack[] getArrayForDisplay() {
            return ReikaRecipeHelper.getPermutedRecipeArray((IRecipe)this.recipe);
        }

        @Override
        public boolean isValidInputForSlot(int slot, ItemStack is) {
            if (slot == 0 || slot > 9) {
                return false;
            }
            return ReikaRecipeHelper.getRecipeLocationIndices((IRecipe)this.recipe, (ItemStack)is).contains(slot - 1);
        }

        @Override
        public float getXPPerProduct() {
            return this.xp;
        }

        @Override
        public boolean isAlloying() {
            return this.alloy;
        }

        @Override
        public int getRequiredTemperature() {
            return this.temperature;
        }

        @Override
        public String getUniqueID() {
            return "CRAFT/" + this.recipe.getClass().getName() + "^" + ReikaRecipeHelper.toDeterministicString((IRecipe)this.recipe) + ">" + this.output;
        }

        @Override
        public String getAllInfo() {
            return "Crafting " + this.output + ", Recipe=" + ReikaRecipeHelper.toString((IRecipe)this.recipe) + " @ " + this.temperature + "C; xp=" + this.xp + ", speed=" + this.speed + ", alloy:" + this.alloy;
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>(ReikaRecipeHelper.getAllItemsInRecipe((IRecipe)this.recipe));
            li.add(this.output);
            return li;
        }

        @Override
        public boolean requiresEmptyOutput() {
            return false;
        }

        @Override
        public boolean usesSlot(int i) {
            List[] arr = ReikaRecipeHelper.getRecipeArray((IRecipe)this.recipe);
            return arr != null && arr[i] != null;
        }
    }
}

