/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TextureFetcher;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Interfaces.BasicMachine;
import Reika.RotaryCraft.Auxiliary.RotaryRenderList;
import Reika.RotaryCraft.Base.RotaryModelBase;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class RotaryCraftTileEntity
extends TileEntityBase
implements RenderFetcher,
BasicMachine {
    protected RotaryModelBase rmb;
    protected int tickcount = 0;
    public float phi = 0.0f;
    private boolean disabled;
    public int[] paint = new int[]{-1, -1, -1};
    protected StepTimer second = new StepTimer(20);
    public boolean isFlipped = false;

    public final boolean canUpdate() {
        return !RotaryCraft.instance.isLocked();
    }

    public final boolean allowTickAcceleration() {
        return this.getMachine().allowsAcceleration();
    }

    public int getTick() {
        return this.tickcount;
    }

    protected abstract void animateWithTick(World var1, int var2, int var3, int var4);

    public abstract MachineRegistry getMachine();

    @SideOnly(value=Side.CLIENT)
    public final TextureFetcher getRenderer() {
        return this.getTileRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public final RotaryTERenderer getTileRenderer() {
        if (this.getMachine().hasRender()) {
            return RotaryRenderList.getRenderForMachine(this.getMachine());
        }
        return null;
    }

    public final int getMachineIndex() {
        return this.getMachine().ordinal();
    }

    public final String getMultiValuedName() {
        if (this.getMachine().isMultiNamed()) {
            return this.getMachine().getMultiName(this);
        }
        return this.getMachine().getName();
    }

    public final Block getTileEntityBlockID() {
        return this.getMachine().getBlock();
    }

    public final MachineRegistry getMachine(ForgeDirection dir) {
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        TileEntity te = this.getAdjacentTileEntity(dir);
        return te instanceof RotaryCraftTileEntity ? ((RotaryCraftTileEntity)te).getMachine() : null;
    }

    public final void giveNoSuperWarning() {
        RotaryCraft.logger.logError((Object)("TileEntity " + this.getName() + " does not call super()!"));
        ReikaChatHelper.write((Object)("TileEntity " + this.getName() + " does not call super()!"));
    }

    public final boolean shouldRenderInPass(int pass) {
        if (!this.isInWorld()) {
            return true;
        }
        if (pass == 0) {
            return true;
        }
        if (this.getMachine().hasModel() && this instanceof TileEntityIOMachine) {
            return true;
        }
        return pass == 1 && (this.hasModelTransparency() || this.getMachine().renderInPass1());
    }

    public abstract boolean hasModelTransparency();

    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.isFlipped) {
            NBT.func_74757_a("flip", this.isFlipped);
        }
    }

    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isFlipped = NBT.func_74767_n("flip");
    }

    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("tick", this.tickcount);
        NBT.func_74757_a("emp", this.disabled);
    }

    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.tickcount = NBT.func_74762_e("tick");
        this.disabled = NBT.func_74767_n("emp");
    }

    public boolean isSelfBlock() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this.getTileEntityBlockID()) {
            return false;
        }
        int meta = this.getMachine().getBlockMetadata();
        return meta == this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isPlayerAccessible(EntityPlayer var1) {
        if (ConfigRegistry.LOCKMACHINES.getState() && !var1.func_70005_c_().equals(this.placer)) {
            ReikaChatHelper.write((Object)("This " + this.getName() + " is locked and can only be used by " + this.placer + "!"));
            return false;
        }
        return super.isPlayerAccessible(var1);
    }

    public final String getTEName() {
        MachineRegistry m = this.getMachine();
        if (m.isMultiNamed()) {
            return m.getMultiName(this);
        }
        return m.getName();
    }

    public boolean isShutdown() {
        return this.disabled;
    }

    public void onEMP() {
        this.disabled = true;
        if (this instanceof TileEntityIOMachine) {
            TileEntityIOMachine io = (TileEntityIOMachine)this;
            io.power = 0L;
            io.torque = 0;
            io.omega = 0;
        }
    }

    public int getTextureStateForSide(int s) {
        switch (this.func_145832_p()) {
            case 0: {
                return s == 4 ? this.getActiveTexture() : 0;
            }
            case 1: {
                return s == 5 ? this.getActiveTexture() : 0;
            }
            case 2: {
                return s == 2 ? this.getActiveTexture() : 0;
            }
            case 3: {
                return s == 3 ? this.getActiveTexture() : 0;
            }
        }
        return 0;
    }

    protected int getActiveTexture() {
        return 0;
    }

    public IIcon getIconForSide(ForgeDirection dir) {
        return BlockRegistry.DECO.getBlockInstance().func_149691_a(0, 0);
    }

    public boolean hasIconOverride() {
        return false;
    }

    public boolean matchMachine(IBlockAccess world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block id2 = this.getTileEntityBlockID();
        int meta2 = this.getMachine().getBlockMetadata();
        return id2 == id && meta2 == meta;
    }

    public void onRedirect() {
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public final Visibility getOCNetworkVisibility() {
        if (this.getMachine().isTransmissionMachine()) {
            return this.getMachine().isAdvancedTransmission() ? Visibility.Network : Visibility.None;
        }
        if (this.getMachine().isPipe()) {
            return Visibility.None;
        }
        return this instanceof TileEntityBeltHub ? Visibility.None : Visibility.Network;
    }

    public double heatEnergyPerDegree() {
        return 0.481 * ReikaBlockHelper.getBlockVolume((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e) * 7800.0;
    }
}

