/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Blocks;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.BlockModelledMachine;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Items.Tools.ItemDebug;
import Reika.RotaryCraft.Items.Tools.ItemMeter;
import Reika.RotaryCraft.Items.Tools.ItemScrewdriver;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockShaft
extends BlockModelledMachine {
    public BlockShaft(Material mat) {
        super(mat);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityShaft(meta < 5 ? MaterialRegistry.matList[meta] : MaterialRegistry.STEEL);
    }

    @Override
    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        TileEntityShaft ts = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (ts == null) {
            return 0;
        }
        if (ts.getShaftType().isFlammable()) {
            return 60;
        }
        return 0;
    }

    public float getExplosionResistance(Entity ent, World world, int x, int y, int z, double eX, double eY, double eZ) {
        TileEntityShaft sha = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (sha == null) {
            return 0.0f;
        }
        MaterialRegistry type = sha.getShaftType();
        switch (type) {
            case WOOD: {
                return 5.0f;
            }
            case STONE: {
                return 10.0f;
            }
            case STEEL: {
                return 15.0f;
            }
            case TUNGSTEN: 
            case DIAMOND: {
                return 30.0f;
            }
            case BEDROCK: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        TileEntityShaft sha = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (sha == null) {
            return 0.01f;
        }
        int mult = 1;
        if (ep.field_71071_by.func_70448_g() != null && ep.field_71071_by.func_70448_g().func_77973_b() == ItemRegistry.BEDPICK.getItemInstance()) {
            mult = 4;
        }
        if (this.canHarvest(world, ep, x, y, z)) {
            return (float)mult * 0.2f / (float)(sha.getShaftType().ordinal() + 1);
        }
        return 0.01f / (float)(sha.getShaftType().ordinal() + 1);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int par6, float par7, float par8, float par9) {
        if (RotaryCraft.instance.isLocked()) {
            return false;
        }
        if (ep.func_70093_af()) {
            return true;
        }
        if (ep.func_71045_bC() != null && (ep.func_71045_bC().func_77973_b() instanceof ItemScrewdriver || ep.func_71045_bC().func_77973_b() instanceof ItemMeter || ep.func_71045_bC().func_77973_b() instanceof ItemDebug)) {
            return false;
        }
        TileEntityShaft tile = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (tile != null && tile.getShaftType() != null) {
            ItemStack fix = tile.getShaftType().getShaftUnitItem();
            if (ep.func_71045_bC() != null && ReikaItemHelper.matchStacks((ItemStack)fix, (ItemStack)ep.func_71045_bC())) {
                tile.repair();
                if (!ep.field_71075_bZ.field_75098_d) {
                    int num = ep.func_71045_bC().field_77994_a;
                    if (num > 1) {
                        ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, ReikaItemHelper.getSizedItemStack((ItemStack)fix, (int)(num - 1)));
                    } else {
                        ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, null);
                    }
                }
                return false;
            }
        }
        return super.func_149727_a(world, x, y, z, ep, par6, par7, par8, par9);
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntityShaft sha = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (sha != null) {
            if (sha.failed()) {
                ItemStack todrop = null;
                if (this.par5Random.nextInt(8) == 0) {
                    switch (sha.getShaftType()) {
                        case WOOD: {
                            todrop = new ItemStack(Blocks.field_150344_f, 5, 0);
                            break;
                        }
                        case STONE: {
                            todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ReikaItemHelper.cobbleSlab.asItemStack(), (int)5);
                            break;
                        }
                        case STEEL: {
                            todrop = ItemStacks.mount.func_77946_l();
                            break;
                        }
                        case TUNGSTEN: {
                            todrop = ItemStacks.mount.func_77946_l();
                            break;
                        }
                        case DIAMOND: {
                            todrop = ItemStacks.mount.func_77946_l();
                            break;
                        }
                        case BEDROCK: {
                            todrop = ItemStacks.mount.func_77946_l();
                        }
                    }
                    EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                    item.field_145804_b = 10;
                    if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                        world.func_72838_d((Entity)item);
                    }
                }
            } else if (sha.func_145832_p() < 6) {
                ItemStack todrop = sha.getShaftType().getShaftItem();
                if (sha.isUnHarvestable()) {
                    todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(2 + this.par5Random.nextInt(12)));
                }
                EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                item.field_145804_b = 10;
                if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                    world.func_72838_d((Entity)item);
                }
            } else {
                ItemStack todrop = RotaryAux.getShaftCrossItem();
                if (sha.isUnHarvestable()) {
                    todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(2 + this.par5Random.nextInt(12)));
                }
                EntityItem item = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), todrop);
                item.field_145804_b = 10;
                if (!world.field_72995_K && !ep.field_71075_bZ.field_75098_d) {
                    world.func_72838_d((Entity)item);
                }
            }
        }
    }

    public boolean canHarvest(World world, EntityPlayer player, int x, int y, int z) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        TileEntityShaft ts = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (ts == null) {
            return false;
        }
        MaterialRegistry type = ts.getShaftType();
        return type != null ? type.isHarvestablePickaxe(player.field_71071_by.func_70448_g()) : false;
    }

    @Override
    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.setFullBlockBounds();
        RotaryCraftTileEntity te = (RotaryCraftTileEntity)iba.func_147438_o(x, y, z);
        if (te.func_145832_p() < 6) {
            return;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        float minx = (float)this.field_149759_B;
        float maxx = (float)this.field_149755_E;
        float miny = (float)this.field_149760_C;
        float maxy = (float)this.field_149756_F;
        float minz = (float)this.field_149754_D;
        float maxz = (float)this.field_149757_G;
        this.func_149676_a(minx, miny, minz, maxx, maxy -= 0.1825f, maxz);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityShaft tile = (TileEntityShaft)world.func_147438_o(x, y, z);
        if (tile == null) {
            return ret;
        }
        ret.add(ItemRegistry.SHAFT.getStackOfMetadata(tile.getShaftType().ordinal()));
        return ret;
    }
}

