/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools;

import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.TileEntity.ThermalTile;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaDateHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.API.Interfaces.PressureTile;
import Reika.RotaryCraft.API.Interfaces.Transducerable;
import Reika.RotaryCraft.API.Power.ShaftMachine;
import Reika.RotaryCraft.API.Power.ShaftPowerReceiver;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.IntegratedGearboxable;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.RCToModConverter;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Auxiliary.Variables;
import Reika.RotaryCraft.Base.ItemRotaryTool;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntitySpringPowered;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.ModInterface.Conversion.TileEntityDynamo;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityHydroEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityJetEngine;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBlastFurnace;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBorer;
import Reika.RotaryCraft.TileEntities.Production.TileEntityFractionator;
import Reika.RotaryCraft.TileEntities.Production.TileEntityPump;
import Reika.RotaryCraft.TileEntities.Production.TileEntitySolar;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityGPR;
import Reika.RotaryCraft.TileEntities.TileEntityPlayerDetector;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBevelGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityDistributionClutch;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityGearbox;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityHeatRay;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemMeter
extends ItemRotaryTool {
    public ItemMeter(int tex) {
        super(tex);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        MachineRegistry m;
        TileEntity tile;
        block91: {
            block92: {
                String name;
                block90: {
                    block88: {
                        block89: {
                            long out;
                            long pwr;
                            String sname;
                            IntegratedGearboxable integratedGearboxable;
                            int ratio;
                            block87: {
                                ArrayList<String> arrayList;
                                int i;
                                Block bk;
                                block86: {
                                    if (super.func_77648_a(is, ep, world, x, y, z, s, a, b, c)) {
                                        return true;
                                    }
                                    if (world.field_72995_K && ConfigRegistry.CLEARCHAT.getState()) {
                                        ReikaChatHelper.clearChat();
                                    }
                                    if (world.field_72995_K) {
                                        return true;
                                    }
                                    bk = world.func_147439_a(x, y, z);
                                    tile = world.func_147438_o(x, y, z);
                                    name = tile != null ? (tile instanceof TileEntityBase ? ((TileEntityBase)tile).getName() : tile.getClass().getSimpleName()) : "null";
                                    m = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
                                    if (tile instanceof TileEntityIOMachine) {
                                        ((TileEntityIOMachine)tile).iotick = 512;
                                    } else if (tile instanceof ShaftMachine) {
                                        ShaftMachine shaftMachine = (ShaftMachine)tile;
                                        shaftMachine.setIORenderAlpha(512);
                                    }
                                    world.func_147471_g(x, y, z);
                                    if (!(tile instanceof Transducerable)) break block86;
                                    ArrayList<String> arrayList2 = ((Transducerable)tile).getMessages(world, x, y, z, s);
                                    if (arrayList2 != null) {
                                        for (i = 0; i < arrayList2.size(); ++i) {
                                            this.sendMessage(ep, arrayList2.get(i));
                                        }
                                    }
                                    break block87;
                                }
                                if (bk instanceof Transducerable && (arrayList = ((Transducerable)bk).getMessages(world, x, y, z, s)) != null) {
                                    for (i = 0; i < arrayList.size(); ++i) {
                                        this.sendMessage(ep, arrayList.get(i));
                                    }
                                }
                            }
                            if (tile instanceof ThermalTile) {
                                ThermalTile thermalTile = (ThermalTile)tile;
                                this.sendMessage(ep, String.format("%s %s: %s", new Object[]{name, Variables.TEMPERATURE, RotaryAux.formatTemperature(thermalTile.getTemperature())}));
                            }
                            if (tile instanceof PressureTile) {
                                PressureTile pressureTile = (PressureTile)tile;
                                this.sendMessage(ep, String.format("%s %s: %s", new Object[]{name, Variables.PRESSURE, RotaryAux.formatPressure(pressureTile.getPressure())}));
                            }
                            if (tile instanceof RangedEffect) {
                                RangedEffect rangedEffect = (RangedEffect)tile;
                                this.sendMessage(ep, (Object)((Object)Variables.RANGE) + ": " + RotaryAux.formatDistance(rangedEffect.getRange()) + "; Max Range: " + RotaryAux.formatDistance(rangedEffect.getMaxRange()));
                            }
                            if (tile instanceof DiscreteFunction) {
                                this.sendMessage(ep, (Object)((Object)Variables.OPERATIONTIME) + ": " + (float)((DiscreteFunction)tile).getOperationTime() / 20.0f + " s");
                            }
                            if (tile instanceof IntegratedGearboxable && (ratio = (integratedGearboxable = (IntegratedGearboxable)tile).getIntegratedGear()) != 0) {
                                this.sendMessage(ep, "Integrated Gearbox: " + Math.abs(ratio) + " x, " + (ratio > 0 ? "Torque" : "Speed"));
                            }
                            if (tile instanceof PowerSourceTracker) {
                                this.sendMessage(ep, "Power is being received from:");
                                this.sendMessages(ep, ((PowerSourceTracker)tile).getPowerSources((PowerSourceTracker)tile, null).getMessages());
                            }
                            if (tile instanceof TileEntityEngine) {
                                int amt;
                                String sg2;
                                TileEntityEngine tileEntityEngine = (TileEntityEngine)tile;
                                world.func_147471_g(x, y, z);
                                long power = tileEntityEngine.power;
                                this.sendMessage(ep, String.format("%s producing %s", name, RotaryAux.formatPowerIO(tileEntityEngine)));
                                if (tileEntityEngine.getEngineType().isAirBreathing() && tileEntityEngine.isDrowned(world, x, y, z)) {
                                    this.sendLocalizedMessage(ep, "drowning");
                                }
                                if (tileEntityEngine.getEngineType() == EngineType.JET) {
                                    if (((TileEntityJetEngine)tileEntityEngine).getChokedFraction(world, x, y, z, tileEntityEngine.func_145832_p()) < 1.0f) {
                                        this.sendLocalizedMessage(ep, "choke");
                                    }
                                    if (((TileEntityJetEngine)tileEntityEngine).FOD >= 8) {
                                        this.sendLocalizedMessage(ep, "fod");
                                    }
                                }
                                if (tileEntityEngine.getEngineType().burnsFuel()) {
                                    int time = tileEntityEngine.getFuelDuration();
                                    sg2 = String.format("%s: %s", new Object[]{Variables.FUEL, ReikaDateHelper.getSecondsAsClock((int)time)});
                                    this.sendMessage(ep, sg2);
                                }
                                if (tileEntityEngine.getEngineType().requiresLubricant()) {
                                    amt = tileEntityEngine.getLube();
                                    sg2 = String.format("Lubricant: %s", RotaryAux.formatLiquidAmount(amt));
                                    this.sendMessage(ep, sg2);
                                }
                                if (tileEntityEngine.getEngineType().isWaterPiped()) {
                                    amt = tileEntityEngine.getWater();
                                    sg2 = String.format("Water: %s", RotaryAux.formatLiquidAmount(amt));
                                    this.sendMessage(ep, sg2);
                                }
                                if (tileEntityEngine.getEngineType() == EngineType.HYDRO) {
                                    if (((TileEntityHydroEngine)tileEntityEngine).isStreamPowered()) {
                                        for (String sg2 : ((TileEntityHydroEngine)tileEntityEngine).getStreamData()) {
                                            this.sendMessage(ep, sg2);
                                        }
                                    } else {
                                        String sg3 = String.format("Detected waterfall height: %s", RotaryAux.formatDistance(((TileEntityHydroEngine)tileEntityEngine).getWaterfallHeightForDisplay()));
                                        this.sendMessage(ep, sg3);
                                    }
                                }
                            } else if (tile instanceof ShaftPowerEmitter) {
                                ShaftPowerEmitter shaftPowerEmitter = (ShaftPowerEmitter)tile;
                                this.sendMessage(ep, String.format("%s producing %s", name, RotaryAux.formatPowerIO(shaftPowerEmitter)));
                            }
                            if (tile instanceof TileEntityPowerReceiver) {
                                TileEntityPowerReceiver tileEntityPowerReceiver = (TileEntityPowerReceiver)tile;
                                long power = tileEntityPowerReceiver.power;
                                this.sendMessage(ep, String.format("%s receiving %s", name, RotaryAux.formatPowerIO(tileEntityPowerReceiver)));
                                if (power < tileEntityPowerReceiver.MINPOWER) {
                                    this.sendLocalizedMessage(ep, "minpower");
                                }
                                if (power < (long)tileEntityPowerReceiver.MINSPEED) {
                                    this.sendLocalizedMessage(ep, "mintorque");
                                }
                                if (power < (long)tileEntityPowerReceiver.MINTORQUE) {
                                    this.sendLocalizedMessage(ep, "minspeed");
                                }
                            } else if (tile instanceof ShaftPowerReceiver) {
                                ShaftPowerReceiver shaftPowerReceiver = (ShaftPowerReceiver)tile;
                                this.sendMessage(ep, String.format("%s receiving %s", name, RotaryAux.formatPowerIO(shaftPowerReceiver)));
                            }
                            if (m == MachineRegistry.DISTRIBCLUTCH) break block88;
                            if (m != MachineRegistry.SPLITTER) break block89;
                            TileEntitySplitter tileEntitySplitter = (TileEntitySplitter)tile;
                            if (tileEntitySplitter.isSplitting()) {
                                sname = ReikaStringParser.capFirstChar((String)tileEntitySplitter.getReadDirection().name());
                                pwr = tileEntitySplitter.torque * tileEntitySplitter.omega;
                                this.sendMessage(ep, String.format("Input side %s receiving %s", sname, RotaryAux.formatPowerIO(tileEntitySplitter.omega, pwr)));
                                sname = ReikaStringParser.capFirstChar((String)tileEntitySplitter.getWriteDirection().name());
                                out = tileEntitySplitter.torqueOut1 * tileEntitySplitter.omega;
                                this.sendMessage(ep, String.format("Output to side %s: %s", sname, RotaryAux.formatPowerIO(tileEntitySplitter.omega, out)));
                                sname = ReikaStringParser.capFirstChar((String)tileEntitySplitter.getWriteDirection2().name());
                                out = tileEntitySplitter.torqueOut2 * tileEntitySplitter.omega;
                                this.sendMessage(ep, String.format("Output to side %s: %s", sname, RotaryAux.formatPowerIO(tileEntitySplitter.omega, out)));
                            } else {
                                sname = ReikaStringParser.capFirstChar((String)tileEntitySplitter.getReadDirection().name());
                                pwr = tileEntitySplitter.getInputTorque1() * tileEntitySplitter.getInputSpeed1();
                                this.sendMessage(ep, String.format("Input side %s receiving %s", sname, RotaryAux.formatPowerIO(tileEntitySplitter.omega, pwr)));
                                pwr = tileEntitySplitter.getInputTorque2() * tileEntitySplitter.getInputSpeed2();
                                sname = ReikaStringParser.capFirstChar((String)tileEntitySplitter.getReadDirection().name());
                                this.sendMessage(ep, String.format("Input side %s receiving %s", sname, RotaryAux.formatPowerIO(tileEntitySplitter.omega, pwr)));
                                sname = ReikaStringParser.capFirstChar((String)tileEntitySplitter.getWriteDirection().name());
                                out = tileEntitySplitter.torque * tileEntitySplitter.omega;
                                this.sendMessage(ep, String.format("Output to side %s: %s", sname, RotaryAux.formatPowerIO(tileEntitySplitter.omega, out)));
                            }
                            if (!tileEntitySplitter.isBedrock()) {
                                // empty if block
                            }
                            break block90;
                        }
                        if (!(tile instanceof TileEntityTransmissionMachine)) break block90;
                        TileEntityTransmissionMachine tileEntityTransmissionMachine = (TileEntityTransmissionMachine)tile;
                        this.sendMessage(ep, String.format("%s transmitting %s", name, RotaryAux.formatPowerIO(tileEntityTransmissionMachine)));
                        break block90;
                    }
                    TileEntityDistributionClutch tileEntityDistributionClutch = (TileEntityDistributionClutch)tile;
                    ForgeDirection read = tileEntityDistributionClutch.getInputForgeDirection();
                    if (read != null) {
                        String sname = ReikaStringParser.capFirstChar((String)read.name());
                        long pwr = tileEntityDistributionClutch.getInputTorque() * tileEntityDistributionClutch.omega;
                        this.sendMessage(ep, String.format("Input side %s receiving %s", sname, RotaryAux.formatPowerIO(tileEntityDistributionClutch.omega, pwr)));
                    }
                    for (int i = 0; i < 4; ++i) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i + 2];
                        if (!tileEntityDistributionClutch.isOutputtingToSide(dir)) continue;
                        String sname = ReikaStringParser.capFirstChar((String)dir.name());
                        long out = tileEntityDistributionClutch.getTorqueToSide(dir) * tileEntityDistributionClutch.omega;
                        if (dir == read.getOpposite()) {
                            this.sendMessage(ep, String.format("Output to side %s: %s (leftover)", sname, RotaryAux.formatPowerIO(tileEntityDistributionClutch.omega, out)));
                            continue;
                        }
                        int req = tileEntityDistributionClutch.getTorqueRequest(dir);
                        double base = ReikaMathLibrary.getThousandBase((double)req);
                        String pre = ReikaEngLibrary.getSIPrefix((double)req);
                        this.sendMessage(ep, String.format("Output to side %s: %s (requested %.3f%sNm)", sname, RotaryAux.formatPowerIO(tileEntityDistributionClutch.omega, out), base, pre));
                    }
                }
                if (tile instanceof RCToModConverter) {
                    RCToModConverter rCToModConverter = (RCToModConverter)tile;
                    int units = rCToModConverter.getGeneratedUnitsPerTick();
                    String unit = rCToModConverter.getUnitDisplay();
                    this.sendMessage(ep, String.format("Generating %d %s/t", units, unit));
                }
                if (tile instanceof EnergyToPowerBase) {
                    EnergyToPowerBase energyToPowerBase = (EnergyToPowerBase)tile;
                    int units = energyToPowerBase.getConsumedUnitsPerTick();
                    String unit = energyToPowerBase.getUnitDisplay();
                    this.sendMessage(ep, String.format("%s Outputting %s", name, RotaryAux.formatPowerIO(energyToPowerBase)));
                    this.sendMessage(ep, String.format("Consuming %d %s/t", units, unit));
                }
                if (tile instanceof TileEntityPiping) {
                    TileEntityPiping tileEntityPiping = (TileEntityPiping)tile;
                    Fluid f = tileEntityPiping.getFluidType();
                    if (f != null) {
                        this.sendMessage(ep, String.format("Pipe has %s of %s", RotaryAux.formatLiquidAmount(tileEntityPiping.getFluidLevel()), f.getLocalizedName()));
                    } else {
                        this.sendMessage(ep, "Pipe is empty.");
                    }
                }
                if (tile instanceof TileEntitySpringPowered) {
                    TileEntitySpringPowered tileEntitySpringPowered = (TileEntitySpringPowered)tile;
                    this.sendMessage(ep, String.format("Remaining charge: %.2fs", (double)tileEntitySpringPowered.getExpectedCoilLife() / 20.0));
                }
                if (m == MachineRegistry.GPR) {
                    TileEntityGPR tileEntityGPR = (TileEntityGPR)tile;
                    if (ep.func_70093_af() && tileEntityGPR.power > tileEntityGPR.MINPOWER) {
                        double ratio = 100.0 * tileEntityGPR.getSpongy(world, x, y - 1, z);
                        this.sendMessage(ep, String.format("The ground is %.3f%s caves here", ratio, "%%"));
                    }
                }
                if (m == MachineRegistry.BLASTFURNACE) {
                    TileEntityBlastFurnace tileEntityBlastFurnace = (TileEntityBlastFurnace)tile;
                }
                if (m == MachineRegistry.PLAYERDETECTOR) {
                    TileEntityPlayerDetector tileEntityPlayerDetector = (TileEntityPlayerDetector)tile;
                    this.sendMessage(ep, String.format("Reaction Time: %.2fs", Float.valueOf((float)tileEntityPlayerDetector.getReactionTime() / 20.0f)));
                }
                if (m == MachineRegistry.SOLARTOWER) {
                    TileEntitySolar tileEntitySolar = (TileEntitySolar)tile;
                    TileEntitySolar top = (TileEntitySolar)world.func_147438_o(x, tileEntitySolar.getTopOfTower(), z);
                    TileEntitySolar bottom = (TileEntitySolar)world.func_147438_o(x, tileEntitySolar.getBottomOfTower(), z);
                    if (bottom.getPlant() == null || bottom.getArraySize() <= 0) {
                        this.sendMessage(ep, String.format("Solar plant is unformed", new Object[0]));
                    } else {
                        this.sendMessage(ep, String.format("Solar plant contains %d mirrors and %d active tower pieces (out of %d total)", top.getArraySize(), bottom.getPlant().getEffectiveTowerBlocks(), bottom.getPlant().rawTowerBlocks()));
                        this.sendMessage(ep, String.format("Outputting %s; Efficiency %.1f%s", RotaryAux.formatPowerIO(bottom), Float.valueOf(bottom.getArrayOverallBrightness() * 100.0f), "%%"));
                    }
                }
                if (m == MachineRegistry.HEATRAY) {
                    TileEntityHeatRay tileEntityHeatRay = (TileEntityHeatRay)tile;
                    if (tileEntityHeatRay.power >= tileEntityHeatRay.MINPOWER) {
                        this.sendMessage(ep, String.format("Dealing %ds of burn damage", tileEntityHeatRay.getBurnTime()));
                    }
                }
                if (m == MachineRegistry.PUMP) {
                    TileEntityPump tileEntityPump = (TileEntityPump)tile;
                    if (tileEntityPump.power >= tileEntityPump.MINPOWER && tileEntityPump.duplicationAmount > 1) {
                        this.sendMessage(ep, String.format("Duplicating water with a factor of %dx", tileEntityPump.duplicationAmount));
                    }
                }
                if (m == MachineRegistry.ADVANCEDGEARS) {
                    TileEntityAdvancedGear tileEntityAdvancedGear = (TileEntityAdvancedGear)tile;
                    if (tileEntityAdvancedGear.getGearType() == TileEntityAdvancedGear.GearType.WORM && tileEntityAdvancedGear.power > 0L) {
                        this.sendMessage(ep, String.format("Power Loss: %.2f%s", tileEntityAdvancedGear.getCurrentLoss(), "%%"));
                    } else if (tileEntityAdvancedGear.getGearType().storesEnergy()) {
                        long energy = tileEntityAdvancedGear.getEnergy() / 20L;
                        this.sendMessage(ep, String.format("Stored Energy: %s", RotaryAux.formatEnergy(energy)));
                    }
                }
                if (m == MachineRegistry.BEVELGEARS) {
                    TileEntityBevelGear tileEntityBevelGear = (TileEntityBevelGear)tile;
                    this.sendMessage(ep, String.format("Output side: %s", ReikaStringParser.capFirstChar((String)tileEntityBevelGear.getWriteDirection().name())));
                }
                if (m == MachineRegistry.BORER) {
                    TileEntityBorer tileEntityBorer = (TileEntityBorer)tile;
                    this.sendMessage(ep, String.format("%s head at %d, %d", tileEntityBorer.getName(), tileEntityBorer.getHeadX(), tileEntityBorer.getHeadZ()));
                    if (tileEntityBorer.isJammed()) {
                        this.sendMessage(ep, String.format("%s is jammed, supply more torque or power!", tileEntityBorer.getName()));
                    }
                }
                if (m == MachineRegistry.BELT || m == MachineRegistry.CHAIN) {
                    TileEntityBeltHub tileEntityBeltHub = (TileEntityBeltHub)tile;
                    if (tileEntityBeltHub.isSplitting()) {
                        this.sendMessage(ep, "Belt is splitting power");
                    }
                    if (tileEntityBeltHub.isSlipping()) {
                        this.sendMessage(ep, "Belt is slipping and wasting power!");
                    }
                }
                if (m != MachineRegistry.DYNAMO) break block91;
                TileEntityDynamo tileEntityDynamo = (TileEntityDynamo)tile;
                if (tileEntityDynamo.torque > (tileEntityDynamo.isUpgraded() ? 2048 : 1024)) break block92;
                if (tileEntityDynamo.omega <= 8192) break block91;
            }
            this.sendMessage(ep, "Conversion limits exceeded; Power is being wasted");
        }
        if (m == MachineRegistry.GEARBOX) {
            TileEntityGearbox tileEntityGearbox = (TileEntityGearbox)tile;
            this.sendMessage(ep, String.format("Gearbox %d percent damaged; Lubricant Levels at %s", (int)(100.0 * (1.0 - ReikaMathLibrary.doubpow((double)0.99, (double)tileEntityGearbox.getDamage()))), RotaryAux.formatLiquidAmount(tileEntityGearbox.getLubricant())));
        }
        if (m == MachineRegistry.FRACTIONATOR) {
            TileEntityFractionator tileEntityFractionator = (TileEntityFractionator)tile;
            if (tileEntityFractionator.power >= tileEntityFractionator.MINPOWER && tileEntityFractionator.omega >= tileEntityFractionator.MINSPEED) {
                this.sendMessage(ep, String.format("Efficiency: %.3f%%%%", Float.valueOf(tileEntityFractionator.getYieldRatio() * 100.0f)));
            }
        }
        if (m == null && tile instanceof IFluidHandler) {
            FluidTankInfo[] fluidTankInfoArray = ((IFluidHandler)tile).getTankInfo(ForgeDirection.VALID_DIRECTIONS[s]);
            StringBuilder sb = new StringBuilder();
            if (fluidTankInfoArray == null) {
                sb.append("No Tank Data");
            } else {
                for (int i = 0; i < fluidTankInfoArray.length; ++i) {
                    if (fluidTankInfoArray[i] == null) continue;
                    sb.append("Tank " + i + ": ");
                    FluidStack fs = fluidTankInfoArray[i].fluid;
                    if (fs != null && fs.getFluid() != null) {
                        sb.append(RotaryAux.formatLiquidAmount(fs.amount) + " of " + fs.getFluid().getLocalizedName() + "/" + RotaryAux.formatLiquidAmount(fluidTankInfoArray[i].capacity) + " Capacity");
                    } else {
                        sb.append("Empty");
                    }
                    sb.append("\n");
                }
            }
            this.sendMessage(ep, sb.toString());
        }
        return true;
    }

    private void sendLocalizedMessage(EntityPlayer ep, String s) {
        this.sendMessage(ep, StatCollector.func_74838_a((String)("message." + s)));
    }

    private void sendMessage(EntityPlayer ep, String s) {
        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)s);
    }

    private void sendMessages(EntityPlayer ep, Collection<String> s) {
        for (String sg : s) {
            this.sendMessage(ep, sg);
        }
    }
}

