/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Conversion;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModInteract.Power.ReikaPneumaticHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.tileentity.AirHandlerSupplier;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;

@APIStripper.Strippable(value={"pneumaticCraft.api.tileentity.IPneumaticMachine"})
public class TileEntityPneumaticEngine
extends EnergyToPowerBase
implements IPneumaticMachine {
    private IAirHandler air;
    private static final int maxAir = 30000;
    private StepTimer sound = new StepTimer(72);

    public TileEntityPneumaticEngine() {
        if (ModList.PNEUMATICRAFT.isLoaded()) {
            this.air = AirHandlerSupplier.getAirHandler((float)10.0f, (float)12.0f, (int)30000);
        }
        this.sound.setTick(this.sound.getCap());
    }

    @Override
    public boolean isValidSupplier(TileEntity te) {
        if (te == null) {
            return false;
        }
        return te.getClass().getSimpleName().startsWith("pneumaticCraft.common.tileentity");
    }

    @Override
    protected int getIdealConsumedUnitsPerTick() {
        return this.getAirPerTick();
    }

    private int getAirPerTick() {
        return ReikaPneumaticHelper.getWattsPerAir();
    }

    @Override
    public int getMaxStorage() {
        return 30000;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PNEUENGINE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (!ModList.PNEUMATICRAFT.isLoaded()) {
            return;
        }
        if (DragonAPICore.debugtest) {
            this.air.addAir(5, this.getConnection());
        }
        this.getIOSides(world, x, y, z, meta);
        this.air.updateEntityI();
        this.storedEnergy = this.air.getCurrentAir(this.getConnection());
        if (this.storedEnergy < 0) {
            this.storedEnergy = 0;
        }
        this.updateSpeed();
        if (!world.field_72995_K) {
            this.sound.update();
            if (this.power > 0L && this.sound.checkCap()) {
                SoundRegistry.PNEUMATIC.playSoundAtBlock(world, x, y, z, this.isMuffled() ? 0.3f : 1.2f, 1.0f);
            }
        }
        this.basicPowerReceiver();
    }

    @Override
    protected void usePower(float mult) {
        int amt = (int)((float)this.getAirPerTick() * mult);
        if (ModList.PNEUMATICRAFT.isLoaded()) {
            this.air.addAir(-amt, this.getConnection());
        }
    }

    public boolean isConnectedTo(ForgeDirection with) {
        return with == this.getConnection();
    }

    private ForgeDirection getConnection() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (ModList.PNEUMATICRAFT.isLoaded()) {
            this.air.writeToNBTI(NBT);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (ModList.PNEUMATICRAFT.isLoaded()) {
            this.air.readFromNBTI(NBT);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (ModList.PNEUMATICRAFT.isLoaded()) {
            this.air.validateI((TileEntity)this);
        }
    }

    @Override
    public String getUnitDisplay() {
        return "mL";
    }

    @Override
    public int getPowerColor() {
        return ReikaColorAPI.RGBtoHex((int)50, (int)170, (int)255);
    }

    @DependentMethodStripper.ModDependent(value={ModList.PNEUMATICRAFT})
    public IAirHandler getAirHandler() {
        return this.air;
    }
}

