/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesWetter;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiWetter;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class WetterHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Liquefaction Machine";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/wettergui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 1, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(103, 15, 44, 22), "rcwetter", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rcwetter")) {
            Collection<RecipesWetter.WettingRecipe> li = RecipesWetter.getRecipes().getAllRecipes();
            for (RecipesWetter.WettingRecipe r : li) {
                this.arecipes.add(new WetterRecipe(r));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rcwetter")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Collection<RecipesWetter.WettingRecipe> c = RecipesWetter.getRecipes().getRecipesByResult(result);
        if (c != null) {
            for (RecipesWetter.WettingRecipe r : c) {
                this.arecipes.add(new WetterRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Collection<RecipesWetter.WettingRecipe> c;
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
        if (fs != null && (c = RecipesWetter.getRecipes().getRecipesByFluid(fs.getFluid())) != null) {
            for (RecipesWetter.WettingRecipe r : c) {
                this.arecipes.add(new WetterRecipe(r));
            }
        }
        if ((c = RecipesWetter.getRecipes().getRecipesUsing(ingredient)) != null) {
            for (RecipesWetter.WettingRecipe r : c) {
                this.arecipes.add(new WetterRecipe(r));
            }
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiWetter.class;
    }

    public void drawExtras(int recipe) {
        this.drawFluids(recipe);
    }

    private void drawFluids(int recipe) {
        WetterRecipe r = (WetterRecipe)((Object)this.arecipes.get(recipe));
        Fluid f = r.recipe.getFluid().getFluid();
        IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        ReikaTextureHelper.bindTerrainTexture();
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        int x = 75;
        for (int i = 0; i < 3; ++i) {
            int y = 7 + i * 16;
            v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
            v5.func_78374_a((double)x, (double)(y + 16), 0.0, (double)u, (double)dv);
            v5.func_78374_a((double)(x + 16), (double)(y + 16), 0.0, (double)du, (double)dv);
            v5.func_78374_a((double)(x + 16), (double)y, 0.0, (double)du, (double)v);
        }
        int y2 = 55;
        int h2 = 4;
        float v2 = v + (dv - v) * (float)h2 / 16.0f;
        v5.func_78374_a((double)x, (double)y2, 0.0, (double)u, (double)v2);
        v5.func_78374_a((double)x, (double)(y2 + h2), 0.0, (double)u, (double)v);
        v5.func_78374_a((double)(x + 16), (double)(y2 + h2), 0.0, (double)du, (double)v);
        v5.func_78374_a((double)(x + 16), (double)y2, 0.0, (double)du, (double)v2);
        v5.func_78381_a();
        String s = r.recipe.getFluid().getLocalizedName();
        int l = Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(s, x - l - 5, y2 - 4, 0);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(((WetterRecipe)r).recipe.getFluid().amount + " mB", x + 20, y2 - 4, 0);
    }

    public class WetterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private RecipesWetter.WettingRecipe recipe;

        private WetterRecipe(RecipesWetter.WettingRecipe r) {
            super((TemplateRecipeHandler)WetterHandler.this);
            this.recipe = r;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.recipe.getOutput(), 111, 25);
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.recipe.getInput(), 39, 25);
        }
    }
}

