/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft;

import Reika.DragonAPI.Auxiliary.PacketTypes;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.RotaryCraft.Auxiliary.EMPSparkRenderer;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Base.TileEntity.TileEntityAimedCannon;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityLaunchCannon;
import Reika.RotaryCraft.Items.Tools.ItemCraftPattern;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityHeater;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityMirror;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityMusicBox;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityParticleEmitter;
import Reika.RotaryCraft.TileEntities.Decorative.TileEntityProjector;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityJetEngine;
import Reika.RotaryCraft.TileEntities.Farming.TileEntitySpawnerController;
import Reika.RotaryCraft.TileEntities.Farming.TileEntitySprinkler;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityAutoCrafter;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBlastFurnace;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBorer;
import Reika.RotaryCraft.TileEntities.Production.TileEntityRefrigerator;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityScaleableChest;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityGPR;
import Reika.RotaryCraft.TileEntities.TileEntityBlower;
import Reika.RotaryCraft.TileEntities.TileEntityItemCannon;
import Reika.RotaryCraft.TileEntities.TileEntityItemFilter;
import Reika.RotaryCraft.TileEntities.TileEntityPlayerDetector;
import Reika.RotaryCraft.TileEntities.TileEntityVacuum;
import Reika.RotaryCraft.TileEntities.TileEntityWinder;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBevelGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityDistributionClutch;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityMultiClutch;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityContainment;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityEMP;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityForceField;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntitySonicWeapon;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityTNTCannon;
import Reika.RotaryCraft.TileEntities.World.TileEntityDefoliator;
import Reika.RotaryCraft.TileEntities.World.TileEntityTerraformer;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketHandlerCore
implements PacketHandler {
    protected PacketRegistry pack;
    private static final Random rand = new Random();

    public void handleData(ReikaPacketHelper.PacketObj packet, World world, EntityPlayer ep) {
        DataInputStream inputStream = packet.getDataIn();
        int control = Integer.MIN_VALUE;
        int[] data = new int[]{};
        long longdata = 0L;
        float floatdata = 0.0f;
        int x = 0;
        int y = 0;
        int z = 0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        boolean readinglong = false;
        NBTTagCompound NBT = null;
        String stringdata = null;
        UUID id = null;
        try {
            PacketTypes packetType = packet.getType();
            switch (packetType) {
                case FULLSOUND: {
                    break;
                }
                case SOUND: {
                    return;
                }
                case STRING: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    break;
                }
                case DATA: {
                    int i;
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    int len = this.pack.numInts;
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case POS: {
                    int i;
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    dx = inputStream.readDouble();
                    dy = inputStream.readDouble();
                    dz = inputStream.readDouble();
                    int len = this.pack.numInts;
                    if (len <= 0) break;
                    data = new int[len];
                    for (i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UPDATE: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    break;
                }
                case FLOAT: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    floatdata = inputStream.readFloat();
                    break;
                }
                case SYNC: {
                    String name = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityData((World)world, (int)x, (int)y, (int)z, (String)name, (DataInputStream)inputStream);
                    return;
                }
                case TANK: {
                    String tank = packet.readString();
                    x = inputStream.readInt();
                    y = inputStream.readInt();
                    z = inputStream.readInt();
                    int level = inputStream.readInt();
                    ReikaPacketHelper.updateTileEntityTankData((World)world, (int)x, (int)y, (int)z, (String)tank, (int)level);
                    return;
                }
                case RAW: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    int len = this.pack.numInts;
                    data = new int[len];
                    readinglong = this.pack.isLongPacket();
                    if (!readinglong) {
                        for (int i = 0; i < len; ++i) {
                            data[i] = inputStream.readInt();
                        }
                        break;
                    }
                    longdata = inputStream.readLong();
                    break;
                }
                case PREFIXED: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    int len = inputStream.readInt();
                    data = new int[len];
                    for (int i = 0; i < len; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case NBT: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    NBT = ((ReikaPacketHelper.DataPacket)packet).asNBT();
                    Coordinate c = this.pack.getCoordinate(NBT);
                    if (c == null) break;
                    x = c.xCoord;
                    y = c.yCoord;
                    z = c.zCoord;
                    break;
                }
                case STRINGINT: 
                case STRINGINTLOC: {
                    stringdata = packet.readString();
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    data = new int[this.pack.numInts];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    break;
                }
                case UUID: {
                    control = inputStream.readInt();
                    this.pack = PacketRegistry.getEnum(control);
                    long l1 = inputStream.readLong();
                    long l2 = inputStream.readLong();
                    id = new UUID(l1, l2);
                }
            }
            if (packetType.hasCoordinates()) {
                x = inputStream.readInt();
                y = inputStream.readInt();
                z = inputStream.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        try {
            switch (this.pack) {
                case BORERTOGGLEALL: {
                    TileEntityBorer borer = (TileEntityBorer)te;
                    for (int i = 0; i < 5; ++i) {
                        for (int j = 0; j < 7; ++j) {
                            borer.cutShape[j][i] = !borer.cutShape[j][i];
                            borer.syncAllData(true);
                        }
                    }
                    break;
                }
                case BORERRESET: {
                    TileEntityBorer borer = (TileEntityBorer)te;
                    borer.reset();
                    break;
                }
                case BORERDROPS: {
                    TileEntityBorer borer = (TileEntityBorer)te;
                    if (borer.drops) {
                        borer.drops = false;
                        break;
                    }
                    borer.drops = true;
                    break;
                }
                case BORER: {
                    int cols;
                    int roworld;
                    TileEntityBorer borer = (TileEntityBorer)te;
                    if (data[0] > 0 && data[0] < 100) {
                        roworld = data[0] / 7;
                        cols = data[0] - roworld * 7;
                        borer.cutShape[cols][roworld] = false;
                    }
                    if (data[0] < 0 && data[0] > -100) {
                        roworld = -data[0] / 7;
                        cols = -data[0] - roworld * 7;
                        borer.cutShape[cols][roworld] = true;
                    }
                    if (data[0] == 100) {
                        borer.cutShape[0][0] = false;
                    }
                    if (data[0] != -100) break;
                    borer.cutShape[0][0] = true;
                    break;
                }
                case BEVEL: {
                    ((TileEntityBevelGear)te).direction = data[0];
                    break;
                }
                case SPLITTERMODE: {
                    ((TileEntitySplitter)te).setMode(data[0]);
                    break;
                }
                case SPAWNERTIMER: {
                    TileEntitySpawnerController spawner = (TileEntitySpawnerController)te;
                    if (data[0] == -1) {
                        spawner.disable = true;
                        break;
                    }
                    spawner.disable = false;
                    spawner.setDelay(data[0]);
                    break;
                }
                case DETECTOR: {
                    ((TileEntityPlayerDetector)te).selectedrange = data[0];
                    break;
                }
                case HEATER: {
                    ((TileEntityHeater)te).setTemperature = data[0];
                    break;
                }
                case CVTMODE: {
                    TileEntityAdvancedGear adv = (TileEntityAdvancedGear)te;
                    adv.stepMode();
                    break;
                }
                case CVTRATIO: {
                    TileEntityAdvancedGear adv = (TileEntityAdvancedGear)te;
                    adv.setRatio(data[0]);
                    break;
                }
                case CVTTARGET: {
                    TileEntityAdvancedGear adv = (TileEntityAdvancedGear)te;
                    adv.setTargetTorque(data[0]);
                    break;
                }
                case CVTREDSTONESTATE: {
                    TileEntityAdvancedGear adv = (TileEntityAdvancedGear)te;
                    adv.incrementCVTState(data[0] > 0);
                    break;
                }
                case CANNONFIRINGVALS: {
                    TileEntityLaunchCannon cannon = (TileEntityLaunchCannon)te;
                    if (data[0] == 0) {
                        cannon.phi = data[1];
                        cannon.theta = data[2] > cannon.getMaxTheta() ? cannon.getMaxTheta() : data[2];
                        cannon.velocity = data[3] > cannon.getMaxLaunchVelocity() ? cannon.getMaxLaunchVelocity() : data[3];
                    } else {
                        cannon.target[0] = data[1];
                        cannon.target[1] = data[2];
                        cannon.target[2] = data[3];
                        double ddx = cannon.target[0] - cannon.field_145851_c;
                        double ddz = cannon.target[2] - cannon.field_145849_e;
                        double dd = ReikaMathLibrary.py3d((double)ddx, (double)0.0, (double)ddz);
                        if (dd > cannon.getMaxLaunchDistance()) {
                            cannon.target[0] = cannon.field_145851_c;
                            cannon.target[1] = 512;
                            cannon.target[2] = cannon.field_145849_e;
                        }
                    }
                    if (!(cannon instanceof TileEntityTNTCannon)) break;
                    ((TileEntityTNTCannon)cannon).selectedFuse = data[4];
                    break;
                }
                case SONICPITCH: {
                    ((TileEntitySonicWeapon)te).setpitch = longdata;
                    break;
                }
                case SONICVOLUME: {
                    ((TileEntitySonicWeapon)te).setvolume = longdata;
                    break;
                }
                case FORCE: {
                    ((TileEntityForceField)te).setRange = data[0];
                    break;
                }
                case CHEST: {
                    TileEntityScaleableChest chest = (TileEntityScaleableChest)te;
                    chest.page = data[0];
                    ep.openGui((Object)RotaryCraft.instance, 24000 + data[0], chest.field_145850_b, chest.field_145851_c, chest.field_145848_d, chest.field_145849_e);
                    break;
                }
                case COILSPEED: {
                    ((TileEntityAdvancedGear)te).setReleaseOmega(data[0]);
                    break;
                }
                case COILTORQUE: {
                    ((TileEntityAdvancedGear)te).setReleaseTorque(data[0]);
                    break;
                }
                case MUSICNOTE: {
                    TileEntityMusicBox music = (TileEntityMusicBox)te;
                    TileEntityMusicBox.Note n = new TileEntityMusicBox.Note(TileEntityMusicBox.NoteLength.values()[data[2]], data[0], TileEntityMusicBox.Instrument.values()[data[3]]);
                    for (int i = 0; i < 3; ++i) {
                    }
                    music.addNote(data[1], n);
                    break;
                }
                case MUSICSAVE: {
                    ((TileEntityMusicBox)te).save();
                    break;
                }
                case MUSICREAD: {
                    ((TileEntityMusicBox)te).read();
                    break;
                }
                case MUSICDEMO: {
                    ((TileEntityMusicBox)te).loadDemo();
                    break;
                }
                case MUSICREST: {
                    TileEntityMusicBox.Note n = new TileEntityMusicBox.Note(TileEntityMusicBox.NoteLength.values()[data[1]], 0, TileEntityMusicBox.Instrument.GUITAR);
                    ((TileEntityMusicBox)te).addRest(data[0], n);
                    break;
                }
                case MUSICBKSP: {
                    ((TileEntityMusicBox)te).backspace(data[0]);
                    break;
                }
                case MUSICCLEARCH: {
                    ((TileEntityMusicBox)te).clearChannel(data[0]);
                    break;
                }
                case MUSICCLEAR: {
                    ((TileEntityMusicBox)te).clearMusic();
                    break;
                }
                case VACUUMXP: {
                    ((TileEntityVacuum)te).spawnXP();
                    break;
                }
                case WINDERTOGGLE: {
                    TileEntityWinder winder = (TileEntityWinder)te;
                    winder.winding = !winder.winding;
                    winder.iotick = 512;
                    break;
                }
                case PROJECTOR: {
                    ((TileEntityProjector)te).cycleInv();
                    break;
                }
                case CONTAINMENT: {
                    ((TileEntityContainment)te).setRange = data[0];
                    break;
                }
                case ITEMCANNON: {
                    ((TileEntityItemCannon)te).selectNewTarget(data[0], data[1], data[2], data[3]);
                    break;
                }
                case MIRROR: {
                    ((TileEntityMirror)te).breakMirror(world, x, y, z);
                    break;
                }
                case SAFEPLAYER: {
                    ((TileEntityAimedCannon)te).removePlayerFromWhiteList(stringdata);
                    break;
                }
                case ENGINEBACKFIRE: {
                    ((TileEntityJetEngine)te).backFire(world, x, y, z);
                    break;
                }
                case MUSICPARTICLE: {
                    world.func_72869_a("note", (double)x + 0.2 + rand.nextDouble() * 0.6, (double)y + 1.2, (double)z + 0.2 + rand.nextDouble() * 0.6, rand.nextDouble(), 0.0, 0.0);
                    break;
                }
                case MULTISIDE: {
                    ((TileEntityMultiClutch)te).setSideOfState(data[0], data[1]);
                    break;
                }
                case TERRAFORMER: {
                    ((TileEntityTerraformer)te).setTarget(BiomeGenBase.field_76773_a[data[0]]);
                    break;
                }
                case CONVERTERPOWER: {
                    EnergyToPowerBase eng = (EnergyToPowerBase)te;
                    if (data[0] <= 0) {
                        eng.decrementOmega();
                        break;
                    }
                    eng.incrementOmega();
                    break;
                }
                case CONVERTERREDSTONE: {
                    ((EnergyToPowerBase)te).incrementRedstoneState();
                    break;
                }
                case FERTILIZER: {
                    if (!world.field_72995_K) break;
                    ReikaParticleHelper.BONEMEAL.spawnAroundBlock(world, x, y, z, 4);
                    break;
                }
                case GRAVELGUN: {
                    ReikaParticleHelper.EXPLODE.spawnAroundBlock(world, x, y, z, 1);
                    world.func_72908_a((double)x, (double)y, (double)z, "random.explode", 1.0f, 1.0f);
                    break;
                }
                case SLIDE: {
                    ItemStack is = ep.func_71045_bC();
                    is.field_77990_d = new NBTTagCompound();
                    is.field_77990_d.func_74778_a("file", stringdata);
                    break;
                }
                case POWERBUS: {
                    TileEntityPowerBus bus = (TileEntityPowerBus)te;
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[data[0] + 2];
                    bus.setMode(dir, !bus.isSideSpeedMode(dir));
                    break;
                }
                case PARTICLES: {
                    ((TileEntityParticleEmitter)te).particleType = ReikaParticleHelper.particleList[data[0]];
                    break;
                }
                case BLOWERWHITELIST: {
                    ((TileEntityBlower)te).isWhitelist = !((TileEntityBlower)te).isWhitelist;
                    break;
                }
                case BLOWERMETA: {
                    ((TileEntityBlower)te).checkMeta = !((TileEntityBlower)te).checkMeta;
                    break;
                }
                case BLOWERNBT: {
                    ((TileEntityBlower)te).checkNBT = !((TileEntityBlower)te).checkNBT;
                    break;
                }
                case BLOWEROREDICT: {
                    ((TileEntityBlower)te).useOreDict = !((TileEntityBlower)te).useOreDict;
                    break;
                }
                case DEFOLIATOR: {
                    ((TileEntityDefoliator)te).onBlockBreak(world, data[0], data[1], data[2]);
                    break;
                }
                case GPR: {
                    TileEntityGPR gpr = (TileEntityGPR)te;
                    int direction = data[0];
                    gpr.shift(gpr.getGuiDirection(), direction);
                    break;
                }
                case CRAFTERCRAFT: {
                    ((TileEntityAutoCrafter)te).triggerCraftingCycle(data[0]);
                    break;
                }
                case CRAFTERTHRESH: {
                    ((TileEntityAutoCrafter)te).setThreshold(data[0], data[1]);
                    break;
                }
                case CRAFTERMODE: {
                    ((TileEntityAutoCrafter)te).incrementMode();
                    break;
                }
                case POWERSYNC: {
                    TileEntityIOMachine io = (TileEntityIOMachine)te;
                    io.torque = data[0];
                    io.omega = data[1];
                    io.power = ReikaJavaLibrary.buildLong((int)data[2], (int)data[3]);
                    break;
                }
                case AFTERBURN: {
                    ((TileEntityJetEngine)te).setBurnerActive(data[0] > 0);
                    break;
                }
                case CRAFTPATTERNMODE: {
                    ItemCraftPattern.setMode(ep.func_71045_bC(), ItemCraftPattern.RecipeMode.list[data[0]]);
                    break;
                }
                case CRAFTPATTERNLIMIT: {
                    ItemCraftPattern.changeStackLimit(ep.func_71045_bC(), data[0]);
                    break;
                }
                case FILTERSETTING: {
                    TileEntityItemFilter.MatchData dat = TileEntityItemFilter.MatchData.createFromNBT(NBT);
                    ((TileEntityItemFilter)te).setData(dat);
                    break;
                }
                case SPRINKLER: {
                    ((TileEntitySprinkler)te).doParticle(world, data[0], data[1], data[2], data[3] > 0);
                    break;
                }
                case BLASTLEAVEONE: {
                    ((TileEntityBlastFurnace)te).leaveLastItem = data[0] > 0;
                    break;
                }
                case EMPEFFECT: {
                    ((TileEntityEMP)te).initEffect();
                    break;
                }
                case SPARKLOC: {
                    if (data[4] > 0) {
                        EMPSparkRenderer.instance.addSparkingLocation(new WorldLocation(data[0], data[1], data[2], data[3]));
                        break;
                    }
                    EMPSparkRenderer.instance.removeSparkingLocation(new WorldLocation(data[0], data[1], data[2], data[3]));
                    break;
                }
                case DISTRIBCLUTCH: {
                    ((TileEntityDistributionClutch)te).setSideEnabled(ForgeDirection.VALID_DIRECTIONS[data[0] + 2], data[1] > 0);
                    break;
                }
                case DISTRIBCLUTCHPOWER: {
                    ((TileEntityDistributionClutch)te).setTorqueRequests(data);
                    break;
                }
                case FRIDGEBREAK: {
                    TileEntityRefrigerator.doBreakFX(world, x, y, z);
                }
            }
        }
        catch (NullPointerException e) {
            RotaryCraft.logger.logError((Object)("Machine/item was deleted before its packet " + (Object)((Object)this.pack) + " could be received, or was not present at all!"));
            if (DragonOptions.CHATERRORS.getState()) {
                ReikaChatHelper.writeString((String)("Machine/item was deleted before its packet " + (Object)((Object)this.pack) + " could be received, or was not present at all!"));
            }
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendPowerSyncPacket(TileEntityIOMachine iotile, EntityPlayerMP ep) {
        int[] data = ReikaJavaLibrary.splitLong((long)iotile.power);
        if (ep != null) {
            ReikaPacketHelper.sendDataPacket((String)"RotaryCraftData", (int)PacketRegistry.POWERSYNC.ordinal(), (TileEntity)iotile, (EntityPlayerMP)ep, (int[])new int[]{iotile.torque, iotile.omega, data[0], data[1]});
        } else {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"RotaryCraftData", (int)PacketRegistry.POWERSYNC.ordinal(), (TileEntity)iotile, (int)64, (int[])new int[]{iotile.torque, iotile.omega, data[0], data[1]});
        }
    }
}

