/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityACEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityDCEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityGasEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityHydroEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityJetEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityMicroturbine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityPerformanceEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntitySteamEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityWindEngine;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public enum EngineType {
    DC(256, 4, EngineClass.ELECTRIC, TileEntityDCEngine.class),
    WIND(1024, 8, EngineClass.KINETIC, TileEntityWindEngine.class),
    STEAM(512, 32, EngineClass.THERMAL, TileEntitySteamEngine.class),
    GAS(512, 128, EngineClass.PISTON, TileEntityGasEngine.class),
    AC(256, 512, EngineClass.ELECTRIC, TileEntityACEngine.class),
    SPORT(1024, 256, EngineClass.PISTON, TileEntityPerformanceEngine.class),
    HYDRO(32, 16384, EngineClass.KINETIC, TileEntityHydroEngine.class),
    MICRO(131072, 16, EngineClass.TURBINE, TileEntityMicroturbine.class),
    JET(65536, 1024, EngineClass.TURBINE, TileEntityJetEngine.class);

    private final int torque;
    private final int omega;
    public final Class<? extends TileEntityEngine> engineClass;
    private TileEntity renderInstance;
    public final EngineClass type;
    public static final EngineType[] engineList;

    private EngineType(int rpm, int tq, EngineClass type, Class c) {
        this.omega = rpm;
        this.torque = tq;
        this.type = type;
        this.engineClass = c;
    }

    public int getSpeed() {
        return this.omega;
    }

    public int getTorque() {
        return this.torque;
    }

    public long getPower() {
        return (long)this.torque * (long)this.omega;
    }

    public boolean isJetFueled() {
        return this == JET || this == MICRO;
    }

    public boolean isEthanolFueled() {
        return this == GAS || this == SPORT;
    }

    public boolean isWaterPiped() {
        return this == STEAM || this == SPORT;
    }

    public boolean hasGui() {
        return this == STEAM || this == GAS || this == AC || this == SPORT || this == MICRO || this == JET;
    }

    public boolean burnsFuel() {
        return this == STEAM || this == GAS || this == SPORT || this == MICRO || this == JET;
    }

    public static EngineType setType(int type) {
        return EngineType.values()[type];
    }

    public int getSoundLength() {
        if (this.carNoise()) {
            return 88;
        }
        if (this.electricNoise()) {
            return 74;
        }
        if (this.steamNoise()) {
            return 49;
        }
        if (this.waterNoise()) {
            return 59;
        }
        if (this.windNoise()) {
            return 105;
        }
        if (this.jetNoise()) {
            return 79;
        }
        if (this.turbineNoise()) {
            return 20;
        }
        return 0;
    }

    public boolean isCooled() {
        return this == STEAM || this == SPORT;
    }

    public boolean isAirBreathing() {
        return this == GAS || this == SPORT || this == MICRO || this == JET;
    }

    public boolean electricNoise() {
        return this.type == EngineClass.ELECTRIC;
    }

    public boolean carNoise() {
        return this == GAS || this == SPORT;
    }

    public boolean waterNoise() {
        return this == HYDRO;
    }

    public boolean steamNoise() {
        return this == STEAM;
    }

    public boolean jetNoise() {
        return this == JET;
    }

    public boolean turbineNoise() {
        return this == JET || this == MICRO;
    }

    public boolean windNoise() {
        return this == WIND;
    }

    public boolean canHurtPlayer() {
        if (this == JET) {
            return true;
        }
        if (this == SPORT) {
            return true;
        }
        if (this == WIND) {
            return true;
        }
        return this == HYDRO;
    }

    public boolean isValidFuel(ItemStack is) {
        if (this == STEAM) {
            return is.func_77973_b() == Items.field_151131_as;
        }
        if (this == GAS) {
            return is.func_77973_b() == ItemRegistry.ETHANOL.getItemInstance();
        }
        if (this == SPORT) {
            return is.func_77973_b() == ItemRegistry.ETHANOL.getItemInstance() || this.isAdditive(is);
        }
        if (this == AC) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.shaftcore) || ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.tungstenshaftcore);
        }
        return false;
    }

    public boolean isAdditive(ItemStack is) {
        Item i = is.func_77973_b();
        if (this == SPORT) {
            return i == Items.field_151137_ax || i == Items.field_151016_H || i == Items.field_151065_br;
        }
        return false;
    }

    public int getFuelUnitDuration() {
        switch (this) {
            case STEAM: {
                return 18;
            }
            case GAS: {
                return 12;
            }
            case AC: {
                return 600;
            }
            case SPORT: {
                return 6;
            }
            case MICRO: {
                return 48;
            }
            case JET: {
                return 2;
            }
        }
        return 0;
    }

    public ItemStack getCraftedProduct() {
        return MachineRegistry.ENGINE.getCraftedMetadataProduct(this.ordinal());
    }

    public boolean isEMPImmune() {
        return this == HYDRO || this == WIND;
    }

    public boolean isECUControllable() {
        return this.type.isECUControllable();
    }

    public boolean canReceiveFluid(Fluid fluid) {
        switch (this) {
            case STEAM: {
                if (!fluid.equals(FluidRegistry.WATER)) break;
                return true;
            }
            case GAS: {
                if (!fluid.equals(FluidRegistry.getFluid((String)"rc ethanol"))) break;
                return true;
            }
            case SPORT: {
                if (fluid.equals(FluidRegistry.WATER)) {
                    return true;
                }
                if (!fluid.equals(FluidRegistry.getFluid((String)"rc ethanol"))) break;
                return true;
            }
            case HYDRO: {
                if (!fluid.equals(FluidRegistry.getFluid((String)"rc lubricant"))) break;
                return true;
            }
            case MICRO: 
            case JET: {
                if (!fluid.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public Fluid getFuelType() {
        switch (this) {
            case GAS: 
            case SPORT: {
                return FluidRegistry.getFluid((String)"rc ethanol");
            }
            case MICRO: 
            case JET: {
                return FluidRegistry.getFluid((String)"rc jet fuel");
            }
        }
        return null;
    }

    public boolean usesFluids() {
        return this.burnsFuel() || this.isWaterPiped() || this.requiresLubricant();
    }

    public boolean requiresLubricant() {
        return this == HYDRO;
    }

    public int getSizeInventory() {
        switch (this) {
            case STEAM: 
            case GAS: 
            case AC: {
                return 1;
            }
            case SPORT: {
                return 2;
            }
        }
        return 0;
    }

    public boolean allowInventoryStacking() {
        switch (this) {
            case GAS: 
            case SPORT: {
                return true;
            }
        }
        return false;
    }

    public boolean usesAdditives() {
        return this == SPORT;
    }

    public boolean hasInventory() {
        return this.getSizeInventory() > 0;
    }

    public boolean needsWater() {
        return this == STEAM || this == SPORT;
    }

    public TileEntityEngine newTileEntity() {
        try {
            return this.engineClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Engine type " + (Object)((Object)this) + " has a noninstantiable class!");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Engine type " + (Object)((Object)this) + " has an inaccessible class!");
        }
    }

    public TileEntity getTEInstanceForRender() {
        if (this.renderInstance == null) {
            this.renderInstance = this.newTileEntity();
        }
        return this.renderInstance;
    }

    static {
        engineList = EngineType.values();
    }

    public static enum EngineClass {
        KINETIC,
        THERMAL,
        ELECTRIC,
        PISTON,
        TURBINE;


        public boolean isECUControllable() {
            return this == PISTON || this == TURBINE;
        }
    }
}

