/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.ModInteract.ItemHandlers.MekToolHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.RedstoneArsenalHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.RotaryCraft.Registry.GearboxTypes;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public enum MaterialRegistry {
    WOOD(-1, 1.1E7, 6.2E8, 2.0E7, 1.16E7, 800.0),
    STONE(0, 5.0E10, 8.0E9, 1.0E8, 4.0E7, 3000.0),
    STEEL(1, 2.1E11, 7.93E10, 4.0E8, 2.8E8, 7800.0),
    TUNGSTEN(1, 4.11E11, 1.61E11, 9.8E8, 4.0E8, 10100.0),
    DIAMOND(2, 1.22E12, 4.78E11, 5.0E9, 2.9E9, 3500.0),
    BEDROCK(3, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 3000.0);

    private double Emod;
    private double Smod;
    private double tensile;
    private double shear;
    private double rho;
    public final int harvestLevel;
    private LoadData limits;
    public static final MaterialRegistry[] matList;

    private MaterialRegistry(int h, double E, double G, double TS, double S, double den) {
        this.Emod = E;
        this.Smod = G;
        this.tensile = TS;
        this.shear = S;
        this.rho = den;
        this.harvestLevel = h;
    }

    public double getElasticModulus() {
        return this.Emod;
    }

    public double getShearModulus() {
        return this.Smod;
    }

    public double getTensileStrength() {
        return this.tensile;
    }

    public double getShearStrength() {
        return this.shear;
    }

    public double getDensity() {
        return this.rho;
    }

    public boolean isInfiniteStrength() {
        return this == BEDROCK;
    }

    public boolean isFlammable() {
        return this == WOOD;
    }

    public String getDamageNoise() {
        if (this == WOOD) {
            return "dig.wood";
        }
        if (this == STONE) {
            return "dig.stone";
        }
        return "mob.blaze.hit";
    }

    public String getBaseShaftTexture() {
        String tex = "shafttex";
        switch (this) {
            case BEDROCK: {
                tex = tex + "b";
                break;
            }
            case DIAMOND: {
                tex = tex + "d";
                break;
            }
            case STONE: {
                tex = tex + "s";
                break;
            }
            case TUNGSTEN: {
                tex = tex + "t";
                break;
            }
            case WOOD: {
                tex = tex + "w";
                break;
            }
        }
        return tex + ".png";
    }

    public boolean isHarvestablePickaxe(ItemStack tool) {
        if (this.harvestLevel < 0) {
            return true;
        }
        if (tool == null) {
            return false;
        }
        Item item = tool.func_77973_b();
        if (item == ItemRegistry.BEDPICK.getItemInstance()) {
            return true;
        }
        if (item == ItemRegistry.STEELPICK.getItemInstance()) {
            return this != BEDROCK;
        }
        if (item instanceof ItemPickaxe) {
            switch (this) {
                case STONE: {
                    return true;
                }
                case STEEL: {
                    return item.canHarvestBlock(Blocks.field_150366_p, tool);
                }
                case DIAMOND: 
                case TUNGSTEN: {
                    return item.canHarvestBlock(Blocks.field_150482_ag, tool);
                }
                case BEDROCK: {
                    return item.canHarvestBlock(Blocks.field_150343_Z, tool);
                }
            }
            return false;
        }
        if (TinkerToolHandler.getInstance().isPick(tool)) {
            switch (this) {
                case STONE: {
                    return true;
                }
                case STEEL: {
                    return TinkerToolHandler.getInstance().isStoneOrBetter(tool);
                }
                case DIAMOND: 
                case TUNGSTEN: {
                    return TinkerToolHandler.getInstance().isIronOrBetter(tool);
                }
                case BEDROCK: {
                    return TinkerToolHandler.getInstance().isDiamondOrBetter(tool);
                }
            }
            return false;
        }
        if (MekToolHandler.getInstance().isPickTypeTool(tool)) {
            switch (this) {
                case STONE: {
                    return true;
                }
                case STEEL: {
                    return item.canHarvestBlock(Blocks.field_150366_p, tool);
                }
                case DIAMOND: 
                case TUNGSTEN: {
                    return item.canHarvestBlock(Blocks.field_150482_ag, tool);
                }
                case BEDROCK: {
                    return item.canHarvestBlock(Blocks.field_150343_Z, tool);
                }
            }
            return false;
        }
        if (item == RedstoneArsenalHandler.getInstance().pickID) {
            return RedstoneArsenalHandler.getInstance().pickLevel >= this.harvestLevel;
        }
        switch (this) {
            case STONE: {
                return item.canHarvestBlock(Blocks.field_150348_b, tool);
            }
            case STEEL: {
                return item.canHarvestBlock(Blocks.field_150366_p, tool);
            }
            case DIAMOND: 
            case TUNGSTEN: {
                return item.canHarvestBlock(Blocks.field_150482_ag, tool);
            }
            case BEDROCK: {
                return item.canHarvestBlock(Blocks.field_150343_Z, tool);
            }
        }
        return false;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("material." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    private double getMaxShaftTorque() {
        if (this.isInfiniteStrength()) {
            return Double.POSITIVE_INFINITY;
        }
        double r = 0.0625;
        double tau = this.getShearStrength();
        return 1.5707963267948966 * r * r * r * tau / 16.0;
    }

    private double getMaxShaftSpeed() {
        if (this.isInfiniteStrength()) {
            return Double.POSITIVE_INFINITY;
        }
        double f = 1.0 / this.getSpeedForceExponent();
        double rho = this.getDensity();
        double r = 0.0625;
        double sigma = this.getTensileStrength();
        double base = Math.sqrt(2.0 * sigma / (rho * r * r));
        return Math.pow(base, f);
    }

    public static int[] getAllLimitLoadsAsInts() {
        ArrayList<LoadData> li = MaterialRegistry.getAllLimitLoads();
        int[] ret = new int[li.size() * 2];
        for (int i = 0; i < li.size(); ++i) {
            LoadData l = li.get(i);
            ret[i * 2] = (int)l.maxTorque;
            ret[i * 2 + 1] = (int)l.maxSpeed;
        }
        return ret;
    }

    public static ArrayList<LoadData> getAllLimitLoads() {
        ArrayList<LoadData> li = new ArrayList<LoadData>();
        for (MaterialRegistry m : matList) {
            if (m.isInfiniteStrength()) continue;
            li.add(m.getLimits());
        }
        Collections.sort(li);
        return li;
    }

    public LoadData getLimits() {
        if (this.limits == null) {
            this.limits = new LoadData();
        }
        return this.limits;
    }

    public ItemStack getShaftItem() {
        ItemStack is = MachineRegistry.SHAFT.getCraftedProduct();
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74778_a("material", this.name());
        return is;
    }

    public static MaterialRegistry getMaterialFromShaftItem(ItemStack is) {
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b("material")) {
            return MaterialRegistry.valueOf(is.field_77990_d.func_74779_i("material"));
        }
        return matList[is.func_77960_j()];
    }

    public double getSpeedForceExponent() {
        switch (this) {
            case STONE: 
            case WOOD: 
            case STEEL: {
                return 1.0 - 0.11 * (double)this.ordinal();
            }
            case TUNGSTEN: {
                return 0.7;
            }
            case DIAMOND: {
                return 0.67;
            }
        }
        return 1.0;
    }

    public ItemStack getShaftUnitItem() {
        if (this == WOOD) {
            return new ItemStack(Items.field_151055_y);
        }
        return ItemRegistry.GEARCRAFT.getStackOfMetadata(GearboxTypes.getFromMaterial((MaterialRegistry)this).metaOffset * 16);
    }

    public Object getMountItem() {
        return GearboxTypes.getFromMaterial(this).getMountItem();
    }

    public String getShaftUnlocName() {
        return "material." + this.name().toLowerCase(Locale.ENGLISH);
    }

    static /* synthetic */ double access$100(MaterialRegistry x0) {
        return x0.getMaxShaftSpeed();
    }

    static /* synthetic */ double access$200(MaterialRegistry x0) {
        return x0.getMaxShaftTorque();
    }

    static {
        matList = MaterialRegistry.values();
    }

    public class LoadData
    implements Comparable<LoadData> {
        public final double maxSpeed = MaterialRegistry.access$100(this.getOwner());
        public final double maxTorque = MaterialRegistry.access$200(this.getOwner());

        private LoadData() {
        }

        @Override
        public int compareTo(LoadData o) {
            return this.getOwner().compareTo(o.getOwner());
        }

        private MaterialRegistry getOwner() {
            return MaterialRegistry.this;
        }
    }
}

