/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RCAchievementPage;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.GearboxTypes;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;

public enum RotaryAchievements {
    RCUSEBOOK(1, 1, ItemRegistry.HANDBOOK, null, false),
    DUMBEXTRACTOR(1, -1, EngineType.DC.getCraftedProduct(), null, false),
    MAKESTEEL(0, 0, ItemStacks.steelingot, null, false),
    FAILSTEEL(1, 2, ItemStacks.steelblock, MAKESTEEL, false),
    WORKTABLE(-2, 1, MachineRegistry.WORKTABLE, MAKESTEEL, false),
    MAKEYEAST(2, -2, ItemRegistry.YEAST, MAKESTEEL, false),
    EXTRACTOR(2, 0, ItemStacks.goldoreflakes, MAKESTEEL, false),
    PCB(0, 4, ItemStacks.pcb, MAKESTEEL, false),
    PUMP(-6, 0, MachineRegistry.PUMP, MAKESTEEL, false),
    GPR(-2, 4, MachineRegistry.GPR, PCB, false),
    BORER(2, 6, MachineRegistry.BORER, PCB, false),
    JETFUEL(4, -4, ItemRegistry.BUCKET.getStackOfMetadata(1), MAKEYEAST, false),
    RECYCLE(4, -8, ItemStacks.scrap, JETFUEL, false),
    JETENGINE(6, -4, EngineType.JET.getCraftedProduct(), JETFUEL, true),
    MAKERAILGUN(0, 8, MachineRegistry.RAILGUN, PCB, true),
    SUCKEDINTOJET(6, -8, Items.field_151078_bh, JETENGINE, false),
    BEDROCKBREAKER(-4, 2, ItemStacks.bedrockdust, MAKESTEEL, false),
    STEAMENGINE(-8, 0, EngineType.STEAM.getCraftedProduct(), PUMP, false),
    STEELSHAFT(-2, -2, MaterialRegistry.STEEL.getShaftItem(), MAKESTEEL, false),
    CVT(-2, -4, MachineRegistry.ADVANCEDGEARS.getCraftedMetadataProduct(1), STEELSHAFT, false),
    BEDROCKSHAFT(-4, 6, MaterialRegistry.BEDROCK.getShaftItem(), BEDROCKBREAKER, false),
    BEDROCKTOOLS(-6, 2, ItemRegistry.BEDPICK, BEDROCKBREAKER, false),
    JETCHICKEN(8, -4, Items.field_151008_G, JETENGINE, false),
    JETFAIL(8, -2, (Block)Blocks.field_150480_ab, JETENGINE, false),
    LIGHTFALL(8, -6, MachineRegistry.LIGHTBRIDGE, JETENGINE, false),
    SPRINKLER(-6, -2, MachineRegistry.SPRINKLER, PUMP, false),
    FLOODLIGHT(-1, -1, MachineRegistry.FLOODLIGHT, MAKESTEEL, false),
    DAMAGEGEARS(-4, -2, ItemStacks.gearunit, STEELSHAFT, false),
    DIAMONDGEARS(-4, -4, GearboxTypes.DIAMOND.getGearboxItem(8), DAMAGEGEARS, false),
    MRADS32(2, -6, ItemRegistry.METER, JETFUEL, true),
    GIGAWATT(6, 0, Blocks.field_150451_bX, JETENGINE, true),
    RAILDRAGON(2, 8, Blocks.field_150380_bt, MAKERAILGUN, true),
    RAILKILLED(0, 10, new ItemStack(Items.field_151144_bL, 1, 0), MAKERAILGUN, false),
    GRAVELGUN(0, -4, ItemRegistry.GRAVELGUN, MAKESTEEL, false),
    LANDMINE(2, 3, MachineRegistry.LANDMINE, MAKESTEEL, false),
    NETHERHEATRAY(4, -2, MachineRegistry.HEATRAY, JETFUEL, true),
    GPRSPAWNER(-2, 6, ItemRegistry.SPAWNER, GPR, true),
    GPRENDPORTAL(-2, 8, Blocks.field_150378_br, GPRSPAWNER, true),
    CUTKNOT(4, 6, ItemStacks.drill, BORER, true),
    RAREEXTRACT(4, 0, ExtractorModOres.getFlakeProduct(ModOreList.PLATINUM), EXTRACTOR, true),
    MASSIVEHIT(0, -8, Items.field_151145_ak, GRAVELGUN, true),
    OVERPRESSURE(-8, 2, MachineRegistry.COOLINGFIN, STEAMENGINE, false),
    DOUBLEKILL(-2, -6, Items.field_151032_g, GRAVELGUN, true),
    INSANITY(2, 2, MachineRegistry.EXTRACTOR, EXTRACTOR, true),
    INSTANTBED(-6, 4, MachineRegistry.BEDROCKBREAKER, BEDROCKBREAKER, true),
    PULSEFIRE(5, -5, MachineRegistry.PULSEJET, JETFUEL, false);

    public static final RotaryAchievements[] list;
    public final RotaryAchievements dependency;
    public final int xPosition;
    public final int yPosition;
    public final boolean isSpecial;
    private final ItemStack iconItem;

    private RotaryAchievements(int x, int y, Item icon, RotaryAchievements preReq, boolean special) {
        this(x, y, new ItemStack(icon), preReq, special);
    }

    private RotaryAchievements(int x, int y, Block icon, RotaryAchievements preReq, boolean special) {
        this(x, y, new ItemStack(icon), preReq, special);
    }

    private RotaryAchievements(int x, int y, ItemRegistry icon, RotaryAchievements preReq, boolean special) {
        this(x, y, icon.getStackOf(), preReq, special);
    }

    private RotaryAchievements(int x, int y, MachineRegistry icon, RotaryAchievements preReq, boolean special) {
        this(x, y, icon.getCraftedProduct(), preReq, special);
    }

    private RotaryAchievements(int x, int y, ItemStack icon, RotaryAchievements preReq, boolean special) {
        this.xPosition = x;
        this.yPosition = y;
        this.dependency = preReq;
        this.iconItem = icon;
        this.isSpecial = special;
    }

    public Achievement get() {
        return RotaryCraft.achievements[this.ordinal()];
    }

    public void triggerAchievement(EntityPlayer ep) {
        if (!ConfigRegistry.ACHIEVEMENTS.getState()) {
            return;
        }
        if (RotaryCraft.instance.isLocked()) {
            return;
        }
        if (ep == null) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                RotaryCraft.logger.debug((Object)("Player does not exist to receive their achievement \"" + (Object)((Object)this) + "\"!"));
            }
        } else {
            ep.func_71029_a((StatBase)this.get());
        }
    }

    public boolean hasDependency() {
        return this.dependency != null;
    }

    public static void registerAchievements() {
        for (int i = 0; i < list.length; ++i) {
            RotaryAchievements a = list[i];
            int id = RotaryCraft.config.getAchievementID(i);
            Achievement dep = a.hasDependency() ? a.dependency.get() : null;
            Achievement ach = new Achievement(a.name().toLowerCase(Locale.ENGLISH), a.name().toLowerCase(Locale.ENGLISH), a.xPosition, a.yPosition, a.iconItem, dep);
            if (a.isSpecial) {
                ach.func_75987_b();
            }
            RotaryCraft.achievements[i] = ach;
            ach.func_75971_g();
            RotaryCraft.logger.log((Object)("Registering achievement " + (Object)((Object)a) + " with ID " + id + " and ingame name \"" + (Object)((Object)a) + "\" (slot " + i + ")."));
        }
        AchievementPage.registerAchievementPage((AchievementPage)new RCAchievementPage("RotaryCraft", RotaryCraft.achievements));
    }

    static {
        list = RotaryAchievements.values();
    }
}

