/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.TinkerSmelteryHandler;
import Reika.DragonAPI.ModInteract.DeepInteract.TransvectorHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesFrictionHeater;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceHeater
extends TileEntityPowerReceiver
implements TemperatureTE,
ConditionalOperation {
    public static final int MAXTEMP = 2000;
    private RecipesFrictionHeater.FrictionRecipe activeRecipe;
    private Coordinate furnaceLocation;
    private int temperature;
    private int smeltTime = 0;
    private int soundtick = 0;

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb;
        if (this.torque >= this.MINTORQUE && this.power >= this.MINPOWER && this.omega > 0 && this.hasHeatableMachine(world)) {
            this.temperature = (int)((double)this.temperature + 3.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2) * ReikaMathLibrary.logbase((long)this.torque, (int)2));
        }
        int n = Tamb = this.power > this.MINPOWER && this.torque > this.MINTORQUE ? 30 : ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        this.temperature = this.temperature > Tamb ? (this.temperature -= (this.temperature - Tamb) / 5) : (this.temperature += (this.temperature - Tamb) / 5);
        if (this.temperature - Tamb <= 4 && this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > 2000) {
            this.temperature = 2000;
        }
        if (this.temperature >= 2000 && !world.field_72995_K && ConfigRegistry.BLOCKDAMAGE.getState() && rand.nextInt(DifficultyEffects.FURNACEMELT.getInt()) == 0) {
            this.meltFurnace(world);
        }
        if (this.temperature < Tamb) {
            this.temperature = Tamb;
        }
    }

    private boolean hasHeatableMachine(World world) {
        if (this.furnaceLocation == null) {
            return false;
        }
        Block id = this.furnaceLocation.getBlock((IBlockAccess)world);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id == Blocks.field_150460_al || id == Blocks.field_150470_am) {
            return true;
        }
        int meta = this.furnaceLocation.getBlockMetadata((IBlockAccess)world);
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, this.furnaceLocation.xCoord, this.furnaceLocation.yCoord, this.furnaceLocation.zCoord);
        if (m != null && m.canBeFrictionHeated()) {
            return true;
        }
        TileEntity te = this.furnaceLocation.getTileEntity((IBlockAccess)world);
        if (ModList.THAUMICTINKER.isLoaded()) {
            TileEntity relay = TransvectorHandler.getRelayedTile((TileEntity)te);
            while (relay != te && relay != null) {
                te = relay;
                relay = TransvectorHandler.getRelayedTile((TileEntity)te);
            }
            te = relay;
            if (te != null) {
                this.furnaceLocation = new Coordinate(te);
            }
        }
        if (ModList.TINKERER.isLoaded() && TinkerSmelteryHandler.isSmelteryController((TileEntity)te)) {
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && ReikaThaumHelper.isAlchemicalFurnace((TileEntity)te)) {
            return true;
        }
        return te instanceof ThermalMachine;
    }

    @Override
    public int getThermalDamage() {
        return this.temperature * 5 / 1200;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.torque < this.MINTORQUE) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FRICTION;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.activeRecipe = null;
        ++this.tickcount;
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        this.getFurnaceCoordinates(world, x, y, z, meta);
        if (this.tickcount >= 20) {
            this.tickcount = 0;
            this.updateTemperature(world, x, y, z, meta);
        }
        if (!this.isActive()) {
            return;
        }
        if (this.hasFurnace()) {
            this.hijackFurnace(world, x, y, z, meta);
        } else {
            TileEntity te = this.furnaceLocation.getTileEntity((IBlockAccess)world);
            if (te instanceof ThermalMachine) {
                this.heatMachine(world, x, y, z, (ThermalMachine)te);
            } else if (ModList.TINKERER.isLoaded() && TinkerSmelteryHandler.isSmelteryController((TileEntity)te)) {
                TinkerSmelteryHandler.SmelteryWrapper s = new TinkerSmelteryHandler.SmelteryWrapper(te);
                s.fuelLevel = 4000;
                s.meltPower = this.temperature * 25 / 6;
                s.write(te);
            } else if (ModList.THAUMCRAFT.isLoaded() && ReikaThaumHelper.isAlchemicalFurnace((TileEntity)te)) {
                ReikaThaumHelper.setAlchemicalBurnTime((TileEntity)te, (int)(1 + this.temperature / 20));
            }
        }
    }

    public boolean isActive() {
        return this.power >= this.MINPOWER && this.torque >= this.MINTORQUE;
    }

    private void heatMachine(World world, int x, int y, int z, ThermalMachine te) {
        if (te.canBeFrictionHeated()) {
            int tdiff = Math.min(te.getMaxTemperature(), this.temperature) - te.getTemperature();
            if (tdiff > 0 || tdiff == 0 && this.temperature == te.getMaxTemperature()) {
                te.addTemperature(Math.max(1, (int)((float)tdiff * te.getMultiplier())));
                te.resetAmbientTemperatureTimer();
            }
            if (te.getTemperature() > te.getMaxTemperature()) {
                te.onOverheat(world, this.furnaceLocation.xCoord, this.furnaceLocation.yCoord, this.furnaceLocation.zCoord);
            }
            ++this.soundtick;
            if (this.soundtick > 49) {
                SoundRegistry.FRICTION.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.1f : 0.5f, 1.0f);
                this.soundtick = 0;
            }
        }
    }

    private boolean canTileMake(TileEntityFurnace tile, ItemStack is) {
        ItemStack out = tile.func_70301_a(2);
        if (out == null) {
            return true;
        }
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)out) && is.field_77994_a + out.field_77994_a <= is.func_77976_d();
    }

    private void hijackFurnace(World world, int x, int y, int z, int meta) {
        int burn;
        TileEntity te = this.furnaceLocation.getTileEntity((IBlockAccess)world);
        TileEntityFurnace tile = (TileEntityFurnace)te;
        boolean flag = tile.field_145956_a > 0;
        tile.field_145963_i = burn = Math.max(this.getBurnTimeFromTemperature(), tile.field_145956_a);
        tile.field_145956_a = burn;
        if (burn > 0 && !flag) {
            BlockFurnace.func_149931_a((boolean)true, (World)world, (int)this.furnaceLocation.xCoord, (int)this.furnaceLocation.yCoord, (int)this.furnaceLocation.zCoord);
        }
        ItemStack in = tile.func_70301_a(0);
        int fx = this.furnaceLocation.xCoord;
        int fy = this.furnaceLocation.yCoord;
        int fz = this.furnaceLocation.zCoord;
        if (in != null) {
            ItemStack out = tile.func_70301_a(2);
            ItemStack smelt = FurnaceRecipes.func_77602_a().func_151395_a(in);
            RecipesFrictionHeater.FrictionRecipe special = RecipesFrictionHeater.getRecipes().getSmelting(in, this.temperature);
            if (special != null && !this.canTileMake(tile, special.getOutput())) {
                special = null;
            }
            if (smelt != null || special != null) {
                this.activeRecipe = special;
                int factor = this.getSpeedFactorFromTemperature();
                if (special != null) {
                    factor = (int)((float)factor * this.getAccelerationFactor(special));
                }
                this.smeltTime += 1 + factor;
                int max = special != null ? special.duration : 200;
                tile.field_145961_j = Math.min(this.smeltTime, max - 5) * 200 / max;
                if (this.smeltTime >= max) {
                    int xp = 0;
                    if (smelt != null && tile.func_145948_k()) {
                        tile.func_145949_j();
                        xp = MathHelper.func_76123_f((float)FurnaceRecipes.func_77602_a().func_151398_b(smelt));
                    } else if (special != null) {
                        ItemStack out2 = special.getOutput();
                        ReikaInventoryHelper.decrStack((int)0, (IInventory)tile, (int)1);
                        int amt = out != null ? out.field_77994_a + out2.field_77994_a : out2.field_77994_a;
                        out = ReikaItemHelper.getSizedItemStack((ItemStack)out2, (int)amt);
                        tile.func_70299_a(2, out);
                        xp = 1;
                    }
                    if (xp > 0 && ConfigRegistry.FRICTIONXP.getState()) {
                        ReikaWorldHelper.splitAndSpawnXP((World)world, (double)((double)fx + 0.5), (double)((double)fy + 0.6), (double)((double)fz + 0.5), (int)xp, (int)600);
                    }
                    this.smeltTime = 0;
                }
            } else {
                tile.field_145961_j = 0;
            }
        } else {
            tile.field_145961_j = 0;
        }
        ++this.soundtick;
        if (this.soundtick > 49) {
            SoundRegistry.FRICTION.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.1f : 0.5f, 1.0f);
            this.soundtick = 0;
        }
        switch (meta) {
            case 0: {
                world.func_72869_a("crit", (double)x, (double)fy + rand.nextDouble(), (double)fz + rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble(), 0.4 * rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble());
                break;
            }
            case 1: {
                world.func_72869_a("crit", (double)(x + 1), (double)fy + rand.nextDouble(), (double)fz + rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble(), 0.4 * rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble());
                break;
            }
            case 2: {
                world.func_72869_a("crit", (double)fx + rand.nextDouble(), (double)fy + rand.nextDouble(), (double)z, -0.2 + 0.4 * rand.nextDouble(), 0.4 * rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble());
                break;
            }
            case 3: {
                world.func_72869_a("crit", (double)fx + rand.nextDouble(), (double)fy + rand.nextDouble(), (double)(z + 1), -0.2 + 0.4 * rand.nextDouble(), 0.4 * rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble());
            }
        }
    }

    private float getAccelerationFactor(RecipesFrictionHeater.FrictionRecipe rec) {
        float fac = (float)this.temperature / (float)rec.requiredTemperature;
        return Math.min(1.0f, fac * fac - 1.0f);
    }

    private void getFurnaceCoordinates(World world, int x, int y, int z, int meta) {
        this.furnaceLocation = new Coordinate((TileEntity)this).offset(this.getReadDirection().getOpposite(), 1);
    }

    private void meltFurnace(World world) {
        Block id = this.furnaceLocation.getBlock((IBlockAccess)world);
        if (id != Blocks.field_150460_al && id != Blocks.field_150470_am) {
            return;
        }
        world.func_72876_a(null, (double)this.furnaceLocation.xCoord + 0.5, (double)this.furnaceLocation.yCoord + 0.5, (double)this.furnaceLocation.zCoord + 0.5, 1.0f, false);
        this.furnaceLocation.setBlock(world, Blocks.field_150350_a);
    }

    public boolean hasFurnace() {
        return this.furnaceLocation != null && this.furnaceLocation.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityFurnace;
    }

    private int getBurnTimeFromTemperature() {
        if (this.temperature < 300) {
            return 0;
        }
        return (this.temperature - 300) * 2;
    }

    private int getSpeedFactorFromTemperature() {
        if (this.temperature < 500) {
            return 1;
        }
        if (this.temperature == 2000) {
            return 2000;
        }
        return 1 + (int)Math.sqrt(Math.pow(2.0, (float)(this.temperature - 500) / 100.0f));
    }

    public RecipesFrictionHeater.FrictionRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return this.temperature / 100;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
        if (this.furnaceLocation != null) {
            this.furnaceLocation.writeToNBT("furnLoc", NBT);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
        if (NBT.func_74764_b("furnLoc")) {
            this.furnaceLocation = Coordinate.readFromNBT((String)"furnLoc", (NBTTagCompound)NBT);
        }
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public void onEMP() {
    }

    @Override
    public boolean areConditionsMet() {
        return this.hasHeatableMachine(this.field_145850_b);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Heatable Machine";
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public boolean allowHeatExtraction() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    public static boolean isHijacked(TileEntityFurnace furn) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = furn.field_145851_c + dir.offsetX;
            int dz = furn.field_145849_e + dir.offsetZ;
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)furn.field_145850_b, dx, furn.field_145848_d, dz);
            if (m != MachineRegistry.FRICTION) continue;
            TileEntityFurnaceHeater te = (TileEntityFurnaceHeater)furn.field_145850_b.func_147438_o(dx, furn.field_145848_d, dz);
            if (te.furnaceLocation == null || !te.furnaceLocation.equals((TileEntity)furn) || !te.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 2000;
    }
}

