/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityHeater
extends InventoriedPowerReceiver
implements TemperatureTE,
DiscreteFunction {
    public int temperature;
    public int setTemperature;
    private int tickcount2 = 0;
    public static final int MAXTEMP = 2000;
    public boolean idle = false;

    public void testIdle() {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (this.setTemperature <= Tamb) {
            this.idle = true;
            return;
        }
        if (this.findHottestUsefulItemTemp(this.setTemperature, false) == -1) {
            this.idle = true;
            return;
        }
        this.idle = false;
    }

    public int func_70302_i_() {
        return 18;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        ++this.tickcount2;
        this.getPowerBelow();
        if (this.tickcount2 >= 20) {
            this.updateTemperature(world, x, y, z, meta);
            this.tickcount2 = 0;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        this.testIdle();
        if (this.tickcount >= this.getOperationTime()) {
            this.addHeat();
            this.tickcount = 0;
        }
        this.transferHeat(world, x, y + 1, z);
        if (this.temperature >= 240) {
            this.ignite(world, x, y, z);
        }
    }

    private void ignite(World world, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1));
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase hot : inbox) {
            hot.func_70015_d(this.temperature / 50);
        }
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.temperature > Tamb) {
            this.temperature -= Math.max((this.temperature - Tamb) / 200, 1);
        }
        if (this.temperature < Tamb) {
            this.temperature += Math.max((Tamb - this.temperature) / 40, 1);
        }
    }

    private void addHeat() {
        int tempdiff = this.setTemperature - this.temperature;
        if (tempdiff <= 0) {
            return;
        }
        int deltaT = this.findHottestUsefulItemTemp(tempdiff, true);
        if (deltaT != -1) {
            this.temperature = (int)((double)this.temperature + (double)deltaT * 1.5);
        }
        if ((double)this.temperature >= 1800.0) {
            RotaryCraft.logger.warn((Object)("WARNING: " + this + " is reaching a very high temperature!"));
        }
        if (this.temperature > 2000) {
            this.overheat(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.temperature = 2000;
        }
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        ReikaWorldHelper.overheat((World)world, (int)x, (int)y, (int)z, (ItemStack)ItemStacks.scrap.func_77946_l(), (int)0, (int)17, (boolean)true, (float)1.2f, (boolean)true, (boolean)true, (float)1.0f);
        world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
        this.temperature = 0;
        this.setTemperature = 0;
    }

    private int findHottestUsefulItemTemp(int maxT, boolean consume) {
        ItemStack item = null;
        int itemheat = -1;
        int slot = -1;
        for (int i = 0; i < this.inv.length; ++i) {
            int heat;
            if (this.inv[i] == null || (heat = TileEntityFurnace.func_145952_a((ItemStack)this.inv[i]) / 25) > maxT || heat <= itemheat) continue;
            itemheat = heat;
            item = this.inv[i];
            slot = i;
        }
        if (slot != -1 && consume) {
            int leftover;
            Item id = this.inv[slot].func_77973_b();
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
            if (id == Items.field_151129_at && (leftover = ReikaInventoryHelper.addToInventoryWithLeftover((Item)Items.field_151133_ar, (int)-1, (int)1, (ItemStack[])this.inv)) > 0) {
                EntityItem ei = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + rand.nextFloat()), (double)((float)this.field_145848_d + rand.nextFloat()), (double)((float)this.field_145849_e + rand.nextFloat()), new ItemStack(Items.field_151129_at, leftover, 0));
                ReikaEntityHelper.addRandomDirVelocity((Entity)ei, (double)0.2);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)ei);
                }
            }
        }
        return itemheat;
    }

    private void transferHeat(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            ReikaWorldHelper.temperatureEnvironment((World)world, (int)x, (int)(y - 1), (int)z, (int)this.temperature);
        }
        MachineRegistry id = MachineRegistry.getMachine((IBlockAccess)world, x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ThermalMachine) {
            ThermalMachine th = (ThermalMachine)te;
            int tempdiff = this.temperature - th.getTemperature();
            if (tempdiff <= 0) {
                return;
            }
            if (tempdiff > 100) {
                th.addTemperature(tempdiff / 16);
            } else if (tempdiff > 16) {
                th.addTemperature(tempdiff / 8);
            } else if (tempdiff > 8) {
                th.addTemperature(tempdiff / 4);
            } else {
                th.addTemperature(tempdiff);
            }
            if (th.getTemperature() > th.getMaxTemperature()) {
                th.onOverheat(world, x, y, z);
            }
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temperature");
        this.setTemperature = NBT.func_74762_e("stemp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temperature", this.temperature);
        NBT.func_74768_a("stemp", this.setTemperature);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.HEATER;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return TileEntityFurnace.func_145952_a((ItemStack)is) > 0;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    public int getRedstoneOverride() {
        if (this.idle) {
            return 15;
        }
        return 0;
    }

    @Override
    public void addTemperature(int temp) {
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.HEATER.getOperationTime(this.omega);
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public boolean allowHeatExtraction() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 2000;
    }
}

