/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.SolarPlantBlock;
import Reika.RotaryCraft.Auxiliary.SolarPlant;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityMirror
extends RotaryCraftTileEntity
implements SolarPlantBlock {
    @SideOnly(value=Side.CLIENT)
    public float theta;
    @SideOnly(value=Side.CLIENT)
    private float targetTheta;
    @SideOnly(value=Side.CLIENT)
    private float targetPhi;
    public boolean broken;
    private boolean rotatingLarge;
    private float aimFactor = 1.0f;
    private float lastAimFactor;
    private SolarPlant plant;

    @Override
    public void searchForPlant(World world, int x, int y, int z) {
        if (this.plant != null) {
            return;
        }
        this.plant = SolarPlant.build(world, x, y, z);
    }

    @Override
    public SolarPlant getPlant() {
        return this.plant;
    }

    @Override
    public void setPlant(SolarPlant p) {
        this.plant = p;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.MIRROR;
    }

    public float getAimingAccuracy() {
        return this.aimFactor;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.broken) {
            return;
        }
        this.searchForPlant(world, x, y, z);
        if (world.field_72995_K && (this.getTicksExisted() < 400 || this.rotatingLarge || Math.abs(world.func_82737_E() % 8L) == (long)Math.abs(System.identityHashCode(this) % 8))) {
            this.adjustAim(world, x, y, z, meta);
        }
        if (!world.field_72995_K) {
            AxisAlignedBB above = AxisAlignedBB.func_72330_a((double)((double)x + 0.25), (double)(y + 1), (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 1.5), (double)((double)z + 0.75));
            List in = world.func_72872_a(Entity.class, above);
            for (Entity e : in) {
                if (!ReikaEntityHelper.isSolidEntity((Entity)e)) continue;
                double m = ReikaEntityHelper.getEntityMass((Entity)e);
                if (!(e.field_70181_x < -0.1) || !(m - e.field_70181_x * 20.0 > 80.0)) continue;
                ReikaPacketHelper.sendUpdatePacket((String)"RotaryCraftData", (int)PacketRegistry.MIRROR.ordinal(), (TileEntity)this, (PacketTarget)new PacketTarget.RadiusTarget((TileEntity)this, 32.0));
                e.func_70097_a(DamageSource.field_76367_g, 1.0f);
                this.breakMirror(world, x, y, z);
                break;
            }
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public boolean isFunctional() {
        if (this.broken) {
            return false;
        }
        if (MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) != null) {
            return false;
        }
        return this.plant != null && this.plant.canSeeTheSky(this);
    }

    @SideOnly(value=Side.CLIENT)
    private void adjustAim(World world, int x, int y, int z, int meta) {
        float aim;
        boolean bool;
        if (this.plant == null) {
            return;
        }
        Coordinate target = this.plant.getAimingPositionForMirror(this);
        if (target == null) {
            return;
        }
        long tot = world.func_72820_D();
        int time = (int)(tot % 12000L);
        float sunphi = (time = this.forceDuskDawnAiming(tot, time)) >= 6000 ? -90.0f : 90.0f;
        float suntheta = ReikaWorldHelper.getSunAngle((World)world);
        float movespeed = 0.5f;
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(x - target.xCoord), (double)(y - target.yCoord), (double)(z - target.zCoord));
        float targetphi = (float)angs[2];
        float targettheta = (float)angs[1];
        targettheta = Math.abs(targettheta) - 90.0f;
        targettheta = (float)((double)targettheta * 0.5);
        sunphi = this.clampPhi(sunphi, time);
        boolean bl = bool = time >= 6000 || targetphi > 270.0f;
        if (bool) {
            targetphi = this.clampPhi(targetphi, time);
        }
        float finalphi = time >= 6000 ? sunphi - (sunphi - targetphi) / 2.0f : sunphi + (targetphi - sunphi) / 2.0f;
        float sunangle = time >= 6000 ? (float)(1.0 - Math.cos(Math.toRadians((double)(time - 6000) * 90.0 / 6000.0))) : (float)Math.cos(Math.toRadians((double)time * 90.0 / 6000.0));
        finalphi = finalphi * sunangle + (1.0f - sunangle) * targetphi;
        finalphi = this.clampPhi(finalphi, time);
        float finaltheta = targettheta + (suntheta - targettheta) / 2.0f;
        if (!(targetphi >= 0.0f && targetphi <= 90.0f || time < 6000)) {
            finalphi = -sunphi - (sunphi - targetphi) / 2.0f;
            finalphi = finalphi * sunangle + (1.0f - sunangle) * targetphi;
        }
        finalphi = this.adjustPhiForClosestPath(finalphi);
        if (Math.abs(sunphi - targetphi) == 180.0f) {
            finalphi = targetphi;
            finaltheta = Math.max(60.0f - suntheta, finaltheta);
        }
        if (finalphi - this.phi > 180.0f) {
            finalphi -= 360.0f;
        }
        this.targetTheta = finaltheta;
        this.targetPhi = finalphi;
        if (this.phi < this.targetPhi) {
            this.phi += movespeed;
        }
        if (this.phi > this.targetPhi) {
            this.phi -= movespeed;
        }
        if (this.theta < this.targetTheta) {
            this.theta += movespeed;
        }
        if (this.theta > this.targetTheta) {
            this.theta -= movespeed;
        }
        if ((double)Math.abs(this.aimFactor - (aim = (float)Math.max(0.0, 1.0 - ReikaMathLibrary.py3d((double)(this.theta - this.targetTheta), (double)0.0, (double)(this.phi - this.targetPhi)) / 20.0))) > 0.05) {
            this.lastAimFactor = this.aimFactor;
            this.aimFactor = aim;
            ReikaPacketHelper.sendSyncPacket((String)"RotaryCraftData", (TileEntity)this, (String)"aimFactor", (boolean)true);
        }
        this.rotatingLarge = this.rotatingLarge ? Math.abs(this.targetPhi - this.phi) > 2.0f : Math.abs(this.targetPhi - this.phi) > 10.0f;
    }

    private int forceDuskDawnAiming(long tot, int time) {
        int day = (int)(tot % 24000L);
        if (ReikaMathLibrary.isValueInsideBoundsIncl((int)12000, (int)13000, (int)day)) {
            return 11999;
        }
        if (ReikaMathLibrary.isValueInsideBoundsIncl((int)23000, (int)24000, (int)day)) {
            return 0;
        }
        return time;
    }

    public void breakMirror(World world, int x, int y, int z) {
        this.broken = true;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReikaRenderHelper.addModelledBlockParticles((String)"/Reika/RotaryCraft/Textures/TileEntityTex/", (World)world, (int)x, (int)y, (int)z, (Block)this.getMachine().getBlock(), (EffectRenderer)Minecraft.func_71410_x().field_71452_i, (List)ReikaJavaLibrary.makeListFrom((Object)new double[]{0.0, 0.0, 1.0, 1.0}), RotaryCraft.class);
        }
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150359_w);
    }

    public void repair(World world, int x, int y, int z) {
        this.broken = false;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("broke", this.broken);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.broken = NBT.func_74767_n("broke");
    }

    @SideOnly(value=Side.CLIENT)
    private float clampPhi(float phi, int time) {
        boolean afternoon;
        boolean bl = afternoon = time >= 6000;
        if (afternoon) {
            if (phi >= 360.0f) {
                phi -= 360.0f;
            }
            if (phi < -360.0f) {
                phi += 360.0f;
            }
        } else {
            if (phi > 180.0f) {
                phi -= 360.0f;
            }
            if (phi <= -180.0f) {
                phi += 360.0f;
            }
        }
        return phi;
    }

    @SideOnly(value=Side.CLIENT)
    private float adjustPhiForClosestPath(float finalphi) {
        if (!ReikaMathLibrary.isSameSign((double)finalphi, (double)this.phi)) {
            if (finalphi < -180.0f) {
                finalphi += 360.0f;
            }
            if (finalphi > 180.0f) {
                finalphi -= 360.0f;
            }
            if (finalphi < 0.0f && finalphi < -90.0f) {
                finalphi += 360.0f;
            }
        }
        return finalphi;
    }

    @Override
    public void onEMP() {
    }

    public void breakBlock() {
        if (this.plant != null) {
            this.plant.invalidate(this.field_145850_b);
        }
    }
}

