/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.ChromatiCraft.API.ChromatiAPI;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.HarvesterDamage;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.MachineEnchantmentHandler;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityMobHarvester
extends TileEntityPowerReceiver
implements EnchantableMachine {
    private final MachineEnchantmentHandler enchantments = new MachineEnchantmentHandler().addFilter(Enchantment.field_77342_w).addFilter(Enchantment.field_77338_j).addFilter(Enchantment.field_77334_n).addFilter(Enchantment.field_77348_q).addFilter(Enchantment.field_77335_o);
    public String owner;
    public boolean laser;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        EntityPlayer ep = this.getPlacer();
        boolean oneplus = false;
        AxisAlignedBB box = this.getBox();
        List inbox = world.func_72872_a(EntityLiving.class, box);
        for (EntityLiving ent : inbox) {
            int dmg;
            if (ent instanceof EntityVillager) continue;
            oneplus = true;
            if (ep != null && (dmg = this.getDamage()) > 0) {
                ent.func_70097_a((DamageSource)new HarvesterDamage(this), (float)dmg);
                if (this.enchantments.hasEnchantment(Enchantment.field_77348_q) && rand.nextInt(20) == 0) {
                    ReikaEntityHelper.dropHead((EntityLivingBase)ent);
                }
                if (this.enchantments.hasEnchantment(Enchantment.field_77334_n)) {
                    ent.func_70015_d(this.enchantments.getEnchantment(Enchantment.field_77334_n) * 2);
                }
            }
            ent.field_70181_x = 0.0;
        }
        this.laser = oneplus;
    }

    public int getDamage() {
        double pdiff = 2.0 + 0.5 * (double)this.power / (double)this.MINPOWER;
        double ppdiff = ReikaMathLibrary.intpow((double)pdiff, (int)6);
        double base = ReikaMathLibrary.logbase((double)ppdiff, (double)2.0) + (double)(2 * this.enchantments.getEnchantment(Enchantment.field_77338_j));
        if (ModList.CHROMATICRAFT.isLoaded()) {
            base *= ChromatiAPI.getAPI().adjacency().getFactorSimple(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "PINK");
        }
        return (int)base;
    }

    public AxisAlignedBB getBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + this.getHeight() + 1), (double)(this.field_145849_e + 1));
    }

    private int getHeight() {
        return Math.min(6, 2 + Math.max(0, (int)this.power / 524288));
    }

    public AxisAlignedBB getLaser() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.4), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.4), (double)((double)this.field_145851_c + 0.6), (double)(this.field_145848_d + this.getHeight()), (double)((double)this.field_145849_e + 0.6));
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.owner != null && !this.owner.isEmpty()) {
            NBT.func_74778_a("sowner", this.owner);
        }
        NBT.func_74782_a("enchants", (NBTBase)this.enchantments.writeToNBT());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.owner = NBT.func_74779_i("sowner");
        this.enchantments.readFromNBT(NBT.func_150295_c("enchants", ReikaNBTHelper.NBTTypes.COMPOUND.ID));
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.MOBHARVESTER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public MachineEnchantmentHandler getEnchantmentHandler() {
        return this.enchantments;
    }
}

