/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.RotaryCraft.API.Event.SpawnerControllerSpawnEvent;
import Reika.RotaryCraft.API.Interfaces.ControllableSpawner;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySpawnerController
extends TileEntityPowerReceiver
implements GuiController,
DiscreteFunction,
ConditionalOperation {
    public static final int BASEDELAY = 800;
    public boolean disable;
    private SpawnerControl control = null;
    private int setDelay = 800;
    private StepTimer timer = new StepTimer(0);
    public static final String CONTROLLED_SPAWN_TAG = "ControllerSpawned";

    @Override
    public int getOperationTime() {
        int time = 800 - 40 * (int)ReikaMathLibrary.logbase((long)this.omega, (int)2);
        if (time < 0) {
            time = 0;
        }
        return time;
    }

    public void setDelay(int delay) {
        this.setDelay = delay;
        this.timer.setCap(this.setDelay);
        this.timer.setTick(Math.min(this.setDelay - 1, this.timer.getTick()));
    }

    public int getDelay() {
        if (this.setDelay >= this.getOperationTime()) {
            return this.setDelay;
        }
        return this.getOperationTime();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (!this.isValidLocation(world, x, y, z)) {
            this.disable = false;
            this.setDelay(0);
            this.timer.setTick(0);
            this.torque = 0;
            this.omega = 0;
            this.power = 0L;
            this.setPointingOffset(0, -1, 0);
            this.control = null;
            return;
        }
        this.getOffsetPower4Sided(0, -1, 0, true);
        if (this.power >= this.MINPOWER && this.setDelay > 0) {
            this.applyToSpawner(world, x, y, z);
        }
    }

    private void shutdownSpawner(World world, int x, int y, int z) {
        this.control.setInactive();
        for (int i = 0; i < 4; ++i) {
            double var1 = (float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat();
            double var3 = (float)this.field_145848_d - 1.0f + this.field_145850_b.field_73012_v.nextFloat();
            double var5 = (float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat();
            double var11 = (double)this.field_145851_c - 0.25 + 1.5 * (double)this.field_145850_b.field_73012_v.nextFloat();
            double var15 = (double)this.field_145849_e - 0.25 + 1.5 * (double)this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_72869_a("reddust", var11, var3, var15, 0.0, 0.0, 0.0);
            this.field_145850_b.func_72869_a("crit", var1, var3, var5, -0.3 + 0.6 * (double)this.field_145850_b.field_73012_v.nextFloat(), 0.4 * (double)this.field_145850_b.field_73012_v.nextFloat(), -0.3 + 0.6 * (double)this.field_145850_b.field_73012_v.nextFloat());
        }
    }

    private void applyToSpawner(World world, int x, int y, int z) {
        this.control = new SpawnerControl(this.getAdjacentTileEntity(ForgeDirection.DOWN));
        if (this.disable || world.func_72864_z(x, y - 1, z)) {
            this.shutdownSpawner(world, x, y, z);
        } else if (this.canSpawn(world, x, y, z)) {
            this.timer.update();
            this.control.setDelay(this.setDelay - this.timer.getTick());
            this.timer.checkCap();
        }
        if (this.control.getDelay() <= 0) {
            this.control.spawnCycle(this);
        }
    }

    private int getNumberNearbySpawns(World world, int x, int y, int z, Class ent) {
        return world.func_72872_a(ent, ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(16.0, 24.0, 16.0)).size();
    }

    private boolean canSpawn(World world, int x, int y, int z) {
        Class ent = this.getEntityClass();
        int num = this.getNumberNearbySpawns(world, x, y, z, ent);
        return num < this.getSpawnLimit();
    }

    private Class getEntityClass() {
        return this.control.getEntity();
    }

    private int getSpawnLimit() {
        return 99;
    }

    public boolean isValidLocation(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        return b == Blocks.field_150474_ac || this.getAdjacentTileEntity(ForgeDirection.DOWN) instanceof ControllableSpawner;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("setdelay", this.setDelay);
        NBT.func_74757_a("disable", this.disable);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.setDelay(NBT.func_74762_e("setdelay"));
        this.disable = NBT.func_74767_n("disable");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SPAWNERCONTROLLER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean areConditionsMet() {
        return this.isValidLocation(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Spawner";
    }

    private static void flagNoDespawn(Entity e) {
        NBTTagCompound tag = e.getEntityData();
        tag.func_74757_a(CONTROLLED_SPAWN_TAG, true);
    }

    public static boolean isFlaggedNoDespawn(Entity e) {
        return e.getEntityData().func_74767_n(CONTROLLED_SPAWN_TAG);
    }

    private static void runVanillaSpawnCycle(TileEntityMobSpawner tile, TileEntitySpawnerController c) {
        World world = tile.field_145850_b;
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        MobSpawnerBaseLogic lgc = tile.func_145881_a();
        lgc.field_98292_k = Short.MAX_VALUE;
        lgc.field_98289_l = Short.MAX_VALUE;
        if (world.field_72995_K) {
            double var1 = (float)x + world.field_73012_v.nextFloat();
            double var3 = (float)y + world.field_73012_v.nextFloat();
            double var5 = (float)z + world.field_73012_v.nextFloat();
            world.func_72869_a("smoke", var1, var3, var5, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", var1, var3, var5, 0.0, 0.0, 0.0);
            lgc.field_98284_d = lgc.field_98287_c;
            lgc.field_98287_c = (lgc.field_98287_c + 1000.0 / (double)(lgc.field_98286_b + 200)) % 360.0;
        } else {
            for (int i = 0; i < lgc.field_98294_i; ++i) {
                Entity toSpawn = EntityList.func_75620_a((String)lgc.func_98276_e(), (World)world);
                if (toSpawn == null) continue;
                double ex = (double)x + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)lgc.field_98290_m;
                double ey = y + world.field_73012_v.nextInt(3) - 1;
                double ez = (double)z + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)lgc.field_98290_m;
                EntityLiving livingSpawn = toSpawn instanceof EntityLiving ? (EntityLiving)toSpawn : null;
                toSpawn.func_70012_b(ex, ey, ez, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (livingSpawn != null && !livingSpawn.func_70601_bi()) continue;
                lgc.func_98265_a(toSpawn);
                TileEntitySpawnerController.flagNoDespawn(toSpawn);
                world.func_72926_e(2004, x, y, z, 0);
                if (livingSpawn == null) continue;
                livingSpawn.func_70656_aK();
            }
        }
    }

    private static class SpawnerControl {
        private final TileEntityMobSpawner tile;
        private final ControllableSpawner proxy;
        private final boolean vanilla;

        private SpawnerControl(TileEntity te) {
            this.vanilla = te instanceof TileEntityMobSpawner;
            this.tile = this.vanilla ? (TileEntityMobSpawner)te : null;
            this.proxy = this.vanilla ? null : (ControllableSpawner)te;
        }

        private void setInactive() {
            if (this.vanilla) {
                this.tile.func_145881_a().field_98286_b = 5;
            } else {
                this.proxy.setInactive();
            }
        }

        private int getDelay() {
            return this.vanilla ? this.tile.func_145881_a().field_98286_b : this.proxy.getCurrentSpawnDelay();
        }

        private void setDelay(int t) {
            if (this.vanilla) {
                this.tile.func_145881_a().field_98286_b = t;
            } else {
                this.proxy.setCurrentSpawnDelay(t);
            }
        }

        private void spawnCycle(TileEntitySpawnerController te) {
            if (this.vanilla) {
                TileEntitySpawnerController.runVanillaSpawnCycle(this.tile, te);
            } else {
                Collection<Entity> c = this.proxy.performSpawnCycle();
                for (Entity e : c) {
                    TileEntitySpawnerController.flagNoDespawn(e);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new SpawnerControllerSpawnEvent((TileEntity)te, this.getEntity()));
        }

        private Class<? extends EntityLiving> getEntity() {
            return this.vanilla ? (Class)EntityList.field_75625_b.get(this.tile.func_145881_a().func_98276_e()) : this.proxy.getSpawningEntityClass();
        }
    }
}

