/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Piping;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityHose
extends TileEntityPiping
implements PumpablePipe {
    private int lubricant = 0;
    private int burnIn = 0;

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.burnIn > 0) {
            --this.burnIn;
            if (this.burnIn == 0) {
                this.doBurn();
            }
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.HOSE;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m, ForgeDirection dir) {
        return m == MachineRegistry.HOSE || m == MachineRegistry.VALVE || m == MachineRegistry.SEPARATION || m == MachineRegistry.SUCTION;
    }

    @Override
    public IIcon getBlockIcon() {
        return Blocks.field_150344_f.func_149691_a(0, 0);
    }

    @Override
    public boolean hasLiquid() {
        return this.lubricant > 0;
    }

    @Override
    public Fluid getFluidType() {
        return this.hasLiquid() ? FluidRegistry.getFluid((String)"rc lubricant") : null;
    }

    @Override
    public int getFluidLevel() {
        return this.lubricant;
    }

    @Override
    protected void setFluid(Fluid f) {
    }

    @Override
    protected void setLevel(int amt) {
        this.lubricant = amt;
    }

    @Override
    protected boolean interactsWithMachines() {
        return true;
    }

    @Override
    protected void onIntake(TileEntity te) {
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return f.equals(FluidRegistry.getFluid((String)"rc lubricant"));
    }

    @Override
    public boolean canReceiveFromPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean canEmitToPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public Block getPipeBlockType() {
        return Blocks.field_150344_f;
    }

    @Override
    public boolean canIntakeFromIFluidHandler(ForgeDirection side) {
        return side.offsetY != 0;
    }

    @Override
    public boolean canOutputToIFluidHandler(ForgeDirection side) {
        return side.offsetY == 0;
    }

    public void burn() {
        this.burn(true);
    }

    private void burn(boolean immediate) {
        ReikaWorldHelper.ignite((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (immediate) {
            this.doBurn();
        } else {
            int time;
            int n = time = this.hasLiquid() ? 5 + rand.nextInt(15) : 10 + rand.nextInt(30);
            if (this.burnIn <= 0) {
                this.burnIn = time;
            }
        }
    }

    private void doBurn() {
        for (int i = 0; i < 6; ++i) {
            TileEntity te;
            if (rand.nextInt(3) <= 0 || !((te = this.getAdjacentTileEntity(this.dirs[i])) instanceof TileEntityHose)) continue;
            ((TileEntityHose)te).burn(false);
        }
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
        if (this.hasLiquid() && rand.nextInt(4) == 0) {
            this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 2.0f, true, false);
        }
    }
}

