/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.FrictionHeatable;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.PressureTE;
import Reika.RotaryCraft.Auxiliary.Interfaces.ProcessingMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCompactor;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCompactor
extends InventoriedPowerReceiver
implements TemperatureTE,
PressureTE,
FrictionHeatable,
MultiOperational,
ProcessingMachine {
    public int compactorCookTime;
    public static final int MAXTEMP = 1000;
    public static final int MAXPRESSURE = 600000;
    public static final int REQTEMP = 800;
    public static final int REQPRESS = 550000;
    private int pressure;
    public int temperature;
    public boolean idle = false;
    private boolean animdir = false;
    private int envirotick = 0;
    private int tempTick;

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 4;
    }

    public void testIdle() {
        boolean ingred = false;
        boolean invalid = false;
        for (int i = 0; i < 4; ++i) {
            if (this.inv[i] != null) continue;
            invalid = true;
        }
        if (!invalid) {
            Item id = this.inv[0].func_77973_b();
            int dmg = this.inv[0].func_77960_j();
            for (int i = 1; i < 4; ++i) {
                if (this.inv[i].func_77973_b() == id && this.inv[i].func_77960_j() == dmg) continue;
                invalid = true;
            }
        }
        if (!invalid && RecipesCompactor.getRecipes().isCompactable(this.inv[0])) {
            ingred = true;
        }
        boolean full = true;
        if (this.inv[4] == null) {
            full = false;
        } else if (this.inv[4].field_77994_a < this.inv[4].func_77976_d()) {
            full = false;
        }
        this.idle = !ingred || full;
    }

    public boolean getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
            }
        }
        return true;
    }

    public void readPower() {
        if (!this.getIOSides(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p())) {
            return;
        }
        super.getPower(false);
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.compactorCookTime = NBT.func_74765_d("CookTime");
        this.temperature = NBT.func_74762_e("temperature");
        this.pressure = NBT.func_74762_e("pressure");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74777_a("CookTime", (short)this.compactorCookTime);
        NBT.func_74768_a("temperature", this.temperature);
        NBT.func_74768_a("pressure", this.pressure);
    }

    public int getCookProgressScaled(int par1) {
        int time = this.getOperationTime();
        return time > 0 ? this.compactorCookTime * par1 / time : 0;
    }

    public int getPressureScaled(int par1) {
        return this.pressure * par1 / 600000;
    }

    public int getTemperatureScaled(int par1) {
        return this.temperature * par1 / 1000;
    }

    public int compressTime() {
        ItemStack is1 = this.inv[0];
        ItemStack is2 = this.inv[1];
        ItemStack is3 = this.inv[2];
        ItemStack is4 = this.inv[3];
        if (is1 == null || is2 == null || is3 == null || is4 == null) {
            return -1;
        }
        Item item = is1.func_77973_b();
        int meta = is1.func_77960_j();
        if (item != ItemRegistry.COMPACTS.getItemInstance() && item != Items.field_151044_h) {
            return -1;
        }
        if (item == Items.field_151044_h) {
            return 80;
        }
        switch (meta) {
            case 0: {
                return 160;
            }
            case 1: {
                return 320;
            }
            case 2: {
                return 640;
            }
        }
        return -1;
    }

    @Override
    public void updatePressure(World world, int x, int y, int z, int meta) {
        int Pamb = (int)ReikaWorldHelper.getAmbientPressureAt((World)world, (int)x, (int)y, (int)z, (boolean)true);
        if (this.pressure > Pamb && world.func_72807_a(x, z) != BiomeGenBase.field_76778_j) {
            this.pressure -= Math.max((this.pressure - Pamb) / 200, 1);
        }
        if (this.pressure > Pamb && world.func_72807_a(x, z) == BiomeGenBase.field_76778_j) {
            this.pressure -= Math.max((this.pressure - Pamb) / 600, 1);
        }
        if (this.pressure < Pamb) {
            this.pressure += Math.max((Pamb - this.pressure) / 40, 1);
        }
        if (this.omega > 0) {
            this.pressure = (int)((double)this.pressure + 128.0 * ReikaMathLibrary.logbase((long)this.torque, (int)2));
        }
        if ((double)this.pressure >= 480000.0) {
            RotaryCraft.logger.warn((Object)("WARNING: " + this + " is reaching very high pressure!"));
        }
        if (this.pressure > 600000) {
            this.overpressure(world, x, y, z);
        }
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection snowside;
        ForgeDirection iceside;
        ForgeDirection a;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.temperature > Tamb) {
            this.temperature -= Math.max((this.temperature - Tamb) / 200, 1);
        }
        if (this.temperature < Tamb) {
            this.temperature += Math.max((Tamb - this.temperature) / 40, 1);
        }
        if (RotaryAux.isNextToLava(world, x, y, z)) {
            this.temperature += 4;
        }
        if (RotaryAux.isNextToFire(world, x, y, z)) {
            this.temperature += 2;
        }
        if (Tamb == 300) {
            ++this.temperature;
        }
        if ((a = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h)) != null && this.temperature > 600) {
            --this.temperature;
            if (rand.nextInt(4000) == 0) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)a, (Block)Blocks.field_150350_a, (int)0);
            }
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null && this.temperature > 0) {
            this.temperature -= 2;
            if (rand.nextInt(200) == 0) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
            }
        }
        if ((snowside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE)) != null && this.temperature > -5) {
            this.temperature -= 2;
            if (rand.nextInt(100) == 0) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
            }
        }
        ReikaWorldHelper.temperatureEnvironment((World)world, (int)x, (int)y, (int)z, (int)this.temperature);
        if ((double)this.temperature >= 900.0) {
            RotaryCraft.logger.warn((Object)("WARNING: " + this + " is reaching very high temperature!"));
        }
        if (this.temperature > 1000) {
            this.overheat(world, x, y, z);
            this.temperature = 1000;
        }
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        this.temperature = 1000;
        ReikaWorldHelper.overheat((World)world, (int)x, (int)y, (int)z, (ItemStack)ItemStacks.scrap, (int)0, (int)17, (boolean)true, (float)1.0f, (boolean)false, (boolean)ConfigRegistry.BLOCKDAMAGE.getState(), (float)2.0f);
        world.func_147468_f(x, y, z);
    }

    public int getStage() {
        if (this.inv[0] == null) {
            return 1;
        }
        if (!RecipesCompactor.getRecipes().isCompactable(this.inv[0])) {
            return 1;
        }
        if (this.inv[0].func_77973_b() == Items.field_151044_h) {
            return 1;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)ItemStacks.anthracite, (ItemStack)this.inv[0])) {
            return 2;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)ItemStacks.prismane, (ItemStack)this.inv[0])) {
            return 3;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)ItemStacks.lonsda, (ItemStack)this.inv[0])) {
            return 4;
        }
        return 1;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.envirotick >= 20) {
            this.updatePressure(world, x, y, z, meta);
            if (this.tempTick == 0) {
                this.updateTemperature(world, x, y, z, meta);
            }
            this.envirotick = 0;
        }
        this.testIdle();
        boolean flag1 = false;
        ++this.envirotick;
        if (this.tempTick > 0) {
            --this.tempTick;
        }
        ++this.tickcount;
        if (!world.field_72995_K) {
            int n = this.getNumberConsecutiveOperations();
            for (int i = 0; i < n; ++i) {
                flag1 |= this.doOperation(n > 1);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean doOperation(boolean multiple) {
        if (this.canSmelt()) {
            ++this.compactorCookTime;
            if (this.compactorCookTime >= this.getOperationTime()) {
                this.compactorCookTime = 0;
                this.smeltItem();
            }
            return true;
        }
        this.compactorCookTime = 0;
        return false;
    }

    private boolean canSmelt() {
        this.readPower();
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.inv[i] != null) continue;
            return false;
        }
        if (this.inv[0].func_77973_b() != this.inv[1].func_77973_b()) {
            return false;
        }
        if (this.inv[0].func_77973_b() != this.inv[2].func_77973_b()) {
            return false;
        }
        if (this.inv[0].func_77973_b() != this.inv[3].func_77973_b()) {
            return false;
        }
        if (this.inv[0].func_77960_j() != this.inv[1].func_77960_j()) {
            return false;
        }
        if (this.inv[0].func_77960_j() != this.inv[2].func_77960_j()) {
            return false;
        }
        if (this.inv[0].func_77960_j() != this.inv[3].func_77960_j()) {
            return false;
        }
        if (this.pressure < RecipesCompactor.getRecipes().getReqPressure(this.inv[0]) || this.temperature < RecipesCompactor.getRecipes().getReqTemperature(this.inv[0])) {
            return false;
        }
        ItemStack itemstack = RecipesCompactor.getRecipes().getCompactingResult(this.inv[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inv[4] != null) {
            if (!this.inv[4].func_77969_a(itemstack)) {
                return false;
            }
            if (this.inv[4].field_77994_a >= itemstack.func_77976_d()) {
                return false;
            }
        }
        if (this.inv[4] == null) {
            return true;
        }
        return this.inv[4].field_77994_a < this.func_70297_j_() && this.inv[4].field_77994_a < this.inv[4].func_77976_d();
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = RecipesCompactor.getRecipes().getCompactingResult(this.inv[0]);
        if (this.inv[4] == null) {
            this.inv[4] = itemstack.func_77946_l();
        } else if (this.inv[4].func_77973_b() == itemstack.func_77973_b()) {
            this.inv[4].field_77994_a += itemstack.field_77994_a;
        }
        for (int i = 0; i < 4; ++i) {
            --this.inv[i].field_77994_a;
            if (this.inv[i].field_77994_a > 0) continue;
            this.inv[i] = null;
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.phi < 0.5f) {
            this.phi = 1.0f;
        }
        if (!this.isInWorld()) {
            return;
        }
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        if ((this.phi >= 1.5f || this.phi <= 0.5f) && rand.nextInt(40) > 0) {
            return;
        }
        this.phi = this.animdir ? (this.phi += 0.03125f) : (this.phi -= 0.03125f);
        if (this.phi >= 1.5f || this.phi <= 0.5f) {
            this.animdir = !this.animdir;
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.COMPACTOR;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot == 4) {
            return false;
        }
        if (is.func_77973_b() == Items.field_151044_h || ItemRegistry.COMPACTS.matchItem(is) && is.func_77960_j() <= ItemStacks.lonsda.func_77960_j()) {
            return true;
        }
        return RecipesCompactor.getRecipes().isCompactable(is);
    }

    @Override
    public int getThermalDamage() {
        return this.temperature / 100;
    }

    public int getRedstoneOverride() {
        if (!this.canSmelt()) {
            return 15;
        }
        return 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void addPressure(int press) {
        this.pressure += press;
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void overpressure(World world, int x, int y, int z) {
        world.func_72876_a(null, (double)x, (double)y, (double)z, 4.0f, ConfigRegistry.BLOCKDAMAGE.getState());
        this.pressure = 600000;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.COMPACTOR.getOperationTime(this.omega, this.getStage() - 1);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.COMPACTOR.getNumberOperations(this.omega, this.getStage() - 1);
    }

    @Override
    public boolean areConditionsMet() {
        return this.canSmelt();
    }

    @Override
    public String getOperationalStatus() {
        if (this.inv[0] == null) {
            return "Missing Items";
        }
        if (this.temperature < RecipesCompactor.getRecipes().getReqTemperature(this.inv[0])) {
            return "Insufficient Temperature";
        }
        if (this.pressure < RecipesCompactor.getRecipes().getReqPressure(this.inv[0])) {
            return "Insufficient Pressure";
        }
        return this.areConditionsMet() ? "Operational" : "Invalid or Missing Items";
    }

    @Override
    public void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public int getMaxPressure() {
        return 600000;
    }

    @Override
    public void resetAmbientTemperatureTimer() {
        this.tempTick = 5;
    }

    @Override
    public float getMultiplier() {
        return 0.75f;
    }

    @Override
    public void onOverheat(World world, int x, int y, int z) {
    }

    @Override
    public boolean canBeFrictionHeated() {
        return true;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }

    @Override
    public boolean allowHeatExtraction() {
        return false;
    }

    public boolean hasWork() {
        return this.areConditionsMet();
    }
}

