/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicCropHandler;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.CustomExtractLoader;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.HiddenInventorySlot;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesExtractor;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.ModInterface.ItemCustomModOre;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.ExtractorBonus;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@APIStripper.Strippable(value={"buildcraft.api.tiles.IHasWork"})
public class TileEntityExtractor
extends InventoriedPowerLiquidReceiver
implements ConditionalOperation,
HiddenInventorySlot,
IHasWork {
    public static final int oreCopy = 50;
    public static final int oreCopyNether = 80;
    public static final int oreCopyRare = 90;
    private int[] extractorCookTime = new int[4];
    public static final int DRILL_LIFE = 4096;
    private int drillTime = ConfigRegistry.EXTRACTORMAINTAIN.getState() ? 0 : 4096;
    private boolean bedrock = false;
    public static final int CAPACITY = 16000;
    public boolean idle = false;

    public boolean upgrade() {
        if (this.bedrock) {
            return false;
        }
        this.bedrock = true;
        if (this.inv[9] != null) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.inv[9]);
        }
        this.inv[9] = ItemStacks.bedrockdrill.func_77946_l();
        return true;
    }

    public boolean isBedrock() {
        return this.bedrock;
    }

    public int getCookTime(int stage) {
        return this.extractorCookTime[stage];
    }

    @SideOnly(value=Side.CLIENT)
    public void setCookTime(int stage, int time) {
        this.extractorCookTime[stage] = time;
    }

    public void testIdle() {
        boolean works = false;
        for (int i = 0; i < 4; ++i) {
            if (!this.canProcess(i)) continue;
            works = true;
        }
        this.idle = !works;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 7 || i == 8;
    }

    @Override
    public boolean validatesInputs() {
        return true;
    }

    private int getSmeltNumber(int stage, OreType ore, ItemStack is) {
        if (this.bedrock && stage == 0) {
            return 2;
        }
        if (ore != null) {
            boolean nether;
            if (ore.getRarity() == OreType.OreRarity.RARE) {
                if (ReikaRandomHelper.doWithChance((double)0.9)) {
                    return 2;
                }
                return 1;
            }
            boolean bl = nether = ore instanceof ModOreList && ((ModOreList)ore).isNetherOres();
            if (is.func_77960_j() == 1 && (ore == ModOreList.FORCE || ore == ModOreList.MIMICHITE)) {
                nether = true;
            }
            if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)MagicCropHandler.getInstance().netherOreID)) {
                nether = true;
            }
            if (nether) {
                if (ReikaRandomHelper.doWithChance((double)0.8)) {
                    return 2;
                }
                return 1;
            }
        }
        return ReikaRandomHelper.doWithChance((double)0.5) ? 2 : 1;
    }

    private void throughPut() {
        for (int i = 1; i < 4; ++i) {
            if (this.inv[i + 3] == null) continue;
            if (this.inv[i] == null) {
                this.inv[i] = this.inv[i + 3];
                this.inv[i + 3] = null;
                continue;
            }
            if (this.inv[i].field_77994_a >= this.inv[i].func_77976_d() || !ReikaItemHelper.matchStacks((ItemStack)this.inv[i], (ItemStack)this.inv[i + 3])) continue;
            int amt = Math.min(this.inv[i + 3].field_77994_a, this.inv[i].func_77976_d() - this.inv[i].field_77994_a);
            if ((amt = Math.min(amt, this.getNumberConsecutiveOperations(i))) <= 0) continue;
            this.inv[i].field_77994_a += amt;
            ReikaInventoryHelper.decrStack((int)(i + 3), (ItemStack[])this.inv, (int)amt);
        }
    }

    public int func_70302_i_() {
        return 10;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.extractorCookTime = NBT.func_74759_k("CookTime");
        this.drillTime = NBT.func_74762_e("drill");
        this.bedrock = NBT.func_74767_n("bedrock");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74783_a("CookTime", this.extractorCookTime);
        NBT.func_74768_a("drill", this.drillTime);
        NBT.func_74757_a("bedrock", this.bedrock);
    }

    public int getCookProgressScaled(int par1, int i) {
        int j = i + 1;
        int time = -1;
        switch (j) {
            case 1: {
                time = 30 * (30 - (int)(2.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2)));
                break;
            }
            case 2: {
                time = (800 - (int)(40.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2))) / 2;
                break;
            }
            case 3: {
                time = 600 - (int)(30.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2));
                break;
            }
            case 4: {
                time = 1200 - (int)(80.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2));
            }
        }
        if (time == -1) {
            return 0;
        }
        if (time <= 0) {
            time = 1;
        }
        return this.extractorCookTime[i] * par1 / 2 / time;
    }

    public int getDrillLifeScaled(int a) {
        return this.bedrock ? a : this.drillTime * a / 4096;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        if (DragonAPICore.debugtest) {
            this.tank.addLiquid(1000, FluidRegistry.WATER);
        }
        this.testIdle();
        if (world.field_72995_K) {
            return;
        }
        this.throughPut();
        if (!this.bedrock) {
            if (ConfigRegistry.EXTRACTORMAINTAIN.getState()) {
                if (this.drillTime <= 0 && this.inv[9] != null && ReikaItemHelper.matchStacks((ItemStack)this.inv[9], (ItemStack)ItemStacks.drill)) {
                    ReikaInventoryHelper.decrStack((int)9, (ItemStack[])this.inv);
                    this.drillTime = 4096;
                }
            } else {
                this.drillTime = 4096;
                this.inv[9] = null;
            }
        }
        boolean[] tickPer = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            boolean flag1 = false;
            int n = this.getNumberConsecutiveOperations(i);
            for (int k = 0; k < n; ++k) {
                flag1 |= this.doOperation(n > 1, i, tickPer);
            }
            if (!flag1) continue;
            this.func_70296_d();
        }
        if (ReikaArrayHelper.isAllTrue((boolean[])tickPer)) {
            RotaryAchievements.INSANITY.triggerAchievement(this.getPlacer());
        }
    }

    private boolean doOperation(boolean multiple, int i, boolean[] tickPer) {
        if (this.canProcess(i)) {
            int n = i;
            this.extractorCookTime[n] = this.extractorCookTime[n] + 1;
            int time = this.getOperationTime(i);
            if (time <= 1) {
                tickPer[i] = true;
            }
            if (this.extractorCookTime[i] >= time) {
                this.extractorCookTime[i] = 0;
                this.processItem(i);
            }
            return true;
        }
        this.extractorCookTime[i] = 0;
        return false;
    }

    private boolean canProcess(int i) {
        OreType ore;
        if (this.power < this.machine.getMinPower(i) || this.omega < this.machine.getMinSpeed(i) || this.torque < this.machine.getMinTorque(i)) {
            return false;
        }
        if (i == 0 && !this.bedrock && this.drillTime <= 0 && ConfigRegistry.EXTRACTORMAINTAIN.getState()) {
            return false;
        }
        if ((i == 1 || i == 2) && this.tank.isEmpty()) {
            return false;
        }
        if (this.inv[i] == null) {
            return false;
        }
        if (this.inv[i + 4] != null && this.inv[i + 4].field_77994_a + 1 >= this.inv[i + 4].func_77976_d()) {
            return false;
        }
        if (this.inv[8] != null) {
            ItemStack out;
            ExtractorBonus bonus;
            if (this.inv[8].field_77994_a + 1 > this.inv[8].func_77976_d()) {
                return false;
            }
            if (this.inv[3] != null && (bonus = ExtractorBonus.getBonusForIngredient(this.inv[3])) != null && !ReikaItemHelper.matchStacks((ItemStack)(out = bonus.getBonusItem()), (ItemStack)this.inv[8])) {
                return false;
            }
        }
        if ((ore = this.getOreType(this.inv[i])) == null) {
            return false;
        }
        ItemStack itemstack = RecipesExtractor.getRecipes().getExtractionResult(this.inv[i]);
        if (itemstack == null) {
            return false;
        }
        if (this.inv[i + 4] == null) {
            return true;
        }
        if (!this.inv[i + 4].func_77969_a(itemstack)) {
            return false;
        }
        if (this.inv[i + 4].field_77994_a < this.func_70297_j_() && this.inv[i + 4].field_77994_a < this.inv[i + 4].func_77976_d()) {
            return true;
        }
        return this.inv[i + 4].field_77994_a < itemstack.func_77976_d();
    }

    private void processItem(int i) {
        ItemStack itemstack = RecipesExtractor.getRecipes().getExtractionResult(this.inv[i]);
        OreType ore = this.getOreType(this.inv[i]);
        int num = this.getSmeltNumber(i, ore, this.inv[i]);
        if (this.inv[i + 4] == null) {
            this.inv[i + 4] = itemstack.func_77946_l();
            this.inv[i + 4].field_77994_a *= num;
        } else if (ReikaItemHelper.matchStacks((ItemStack)this.inv[i + 4], (ItemStack)itemstack)) {
            this.inv[i + 4].field_77994_a += num;
        }
        if (i == 0 && !this.bedrock && this.drillTime > 0 && ConfigRegistry.EXTRACTORMAINTAIN.getState()) {
            --this.drillTime;
        }
        if (i == 3) {
            this.bonusItems(this.inv[i]);
            RotaryAchievements.EXTRACTOR.triggerAchievement(this.getPlacer());
            if (ore.getRarity() == OreType.OreRarity.RARE) {
                RotaryAchievements.RAREEXTRACT.triggerAchievement(this.getPlacer());
            }
        }
        --this.inv[i].field_77994_a;
        if (i == 1 || i == 2) {
            this.tank.removeLiquid(125);
        }
        if (this.inv[i].field_77994_a <= 0) {
            this.inv[i] = null;
        }
    }

    private OreType getOreType(ItemStack is) {
        if (is.func_77973_b() == ItemRegistry.EXTRACTS.getItemInstance()) {
            return ReikaOreHelper.oreList[is.func_77960_j() % ReikaOreHelper.oreList.length];
        }
        if (is.func_77973_b() == ItemRegistry.MODEXTRACTS.getItemInstance()) {
            return ExtractorModOres.getOreFromExtract(is);
        }
        if (is.func_77973_b() == ItemRegistry.CUSTOMEXTRACT.getItemInstance()) {
            return ItemCustomModOre.getExtractType(is);
        }
        Object ore = ReikaOreHelper.getFromVanillaOre((ItemStack)is);
        if (ore != null) {
            return ore;
        }
        ore = ReikaOreHelper.getEntryByOreDict((ItemStack)is);
        if (ore != null) {
            return ore;
        }
        ore = ModOreList.getModOreFromOre((ItemStack)is);
        if (ore != null) {
            return ore;
        }
        ore = CustomExtractLoader.instance.getEntryFromOreBlock(is);
        if (ore != null) {
            return ore;
        }
        return null;
    }

    private void bonusItems(ItemStack is) {
        ExtractorBonus e = ExtractorBonus.getBonusForIngredient(is);
        if (e != null && e.doBonus()) {
            ReikaInventoryHelper.addOrSetStack((ItemStack)e.getBonusItem(), (ItemStack[])this.inv, (int)8);
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.EXTRACTOR;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot > 3 && slot < 9) {
            return false;
        }
        if (slot == 0) {
            return ReikaBlockHelper.isOre((ItemStack)is) || CustomExtractLoader.instance.getEntryFromOreBlock(is) != null;
        }
        if (ItemRegistry.EXTRACTS.matchItem(is)) {
            return slot == 1 + is.func_77960_j() / 8;
        }
        if (ItemRegistry.MODEXTRACTS.matchItem(is)) {
            return slot == 1 + is.func_77960_j() % 4;
        }
        if (ItemRegistry.CUSTOMEXTRACT.matchItem(is)) {
            return slot == 1 + is.func_77960_j() % 4;
        }
        if (slot == 9) {
            return !this.bedrock && ConfigRegistry.EXTRACTORMAINTAIN.getState() && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.drill);
        }
        return false;
    }

    public int getRedstoneOverride() {
        int bits = 15;
        for (int i = 0; i < 4; ++i) {
            if (!this.canProcess(i)) continue;
            bits &= ~(1 << i);
        }
        return bits;
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.WATER;
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection dir) {
        return dir.offsetY == 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public int getOperationTime(int stage) {
        return DurationRegistry.EXTRACTOR.getOperationTime(this.omega, stage);
    }

    public int getNumberConsecutiveOperations(int stage) {
        return DurationRegistry.EXTRACTOR.getNumberOperations(this.omega, stage);
    }

    @Override
    public boolean areConditionsMet() {
        return !this.tank.isEmpty() && !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv, (int)0, (int)4);
    }

    @Override
    public String getOperationalStatus() {
        return this.tank.isEmpty() ? "No Water" : (this.areConditionsMet() ? "Operational" : "No Items");
    }

    @Override
    public boolean isSlotHidden(int slot) {
        return slot == 9;
    }

    @Override
    public int[] getHiddenSlots() {
        return new int[]{9};
    }

    public boolean hasWork() {
        return this.areConditionsMet();
    }
}

