/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.ProcessingMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.MulchMaterials;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityFermenter
extends InventoriedPowerLiquidReceiver
implements TemperatureTE,
MultiOperational,
ProcessingMachine {
    public int fermenterCookTime = 0;
    public static final int MINUSEFULTEMP = 20;
    public static final int OPTMULTIPLYTEMP = 25;
    public static final int MAXUSEFULTEMP = 40;
    public static final int OPTFERMENTTEMP = 35;
    public static final int MAXTEMP = 60;
    public static final int CAPACITY = 4000;
    public static final int CONSUME_WATER = 50;
    public int temperature;
    public boolean idle = false;
    private int temperaturetick = 0;

    @Override
    protected int getActiveTexture() {
        return this.power >= this.MINPOWER && this.omega >= this.MINSPEED && this.canMake() ? 1 : 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 2;
    }

    private ItemStack getRecipe() {
        for (int i = 0; i < 2; ++i) {
            if (this.inv[i] != null) continue;
            return null;
        }
        if (this.inv[0].func_77973_b() == Items.field_151102_aT && this.hasWater() && ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[1], (Block)Blocks.field_150346_d)) {
            return !ConfigRegistry.enableFermenterYeast() ? null : new ItemStack(ItemRegistry.YEAST.getItemInstance(), 1, 0);
        }
        if (this.inv[0].func_77973_b() == ItemRegistry.YEAST.getItemInstance() && MulchMaterials.instance.isMulchable(this.inv[1]) && this.hasWater()) {
            return ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.sludge, (int)MulchMaterials.instance.getPlantValue(this.inv[1]));
        }
        return null;
    }

    private boolean hasWater() {
        return !this.tank.isEmpty();
    }

    private float getFermentRate() {
        boolean fermenting = true;
        if (this.getRecipe() == null) {
            return -1.0f;
        }
        if (this.getRecipe().func_77973_b() == ItemRegistry.YEAST.getItemInstance()) {
            fermenting = false;
        }
        if (this.temperature < 20) {
            return 1.0f / (float)(20 - this.temperature);
        }
        if (this.temperature > 40) {
            return 1.0f / (float)(this.temperature - 40);
        }
        float Tdiff = this.temperature - 25;
        if (fermenting) {
            Tdiff = this.temperature - 35;
        }
        if (Tdiff < 0.0f) {
            Tdiff = -Tdiff;
        }
        return (float)Math.pow(1.0f - Tdiff / 16.0f, 0.2);
    }

    public void testIdle() {
        this.idle = this.getRecipe() == null;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.temperaturetick;
        ++this.tickcount;
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        if (this.temperaturetick >= 20) {
            this.temperaturetick = 0;
            this.updateTemperature(world, x, y, z, meta);
        }
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            return;
        }
        int n = this.getNumberConsecutiveOperations();
        for (int i = 0; i < n; ++i) {
            this.doOperation(n > 1);
        }
    }

    private void doOperation(boolean multiple) {
        ItemStack product = this.getRecipe();
        if (this.tickcount >= 2 + rand.nextInt(18)) {
            this.testYeastKill();
            this.tickcount = 0;
        }
        if (product == null) {
            this.idle = true;
            this.fermenterCookTime = 0;
            return;
        }
        if (product.func_77973_b() != ItemRegistry.YEAST.getItemInstance() && !ReikaItemHelper.matchStacks((ItemStack)product, (ItemStack)ItemStacks.sludge)) {
            return;
        }
        if (this.inv[2] != null && product.func_77973_b() != this.inv[2].func_77973_b()) {
            this.fermenterCookTime = 0;
            return;
        }
        this.idle = false;
        if (this.inv[2] != null && this.inv[2].field_77994_a + product.field_77994_a > this.inv[2].func_77976_d()) {
            this.fermenterCookTime = 0;
            return;
        }
        ++this.fermenterCookTime;
        if (multiple || this.fermenterCookTime >= this.getOperationTime()) {
            this.make(product);
            this.fermenterCookTime = 0;
        }
    }

    private boolean canMake() {
        ItemStack product = this.getRecipe();
        if (product == null) {
            return false;
        }
        if (product.func_77973_b() != ItemRegistry.YEAST.getItemInstance() && !ReikaItemHelper.matchStacks((ItemStack)product, (ItemStack)ItemStacks.sludge)) {
            return false;
        }
        if (this.inv[2] != null) {
            if (product.func_77973_b() != this.inv[2].func_77973_b()) {
                return false;
            }
            if (this.inv[2].field_77994_a + product.field_77994_a > this.inv[2].func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void make(ItemStack product) {
        if (product.func_77973_b() == ItemRegistry.YEAST.getItemInstance()) {
            if (this.inv[2] == null) {
                this.inv[2] = new ItemStack(ItemRegistry.YEAST.getItemInstance(), 1, 0);
            } else if (this.inv[2].func_77973_b() == ItemRegistry.YEAST.getItemInstance()) {
                if (this.inv[2].field_77994_a >= this.inv[2].func_77976_d()) return;
                ++this.inv[2].field_77994_a;
            } else {
                this.fermenterCookTime = 0;
                return;
            }
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            if (rand.nextInt(4) == 0) {
                ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
            }
        }
        if (ReikaItemHelper.matchStacks((ItemStack)product, (ItemStack)ItemStacks.sludge)) {
            if (this.inv[2] == null) {
                this.inv[2] = product.func_77946_l();
            } else if (ReikaItemHelper.matchStacks((ItemStack)this.inv[2], (ItemStack)ItemStacks.sludge)) {
                if (this.inv[2].field_77994_a >= this.inv[2].func_77976_d()) return;
                this.inv[2].field_77994_a += product.field_77994_a;
            } else {
                this.fermenterCookTime = 0;
                return;
            }
            ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
            if (rand.nextInt(2) == 0) {
                ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            }
        }
        this.func_70296_d();
        this.tank.removeLiquid(50);
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection lavaside;
        ForgeDirection fireside;
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        ForgeDirection waterside = ReikaWorldHelper.checkForAdjSourceBlock((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (waterside != null) {
            Tamb -= 5;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
            Tamb -= 15;
        }
        if ((fireside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab)) != null) {
            Tamb += 50;
        }
        if ((lavaside = ReikaWorldHelper.checkForAdjSourceBlock((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i)) != null) {
            Tamb += 200;
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 60) {
            this.temperature = 60;
        }
    }

    public void testYeastKill() {
        if (this.temperature < 60) {
            return;
        }
        int slot = ReikaInventoryHelper.locateInInventory((Item)ItemRegistry.YEAST.getItemInstance(), (ItemStack[])this.inv);
        if (slot != -1) {
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.fizz", 0.8f, 0.8f);
        }
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temperature");
        this.fermenterCookTime = NBT.func_74765_d("CookTime");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temperature", this.temperature);
        NBT.func_74777_a("CookTime", (short)this.fermenterCookTime);
    }

    public int getCookProgressScaled(int par1) {
        return this.fermenterCookTime * par1 / 2 / this.getOperationTime();
    }

    public int getTemperatureScaled(int par1) {
        return this.temperature * par1 / 60;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FERMENTER;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack is) {
        if (i >= 2) {
            return false;
        }
        if (this.hasRedstoneSignal() || !ConfigRegistry.enableFermenterYeast()) {
            switch (i) {
                case 0: {
                    return is.func_77973_b() == ItemRegistry.YEAST.getItemInstance();
                }
                case 1: {
                    return MulchMaterials.instance.isMulchable(is);
                }
            }
        } else {
            switch (i) {
                case 0: {
                    return is.func_77973_b() == Items.field_151102_aT;
                }
                case 1: {
                    return ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150346_d);
                }
            }
        }
        return false;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    public int getRedstoneOverride() {
        if (!this.canMake()) {
            return 15;
        }
        return 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return true;
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.WATER;
    }

    @Override
    public int getCapacity() {
        return 4000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    public void setLiquid(int amt) {
        this.tank.setContents(amt, FluidRegistry.WATER);
    }

    @Override
    public int getOperationTime() {
        int base = DurationRegistry.FERMENTER.getOperationTime(this.omega);
        return Math.max(1, (int)((float)base / this.getFermentRate()));
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return (int)Math.max(1.0f, this.getFermentRate() * (float)DurationRegistry.FERMENTER.getNumberOperations(this.omega));
    }

    @Override
    public boolean areConditionsMet() {
        return this.canMake();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Invalid or Missing Items";
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public boolean allowHeatExtraction() {
        return false;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public int getMaxTemperature() {
        return 60;
    }

    public boolean hasWork() {
        return this.areConditionsMet();
    }
}

