/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Storage;

import Reika.DragonAPI.Interfaces.TileEntity.MultiPageInventory;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Containers.Machine.Inventory.ContainerScaleChest;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityScaleableChest
extends InventoriedPowerReceiver
implements MultiPageInventory {
    public static final int FALLOFF = 128;
    public static final int MAXROWS = 6;
    public static final int MAXSIZE = 972;
    public static final int POWERCHANGEAGE = 20;
    private ArrayList<Integer> powerchanges = new ArrayList();
    private int numchanges;
    private boolean lastpower;
    private int resetTick = 0;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    public int page;

    public boolean dropsInventoryOnBroken() {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int func_70302_i_() {
        return 972;
    }

    public int getNumberSlots() {
        int size = this.power < this.MINPOWER ? 9 : 9 + (int)(this.power - this.MINPOWER) / 128;
        if (size >= this.inv.length) {
            size = this.inv.length;
        }
        return size;
    }

    public int getNumPowerChanges() {
        return this.numchanges;
    }

    public int getMaxPage() {
        int size = this.getNumberSlots();
        size = (int)((double)size / 9.0);
        return Math.min(this.getMaxPages(), (int)Math.ceil(size /= 6));
    }

    public int getNumberPages() {
        return this.getMaxPage();
    }

    public int getSlotsOnPage(int page) {
        int max = this.getMaxPage();
        if (page == max) {
            return this.getNumberSlots() - max * 9 * 6;
        }
        if (page < max) {
            return 54;
        }
        return 0;
    }

    public int getCurrentPage() {
        return this.page;
    }

    public static int getMaxPages() {
        int size = 972;
        size /= 9;
        return size /= 6;
    }

    private boolean testInconsistentPower() {
        int i;
        boolean pw;
        for (int i2 = 0; i2 < this.powerchanges.size(); ++i2) {
            int b = this.powerchanges.get(i2);
            this.powerchanges.set(i2, ++b);
        }
        Iterator<Integer> itr = this.powerchanges.iterator();
        while (itr.hasNext()) {
            int c = itr.next();
            if (c <= 20) continue;
            itr.remove();
        }
        boolean bl = pw = this.power >= this.MINPOWER;
        if (pw != this.lastpower) {
            int a = 0;
            this.powerchanges.add(a);
        }
        this.numchanges = this.powerchanges.size();
        this.lastpower = pw;
        if (this.numchanges > 10 && !this.field_145850_b.field_72995_K) {
            this.getTileEntityBlockID().func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getMachineIndex(), 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 4.0f, ConfigRegistry.BLOCKDAMAGE.getState());
        } else if (this.numchanges > 8) {
            for (i = 0; i < this.numchanges / 3; ++i) {
                this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + rand.nextFloat()), (double)((float)this.field_145848_d + rand.nextFloat()), (double)((float)this.field_145849_e + rand.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (rand.nextInt(19 - this.numchanges) == 0) {
                this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 0.0f, false);
            }
        } else if (this.numchanges > 3) {
            for (i = 0; i < this.numchanges / 3; ++i) {
                this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + rand.nextFloat()), (double)((float)this.field_145848_d + rand.nextFloat()), (double)((float)this.field_145849_e + rand.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (rand.nextInt(11 - this.numchanges) == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 1.0f);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean func_70300_a(EntityPlayer ep) {
        if (this.numchanges > 0) {
            return false;
        }
        if (this.power < this.MINPOWER) {
            return false;
        }
        return super.isPlayerAccessible(ep);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        float f;
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.testInconsistentPower()) {
            return;
        }
        if (this.power < this.MINPOWER) {
            this.lidAngle = 0.0f;
            this.prevLidAngle = 0.0f;
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerScaleChest) || (iinventory = ((ContainerScaleChest)entityplayer.field_71070_bA).getLowerScaleChestInventory()) != this) continue;
                ++this.numUsingPlayers;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_145851_c + 0.5;
            double d0 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d0, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d0 = (double)this.field_145851_c + 0.5;
                double d2 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d0, (double)this.field_145848_d + 0.5, d2, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 2: {
                this.read = ForgeDirection.NORTH;
            }
        }
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    @Override
    public void func_70295_k_() {
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTileEntityBlockID(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTileEntityBlockID());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTileEntityBlockID());
    }

    @Override
    public void func_70305_f() {
        --this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTileEntityBlockID(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTileEntityBlockID());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTileEntityBlockID());
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("chng", this.numchanges);
        NBT.func_74768_a("player", this.numUsingPlayers);
        NBT.func_74768_a("pg", this.page);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.numchanges = NBT.func_74762_e("chng");
        this.numUsingPlayers = NBT.func_74762_e("player");
        this.page = NBT.func_74762_e("pg");
    }

    public void writeInventoryToItem(ItemStack is) {
        is.field_77990_d = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74777_a("Slot", (short)i);
            this.inv[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        is.field_77990_d.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void readInventoryFromItem(ItemStack is) {
        if (is.field_77990_d != null) {
            NBTTagList nbttaglist = is.field_77990_d.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            this.inv = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                short byte0 = nbttagcompound.func_74765_d("Slot");
                if (byte0 >= 0 && byte0 < this.inv.length) {
                    this.inv[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
                    continue;
                }
                RotaryCraft.logger.logError((Object)(this + " tried to load an inventory slot " + byte0 + " from NBT!"));
            }
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SCALECHEST;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot < this.getNumberSlots();
    }

    public int getRedstoneOverride() {
        return 15 * this.func_70302_i_() / 972;
    }
}

