/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityGrindstone
extends InventoriedPowerLiquidReceiver
implements MultiOperational,
ConditionalOperation,
OneSlotMachine {
    private static final String NBT_TAG = "repairs";
    private int soundtick;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(true);
        ++this.tickcount;
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        if (this.inv[0] != null) {
            ++this.soundtick;
            if (this.soundtick > 49) {
                SoundRegistry.FRICTION.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.1f : 0.5f, 1.0f);
                this.soundtick = 0;
            }
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (world.field_72995_K) {
            return;
        }
        int n = this.getNumberConsecutiveOperations();
        for (int i = 0; i < n; ++i) {
            this.doOperation(n > 1);
        }
    }

    private void doOperation(boolean multiple) {
        if (this.tank.isEmpty()) {
            return;
        }
        if (this.hasValidItem()) {
            this.createUsesTag();
            this.repair();
            this.tank.removeLiquid(100);
        }
    }

    private void createUsesTag() {
        if (this.inv[0].field_77990_d == null) {
            this.inv[0].field_77990_d = new NBTTagCompound();
        }
        if (!this.inv[0].field_77990_d.func_74764_b(NBT_TAG)) {
            this.inv[0].field_77990_d.func_74768_a(NBT_TAG, this.inv[0].func_77958_k() * 2);
        }
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 1: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.WEST;
                break;
            }
            case 0: {
                this.read = ForgeDirection.SOUTH;
                this.read2 = ForgeDirection.NORTH;
            }
        }
    }

    private void repair() {
        int dmg = this.inv[0].func_77960_j();
        int newdmg = dmg - 1;
        this.inv[0].func_77964_b(newdmg);
        int repair = this.inv[0].field_77990_d.func_74762_e(NBT_TAG);
        this.inv[0].field_77990_d.func_74768_a(NBT_TAG, repair - 1);
    }

    public int getMinimumDamageForItem(ItemStack is) {
        return is.field_77990_d != null && is.field_77990_d.func_74764_b(NBT_TAG) ? is.func_77958_k() - MathHelper.func_76123_f((float)((float)is.field_77990_d.func_74762_e(NBT_TAG) / 2.0f)) : 0;
    }

    public boolean hasValidItem() {
        if (this.inv[0] == null) {
            return false;
        }
        if (!this.func_94041_b(0, this.inv[0])) {
            return false;
        }
        return this.inv[0].func_77960_j() > this.getMinimumDamageForItem(this.inv[0]);
    }

    public boolean func_102008_b(int i, ItemStack is, int j) {
        return is.func_77960_j() <= this.getMinimumDamageForItem(is);
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return is.func_77984_f() && (is.func_77973_b() instanceof ItemShears || is.func_77973_b() instanceof ItemSword || is.func_77973_b() instanceof ItemTool);
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.WATER;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    @Override
    public int getCapacity() {
        return 1000;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.GRINDSTONE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean areConditionsMet() {
        return this.hasValidItem();
    }

    @Override
    public String getOperationalStatus() {
        return this.inv[0] == null ? "No Tool" : (this.areConditionsMet() ? "Operational" : "Invalid Item");
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.GRINDSTONE.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.GRINDSTONE.getNumberOperations(this.omega);
    }
}

