/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.RotaryCraft.Auxiliary.Interfaces.TransmissionReceiver;
import Reika.RotaryCraft.Auxiliary.ShaftPowerBus;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidReceiver;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityBusController
extends PoweredLiquidReceiver
implements TransmissionReceiver,
BreakAction {
    private ShaftPowerBus bus = new ShaftPowerBus(this);
    private StepTimer timer = new StepTimer(100);

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BUSCONTROLLER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        this.timer.update();
        if (DragonAPICore.debugtest) {
            this.tank.addLiquid(5, FluidRegistry.getFluid((String)"rc lubricant"));
        }
        if (this.tank.isEmpty()) {
            this.torque = 0;
            this.omega = 0;
        } else if (this.power > 0L && this.timer.checkCap()) {
            this.tank.removeLiquid(this.getLubricantUsed());
        }
        this.power = (long)this.torque * (long)this.omega;
        if (this.tickcount % 10 == 0) {
            this.bus.update();
        }
    }

    private int getLubricantUsed() {
        return Math.max(1, (int)(DifficultyEffects.LUBEUSAGE.getChance() * 2.0f * (float)this.bus.getSize() + (float)this.bus.getTotalOutputSides()));
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
            }
        }
    }

    public ShaftPowerBus getBus() {
        return this.bus;
    }

    private void clear() {
        this.bus.clear();
        this.bus = null;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.HOSE || m == MachineRegistry.BEDPIPE;
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.getFluid((String)"rc lubricant");
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY != 0;
    }

    @Override
    public int getCapacity() {
        return 8000;
    }

    public void breakBlock() {
        this.clear();
    }

    @Override
    public void getOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        Collection<TileEntityPowerBus> c2 = this.bus.getBlocks();
        for (TileEntityPowerBus te : c2) {
            te.getAllOutputs(c, dir);
        }
    }
}

