/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Interfaces.ComplexIO;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntity1DTransmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPortalShaft
extends TileEntity1DTransmitter
implements ChunkLoadingTile {
    private PortalType type;
    public MaterialRegistry material;
    private WorldLocation otherShaft;

    public int getCurrentDimID() {
        return this.field_145850_b.field_73011_w.field_76574_g;
    }

    public int getTargetDimID() {
        int id = this.getCurrentDimID();
        switch (this.type) {
            case END: {
                return id == 0 ? 1 : 0;
            }
            case MYSTCRAFT: {
                return this.getMystCraftTarget();
            }
            case NETHER: {
                return id == 0 ? -1 : 0;
            }
            case TWILIGHT: {
                return id == 0 ? TwilightForestHandler.getInstance().dimensionID : 0;
            }
        }
        return id;
    }

    private int getMystCraftTarget() {
        int x = this.field_145851_c + this.write.offsetX;
        int y = this.field_145848_d + this.write.offsetY;
        int z = this.field_145849_e + this.write.offsetZ;
        return ReikaMystcraftHelper.getTargetDimensionIDFromPortalBlock((World)this.field_145850_b, (int)x, (int)y, (int)z);
    }

    public void setPortalType(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150427_aO) {
            this.type = PortalType.NETHER;
        }
        if (id == Blocks.field_150384_bq) {
            this.type = PortalType.END;
        }
        if (ModList.MYSTCRAFT.isLoaded() && id == MystCraftHandler.getInstance().portalID) {
            this.type = PortalType.MYSTCRAFT;
        }
        if (ModList.TWILIGHT.isLoaded() && id == TwilightForestHandler.BlockEntry.PORTAL.getBlock()) {
            this.type = PortalType.TWILIGHT;
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        if (ReikaBlockHelper.isPortalBlock((World)world, (int)(x + this.write.offsetX), (int)(y + this.write.offsetY), (int)(z + this.write.offsetZ))) {
            this.transferPower(world, x, y, z, meta);
            this.emitPower(world, x, y, z);
        }
        if (!world.field_72995_K && this.otherShaft != null && !(this.otherShaft.getTileEntity() instanceof TileEntityPortalShaft)) {
            this.power = 0L;
            world.func_147465_d(x, y, z, MachineRegistry.SHAFT.getBlock(), MachineRegistry.SHAFT.getBlockMetadata(), 3);
            TileEntityShaft ts = new TileEntityShaft(this.getShaftType());
            ts.setBlockMetadata(this.func_145832_p());
            world.func_147455_a(x, y, z, (TileEntity)ts);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
    }

    private int getTargetDimensionBy(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int id = world.field_73011_w.field_76574_g;
        switch (this.type) {
            case END: {
                return block == Blocks.field_150384_bq ? (id == 0 ? 1 : 0) : Integer.MIN_VALUE;
            }
            case MYSTCRAFT: {
                return ReikaMystcraftHelper.getTargetDimensionIDFromPortalBlock((World)world, (int)x, (int)y, (int)z);
            }
            case NETHER: {
                return block == Blocks.field_150427_aO ? (id == 0 ? -1 : 0) : Integer.MIN_VALUE;
            }
            case TWILIGHT: {
                return id == 0 ? TwilightForestHandler.getInstance().dimensionID : 0;
            }
        }
        return id;
    }

    private Coordinate getScaledCoordinates(int x, int y, int z, World source, World target) {
        if (source == null || target == null) {
            return null;
        }
        int tg = target.field_73011_w.field_76574_g;
        int src = source.field_73011_w.field_76574_g;
        if (src != -1 && tg == -1) {
            x /= 8;
            z /= 8;
        }
        if (src == -1 && tg != -1) {
            x *= 8;
            z *= 8;
        }
        return new Coordinate(x, y, z);
    }

    private void emitPower(World world, int x, int y, int z) {
        Location c = this.getOutputLocation(world, x, y, z);
        if (c == null) {
            return;
        }
        int dx = c.posX;
        int dy = c.posY;
        int dz = c.posZ;
        int ax = c.posXA;
        int ay = c.posYA;
        int az = c.posZA;
        World age = c.world;
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)age, dx, dy, dz);
        if (m == MachineRegistry.SHAFT) {
            TileEntityShaft te = (TileEntityShaft)age.func_147438_o(dx, dy, dz);
            int terx = te.field_145851_c + te.getReadDirection().offsetX;
            int tery = te.field_145848_d + te.getReadDirection().offsetY;
            int terz = te.field_145849_e + te.getReadDirection().offsetZ;
            if (terx == ax && tery == ay && terz == az) {
                Block tid = MachineRegistry.PORTALSHAFT.getBlock();
                int tmeta = MachineRegistry.PORTALSHAFT.getBlockMetadata();
                age.func_147468_f(dx, dy, dz);
                age.func_147465_d(dx, dy, dz, tid, tmeta, 3);
                TileEntityPortalShaft ps = (TileEntityPortalShaft)age.func_147438_o(dx, dy, dz);
                ps.read = te.getReadDirection();
                ps.setBlockMetadata(te.func_145832_p());
                ps.setPortalType(age, ax, ay, az);
                ps.material = this.material;
                ps.otherShaft = new WorldLocation((TileEntity)this);
                this.otherShaft = new WorldLocation(age, dx, dy, dz);
                ReikaPacketHelper.sendUpdatePacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.TILEDELETE.ordinal(), (TileEntity)ps, (PacketTarget)new PacketTarget.RadiusTarget((TileEntity)this, 32.0));
            }
        } else if (m == MachineRegistry.PORTALSHAFT) {
            TileEntityPortalShaft te = (TileEntityPortalShaft)age.func_147438_o(dx, dy, dz);
            int terx = te.field_145851_c + te.getReadDirection().offsetX;
            int tery = te.field_145848_d + te.getReadDirection().offsetY;
            int terz = te.field_145849_e + te.getReadDirection().offsetZ;
            if (terx == ax && tery == ay && terz == az) {
                te.power = this.power;
                te.omega = this.omega;
                te.torque = this.torque;
            }
        }
    }

    private Location getOutputLocation(World world, int x, int y, int z) {
        int tg;
        int dim = this.getTargetDimID();
        WorldServer age = DimensionManager.getWorld((int)dim);
        Coordinate loc = this.getScaledCoordinates(x + this.write.offsetX, y + this.write.offsetY, z + this.write.offsetZ, world, (World)age);
        if (loc == null) {
            return null;
        }
        int ax = loc.xCoord;
        int ay = loc.yCoord;
        int az = loc.zCoord;
        if (age != null && (tg = this.getTargetDimensionBy((World)age, ax, ay, az)) == world.field_73011_w.field_76574_g) {
            Coordinate c2 = this.getScaledCoordinates(x, y, z, world, (World)age);
            return new Location((World)age, loc.xCoord + this.write.offsetX, loc.yCoord + this.write.offsetY, loc.zCoord + this.write.offsetZ, ax, ay, az);
        }
        return null;
    }

    public void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.read = ForgeDirection.EAST;
                this.write = this.read.getOpposite();
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                this.write = this.read.getOpposite();
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                this.write = this.read.getOpposite();
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                this.write = this.read.getOpposite();
                break;
            }
            case 4: {
                this.read = ForgeDirection.DOWN;
                this.write = this.read.getOpposite();
                break;
            }
            case 5: {
                this.read = ForgeDirection.UP;
                this.write = this.read.getOpposite();
            }
        }
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.25));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PORTALSHAFT;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void transferPower(World world, int x, int y, int z, int meta) {
        this.torquein = 0;
        this.omegain = 0;
        MachineRegistry m = this.getMachine(this.read);
        TileEntity te = this.getAdjacentTileEntity(this.read);
        if (this.isProvider(te)) {
            ShaftPowerEmitter sp;
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein);
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (te instanceof ComplexIO) {
                ComplexIO pwr = (ComplexIO)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.torquein = this.torque;
                    this.omegain = this.omega;
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                }
            }
            this.omega = this.omegain;
            this.torque = this.torquein;
        } else {
            this.torque = 0;
            this.omega = 0;
        }
        this.power = (long)this.torque * (long)this.omega;
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.type = PortalType.values()[NBT.func_74762_e("portal")];
        MaterialRegistry mat = MaterialRegistry.WOOD;
        if (NBT.func_74764_b("shafttype")) {
            mat = MaterialRegistry.valueOf(NBT.func_74779_i("shafttype"));
        } else if (NBT.func_74764_b("type")) {
            mat = MaterialRegistry.matList[NBT.func_74762_e("type")];
        }
        this.material = mat;
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.type != null) {
            NBT.func_74768_a("portal", this.type.ordinal());
        }
        if (this.material != null) {
            NBT.func_74778_a("mat", this.material.name());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    public MaterialRegistry getShaftType() {
        if (this.isInWorld() && this.material != null) {
            return this.material;
        }
        return MaterialRegistry.STEEL;
    }

    public boolean isEnteringPortal() {
        if (this.write == null) {
            return false;
        }
        return ReikaBlockHelper.isPortalBlock((World)this.field_145850_b, (int)(this.field_145851_c + this.write.offsetX), (int)(this.field_145848_d + this.write.offsetY), (int)(this.field_145849_e + this.write.offsetZ));
    }

    public boolean isExitingPortal() {
        if (this.read == null) {
            return false;
        }
        return ReikaBlockHelper.isPortalBlock((World)this.field_145850_b, (int)(this.field_145851_c + this.read.offsetX), (int)(this.field_145848_d + this.read.offsetY), (int)(this.field_145849_e + this.read.offsetZ));
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        Location loc = this.getOutputLocation(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        c.add(loc.world.func_147438_o(loc.posX, loc.posY, loc.posZ));
    }

    public void breakBlock() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)1);
    }

    private static class Location {
        private final World world;
        private final int posX;
        private final int posY;
        private final int posZ;
        private final int posXA;
        private final int posYA;
        private final int posZA;

        private Location(World world, int x, int y, int z, int xa, int ya, int za) {
            this.world = world;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.posXA = xa;
            this.posYA = ya;
            this.posZA = za;
        }
    }

    public static enum PortalType {
        NETHER,
        END,
        TWILIGHT,
        MYSTCRAFT;

    }
}

