/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.ChromatiCraft.API.ChromatiAPI;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.MachineEnchantmentHandler;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineGun
extends InventoriedPowerReceiver
implements RangedEffect,
EnchantableMachine,
DiscreteFunction {
    private final MachineEnchantmentHandler enchantments = new MachineEnchantmentHandler().addFilter(Enchantment.field_77342_w).addFilter(Enchantment.field_77345_t);

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        if (DragonAPICore.debugtest) {
            ReikaInventoryHelper.addToIInv((Item)Items.field_151032_g, (IInventory)this);
        }
        if (this.tickcount >= this.getOperationTime() && ReikaInventoryHelper.checkForItem((Item)Items.field_151032_g, (ItemStack[])this.inv)) {
            AxisAlignedBB box = this.drawAABB(world, x, y, z, meta);
            List li = world.func_72872_a(EntityLivingBase.class, box);
            if (li.size() > 0 && !ReikaEntityHelper.allAreDead((List)li, (boolean)false) && !this.isReikaOnly(li)) {
                this.fire(world, x, y, z, meta);
            }
            this.tickcount = 0;
        }
    }

    private boolean isReikaOnly(List<EntityLivingBase> li) {
        if (li.size() != 1) {
            return false;
        }
        EntityLivingBase e = li.get(0);
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        if (ReikaPlayerAPI.isReika((EntityPlayer)((EntityPlayer)e))) {
            return !((EntityPlayer)e).field_71075_bZ.field_75098_d;
        }
        return false;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
            }
        }
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private int getArrowSlot() {
        return ReikaInventoryHelper.locateIDInInventory((Item)Items.field_151032_g, (IInventory)this);
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return is.func_77973_b() == Items.field_151032_g;
    }

    public int func_70302_i_() {
        return 27;
    }

    private double getFirePower() {
        return (double)this.enchantments.getEnchantment(Enchantment.field_77345_t) * 0.5 + ReikaMathLibrary.logbase((long)(this.torque + 1), (int)2);
    }

    @Override
    public int getOperationTime() {
        return Math.max(16 - (int)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), 4);
    }

    private void fire(World world, int x, int y, int z, int meta) {
        double vx = 0.0;
        double vz = 0.0;
        double v = this.getFirePower();
        if (ModList.CHROMATICRAFT.isLoaded()) {
            v *= ChromatiAPI.getAPI().adjacency().getFactorSimple(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "PINK");
        }
        switch (meta) {
            case 1: {
                ++x;
                vx = v;
                break;
            }
            case 0: {
                --x;
                vx = -v;
                break;
            }
            case 2: {
                ++z;
                vz = v;
                break;
            }
            case 3: {
                --z;
                vz = -v;
            }
        }
        EntityArrow ar = new EntityArrow(world);
        ar.func_70012_b((double)x + 0.5, (double)y + 0.8, (double)z + 0.5, 0.0f, 0.0f);
        ar.field_70159_w = vx;
        ar.field_70179_y = vz;
        if (!world.field_72995_K) {
            ar.field_70133_I = true;
            world.func_72838_d((Entity)ar);
        }
        if (!this.enchantments.hasEnchantment(Enchantment.field_77342_w)) {
            ReikaInventoryHelper.decrStack((int)this.getArrowSlot(), (ItemStack[])this.inv);
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.bow", (float)1.0f, (float)1.0f);
    }

    private AxisAlignedBB drawAABB(World world, int x, int y, int z, int meta) {
        double d = 0.1;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72331_e(d, d, d);
        int r = this.getRange();
        switch (meta) {
            case 1: {
                box.func_72317_d(1.0, 0.0, 0.0);
                box.field_72336_d += (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.EAST, (int)r), r);
                break;
            }
            case 0: {
                box.func_72317_d(-1.0, 0.0, 0.0);
                box.field_72340_a -= (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.WEST, (int)r), r);
                break;
            }
            case 2: {
                box.func_72317_d(0.0, 0.0, 1.0);
                box.field_72334_f += (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.SOUTH, (int)r), r);
                break;
            }
            case 3: {
                box.func_72317_d(0.0, 0.0, -1.0);
                box.field_72339_c -= (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.NORTH, (int)r), r);
            }
        }
        return box;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ARROWGUN;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    public int getRange() {
        return this.getMaxRange();
    }

    @Override
    public int getMaxRange() {
        return 10 + 2 * (int)ReikaMathLibrary.logbase((long)(this.torque + 1), (int)2);
    }

    public int getRedstoneOverride() {
        return Container.func_94526_b((IInventory)this);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public MachineEnchantmentHandler getEnchantmentHandler() {
        return this.enchantments;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74782_a("enchants", (NBTBase)this.enchantments.writeToNBT());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.enchantments.readFromNBT(NBT.func_150295_c("enchants", ReikaNBTHelper.NBTTypes.COMPOUND.ID));
    }
}

