/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntitySonicWeapon
extends TileEntityPowerReceiver
implements GuiController,
RangedEffect {
    public long setpitch;
    public long setvolume;
    public static final long MAXBROWNNOTE = 64L;
    public static final long BATKILL = 80000L;
    public static final long OMINOUS = 16L;
    public static final long DOGWHISTLE = 40000L;
    public static final long LRAD = 2400L;
    public static final long LETHALVOLUME = 100000000L;
    public static final long BRICKDESTROY = 1000000L;
    public static final long LRADVOLUME = 1260L;
    public static final long SHATTERGLASS = 118680L;
    public static final long BREAKWOOD = 475410L;
    public static final long LUNGDAMAGE = 2971000L;
    public static final long BRAINDAMAGE = 3906200L;
    public static final long EYEDAMAGE = 1807500L;
    public static final long SILVERFISHKILL = 400000L;
    public static final long REFERENCE = 1000000000000L;
    public static final int fudge = 1;
    public static final int FALLOFF = 16384;
    public static final long INTENSITYPERTORQUE = 381469726L;
    public static final int HZPEROMEGA = 8192;
    public static final boolean ENABLEFREQ = false;
    public static final boolean DECIBELMODE = true;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.setpitch > this.getMaxPitch()) {
            this.setpitch = this.getMaxPitch();
        }
        if (this.setvolume > this.getMaxVolume()) {
            this.setvolume = this.getMaxVolume();
        }
        this.applyEffects(world, x, y, z);
        if (this.tickcount >= 10) {
            SoundRegistry.SONIC.playSoundAtBlock(world, x, y, z);
            this.tickcount = 0;
        }
    }

    public void applyEffects(World world, int x, int y, int z) {
        int range = this.getRange();
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : inbox) {
            boolean vuln = true;
            if (ent instanceof EntityPlayer && !this.isPlayerVulnerable((EntityPlayer)ent)) {
                vuln = false;
            }
            if (!vuln) continue;
            double vol = this.getVolume();
            for (Effects e : Effects.list) {
                if (!(1.0 * ReikaPhysicsHelper.inverseSquare((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5), (double)vol) >= (double)e.threshold)) continue;
                e.doEffect(ent);
            }
        }
        this.breakBrick(world, x, y, z);
        this.killSilverfish(world, x, y, z);
    }

    private void killSilverfish(World world, int x, int y, int z) {
        if (this.getVolume() < 400000L) {
            return;
        }
        int range = (int)(6.0 * (double)this.getVolume() / 400000.0);
        if (range > 20) {
            range = 20;
        }
        for (int i = 0; i < range; ++i) {
            int bz;
            int by;
            int bx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)range);
            if (world.func_147439_a(bx, by = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)range), bz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)range)) != Blocks.field_150418_aU) continue;
            int metadata = world.func_72805_g(bx, by, bz);
            switch (metadata) {
                case 0: {
                    world.func_147449_b(bx, by, bz, Blocks.field_150348_b);
                    break;
                }
                case 1: {
                    world.func_147449_b(bx, by, bz, Blocks.field_150347_e);
                    break;
                }
                case 2: {
                    world.func_147449_b(bx, by, bz, Blocks.field_150417_aV);
                }
            }
            world.func_72908_a((double)bx + 0.5, (double)by + 0.5, (double)bz + 0.5, "mob.silverfish.kill", 1.0f, 1.0f);
            ReikaWorldHelper.splitAndSpawnXP((World)world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (int)new EntitySilverfish((World)world).field_70728_aV);
        }
    }

    public void breakBrick(World world, int x, int y, int z) {
    }

    public long getMaxPitch() {
        return this.omega * 8192;
    }

    public long getMaxVolume() {
        return 381469726L * (long)this.torque;
    }

    public long getVolume() {
        long maxvol = this.getMaxVolume();
        if (this.setvolume > maxvol) {
            return maxvol / 1000000L;
        }
        return this.setvolume / 1000000L;
    }

    public long getPitch() {
        long maxpitch = this.getMaxPitch();
        if (this.setpitch > maxpitch) {
            return maxpitch;
        }
        return this.setpitch;
    }

    @Override
    public int getRange() {
        return 16;
    }

    private boolean isPlayerVulnerable(EntityPlayer ep) {
        if (ep.field_71075_bZ.field_75098_d) {
            return false;
        }
        return ep.field_71071_by.field_70460_b[3] == null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74772_a("setfrequency", this.setpitch);
        NBT.func_74772_a("setvolume", this.setvolume);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.setpitch = NBT.func_74763_f("setfrequency");
        this.setvolume = NBT.func_74763_f("setvolume");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SONICWEAPON;
    }

    @Override
    public int getMaxRange() {
        return this.getRange();
    }

    public int getRedstoneOverride() {
        return 0;
    }

    private static enum Effects {
        EYE(1807500L),
        BRAIN(3906200L),
        LUNG(2971000L),
        KILL(100000000L);

        private final long threshold;
        private static final Effects[] list;

        private Effects(long l) {
            this.threshold = l;
        }

        private void doEffect(EntityLivingBase ent) {
            switch (this) {
                case EYE: {
                    ent.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 20, 0));
                    if (!(ent instanceof EntityCreature)) break;
                    break;
                }
                case BRAIN: {
                    AxisAlignedBB nearmob;
                    Entity target;
                    ent.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 10));
                    ent.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 20, 3));
                    ent.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 1));
                    if (ent instanceof EntityAnimal) {
                        EntityAnimal ani = (EntityAnimal)ent;
                        ani.func_70661_as().func_75499_g();
                        if (ani.func_70661_as().func_75500_f()) {
                            double randx = ani.field_70165_t - 8.0 + (double)rand.nextInt(17);
                            double randz = ani.field_70161_v - 8.0 + (double)rand.nextInt(17);
                            int randy = ent.field_70170_p.func_72825_h((int)randx, (int)randz);
                            PathEntity path = ani.func_70661_as().func_75488_a(randx, (double)randy, randz);
                            ani.func_70661_as().func_75484_a(path, (double)0.2f);
                        }
                    }
                    if (!(ent instanceof EntityMob) || !((target = ent.field_70170_p.func_72857_a(EntityMob.class, nearmob = AxisAlignedBB.func_72330_a((double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v).func_72314_b(10.0, 10.0, 10.0), (Entity)ent)) instanceof EntityMob)) break;
                    ((EntityMob)ent).func_70624_b((EntityLivingBase)target);
                    ((EntityMob)ent).func_70784_b(target);
                    ent.func_70604_c((EntityLivingBase)target);
                    ent.func_130011_c(target);
                    break;
                }
                case LUNG: {
                    if (rand.nextInt(40) != 0) break;
                    ent.func_70097_a(DamageSource.field_76369_e, 1.0f);
                    break;
                }
                case KILL: {
                    ent.func_70097_a(DamageSource.field_76380_i, 2.1474836E9f);
                }
            }
        }

        static {
            list = Effects.values();
        }
    }
}

