﻿// gobang.cpp: 实现文件
//

#include "pch.h"
#include "newkeshe.h"
#include "gobang.h"
#include "afxdialogex.h"
#include "newkesheDlg.h"


// gobang 对话框

IMPLEMENT_DYNAMIC(gobang, CDialogEx)

gobang::gobang(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_NEWKESHE_DIALOG, pParent)
{

}

gobang::~gobang()
{
}

void gobang::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(gobang, CDialogEx)
END_MESSAGE_MAP()


// gobang 消息处理程序

int piece[15][15] = { 0 };//记录棋子的位置
int n = 0;//用于判断画黑子还是白子
KuangCount kc[3];//记录第几个框框


//刷新数据
void gobang::sxsj() {
	pd = 0;
	isReady = 1;
	isHuiqi = 0;
	count = 0;
	zhan.clear();
	//isKuang = 1;
	for (int i = 0; i < 15; i++) {
		for (int j = 0; j < 15; j++) {
			piece[i][j] = 0;
		}
	}
	for (int i = 0; i < 15; i++) {
		for (int j = 0; j < 15; j++) {
			KUANG[i][j] = 0;
		}
	}
	iRectangle = 0;
}


//画棋盘
void gobang::huaqipan(CDC* pdc) {
	//画棋盘
	CPen pen(PS_SOLID, 2, RGB(0, 0, 0));
	CPen* pOldpen = pdc->SelectObject(&pen);//获取指针
	int Ox = 20;
	int Oy = 20;
	int numx = 15;//行数
	int numy = 15;//列数
	for (int i = 0; i < numx; i++)//画列线
	{
		pdc->MoveTo(Ox + 30 * i, Oy);
		pdc->LineTo(Ox + 30 * i, 440);
	}
	for (int j = 0; j < numy; j++)//画行线
	{
		pdc->MoveTo(20, Oy + 30 * j);
		pdc->LineTo(440, Oy + 30 * j);
	}
	//绘制五个点，5为半径，118，105是左上点的坐标
	//+240和+120是其他点的相对的位置
	CBrush bsh(RGB(0, 0, 0));
	pdc->SelectObject(bsh);
	pdc->Ellipse(110 - 3, 110 - 3, 110 + 3, 110 + 3);
	pdc->Ellipse(110 + 240 - 3, 110 - 3, 110 + 240 + 3, 110 + 3);
	pdc->Ellipse(110 - 3, 110 + 240 - 3, 110 + 3, 110 + 240 + 3);
	pdc->Ellipse(110 + 240 - 3, 110 + 240 - 3, 110 + 240 + 3, 110 + 240 + 3);
	pdc->Ellipse(110 + 120 - 3, 110 + 120 - 3, 110 + 120 + 3, 110 + 120 + 3);
}



//画棋
void gobang::Hpiece(CPoint point, CDC* pdc) {
	//把鼠标位置换算成棋盘上的位置
	HuiQiCount HQC;
	int x = (point.x - 20) / 30, y = (point.y - 20) / 30;
	double m = static_cast<double>(point.x), n = static_cast<double>(point.y);
	double i = ((m - 20) / 30) - ((point.x - 20) / 30);
	double j = ((n - 20) / 30) - ((point.y - 20) / 30);
	if (i<0.5 || i>-0.5) { x += int(i + 0.5); }
	if (j<0.5 || j>-0.5) { y += int(j + 0.5); }
	//画棋子
	if (piece[x][y] == 0) {
		if (pd == 0) {
			CBrush bsh(RGB(0, 0, 0));
			pdc->SelectObject(&bsh);
			pdc->Ellipse((x) * 30 + 20 - 10, (y) * 30 + 20 - 10, (x) * 30 + 20 + 10, (y) * 30 + 20 + 10);
			piece[x][y] = -1;
			count++;
			panduan(x, y);
			HQC.x = x;
			HQC.y = y;
			zhan.push_back(HQC);//将棋子压入栈中
			pd = 1;
		}
		else if (pd == 1) {
			CBrush bsh(RGB(255, 255, 255));
			pdc->SelectObject(&bsh);
			pdc->Ellipse((x) * 30 + 20 - 10, (y) * 30 + 20 - 10, (x) * 30 + 20 + 10, (y) * 30 + 20 + 10);
			piece[x][y] = 1;
			count++;
			panduan(x, y);
			HQC.x = x;
			HQC.y = y;
			zhan.push_back(HQC);
			pd = 0;
		}
	}

}


//悔棋
void gobang::huiqi(CDC* pdc) {
	if (count <= 0) { MessageBox(_T("请先下棋！"), _T("Zhu五子棋"), MB_OK); }
	else if (isReady)
	{
		KUANG[zhan.back().x][zhan.back().y] = 0;
		piece[zhan.back().x][zhan.back().y] = 0;
		zhan.pop_back();
		count--;
		//isHuiqi = 1;
		iRectangle = 0;
		MessageBox(_T("悔棋成功"), _T("Zhu五子棋"), MB_OK);

		//然后for循环遍历一遍piece数组，1画白棋，-1画黑棋子
		auto it = zhan.begin();
		for (; it != zhan.end(); it++)
		{
			if (piece[it->x][it->y] == 1) {
				CBrush bsh(RGB(255, 255, 255));//画棋子的画刷
				pdc->SelectObject(&bsh);
				pdc->Ellipse((it->x) * 30 + 20 - 10, (it->y) * 30 + 20 - 10, (it->x) * 30 + 20 + 10, (it->y) * 30 + 20 + 10);
			}
			else
				if (piece[it->x][it->y] == -1) {
					CBrush bsh(RGB(0, 0, 0));//画棋子的画刷
					pdc->SelectObject(&bsh);
					pdc->Ellipse((it->x) * 30 + 20 - 10, (it->y) * 30 + 20 - 10, (it->x) * 30 + 20 + 10, (it->y) * 30 + 20 + 10);
				}

		}
		if (pd == 1) {
			pd = 0;
		}
		else pd = 1;
	}


}


//判断输赢
void gobang::panduan(int n, int m) {
	int count1 = 0, count2 = 0;//标记相邻个数

	//横向判断
	for (int i = 1; i <= 5; i++) {
		if (n - i <= 0) { break; }//如果超出边界就直接退出循环
		if (piece[n - i + 1][m] == piece[n - i][m]) {
			count1++;
		}
		else { break; }
	}
	for (int i = 1; i <= 5; i++) {
		if (n + i >= 14) { break; }
		if (piece[n + i - 1][m] == piece[n + i][m]) {
			count2++;
		}
		else { break; }
	}
	if (count == 225) {
		MessageBox(_T("和棋！"), _T("Zhu五子棋"), MB_OK);
		isReady = 0;
		isHuiqi = 1;
		return;
	}
	if ((count1 + count2) >= 4) {
		if (n == 1) {
			MessageBox(_T("白棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
		else {
			MessageBox(_T("黑棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
	}

	//纵向判断
	count1 = 0;
	count2 = 0;
	for (int i = 1; i <= 5; i++) {
		if (m - i <= 0) { break; }
		if (piece[n][m - i + 1] == piece[n][m - i]) {
			count1++;
		}
		else { break; }
	}
	for (int i = 1; i <= 5; i++) {
		if (m + i >= 14) { break; }
		if (piece[n][m + i - 1] == piece[n][m + i]) {
			count2++;
		}
		else { break; }
	}
	if (count == 225) {
		MessageBox(_T("和棋！"), _T("Zhu五子棋"), MB_OK);
		isReady = 0;
		isHuiqi = 1;
		return;
	}
	if ((count1 + count2) >= 4) {
		if (n == 1) {
			MessageBox(_T("白棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
		else {
			MessageBox(_T("黑棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
	}

	//左斜向判断
	count1 = 0;
	count2 = 0;
	for (int i = 1; i <= 5; i++) {
		if (n - i <= 0 || m - i <= 0) { break; }
		if (piece[n - i + 1][m - i + 1] == piece[n - i][m - i]) {
			count1++;
		}
		else { break; }
	}
	for (int i = 1; i <= 5; i++) {
		if (n + i >= 14 || m + i >= 14) { break; }
		if (piece[n + i - 1][m + i - 1] == piece[n + i][m + i]) {
			count2++;
		}
		else { break; }
	}
	if (count == 225) {
		MessageBox(_T("和棋！"), _T("Zhu五子棋"), MB_OK);
		isReady = 0;
		isHuiqi = 1;
		return;
	}
	if ((count1 + count2) >= 4) {
		if (n == 1) {
			MessageBox(_T("白棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
		else {
			MessageBox(_T("黑棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
	}

	//右斜向判断
	count1 = 0;
	count2 = 0;
	for (int i = 1; i <= 5; i++) {
		if (m - i <= 0 || n + i >= 14) { break; }
		if (piece[n + i - 1][m - i + 1] == piece[n + i][m - i]) {
			count1++;
		}
		else { break; }
	}
	for (int i = 1; i <= 5; i++) {
		if (n - i <= 0 || m + i >= 14) { break; }
		if (piece[n - i + 1][m + i - 1] == piece[n - i][m + i]) {
			count2++;
		}
		else { break; }
	}
	if (count == 225) {
		MessageBox(_T("和棋！"), _T("Zhu五子棋"), MB_OK);
		isReady = 0;
		isHuiqi = 1;
		return;
	}
	if ((count1 + count2) >= 4) {
		if (n == 1) {
			MessageBox(_T("白棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
		else {
			MessageBox(_T("黑棋获胜！"), _T("Zhu五子棋"), MB_OK);
			isReady = 0;
			isHuiqi = 1;
			return;
		}
	}
}


//画框
void gobang::huakuang(CDC* pDC, CPoint point) {
	//把鼠标位置换算成棋盘上的位置
	int x = (point.x - 20) / 30, y = (point.y - 20) / 30;
	double m = static_cast<double>(point.x), n = static_cast<double>(point.y);
	double i = ((m - 20) / 30) - ((point.x - 20) / 30);
	double j = ((n - 20) / 30) - ((point.y - 20) / 30);
	if (i<0.5 || i>-0.5) { x += int(i + 0.5); }
	if (j<0.5 || j>-0.5) { y += int(j + 0.5); }


	CPen pen;
	pen.CreatePen(PS_SOLID, 1, RGB(255, 0, 0));//创建画笔
	CPen* OldPen = pDC->SelectObject(&pen);
	//画方框
	if (piece[x][y] == 0 && KUANG[x][y] == 0)//没有棋子也没有框
	{
		pDC->SetROP2(R2_NOT);
		//画选中框
		pDC->MoveTo(x * 30 + 20 - 10, y * 30 + 20 - 5);
		pDC->LineTo(x * 30 + 20 - 10, y * 30 + 20 - 10);
		pDC->LineTo(x * 30 + 20 - 5, y * 30 + 20 - 10);

		pDC->MoveTo(x * 30 + 20 + 10, y * 30 + 20 - 5);
		pDC->LineTo(x * 30 + 20 + 10, y * 30 + 20 - 10);
		pDC->LineTo(x * 30 + 20 + 5, y * 30 + 20 - 10);

		pDC->MoveTo(x * 30 + 20 - 10, y * 30 + 20 + 5);
		pDC->LineTo(x * 30 + 20 - 10, y * 30 + 20 + 10);
		pDC->LineTo(x * 30 + 20 - 5, y * 30 + 20 + 10);

		pDC->MoveTo(x * 30 + 20 + 10, y * 30 + 20 + 5);
		pDC->LineTo(x * 30 + 20 + 10, y * 30 + 20 + 10);
		pDC->LineTo(x * 30 + 20 + 5, y * 30 + 20 + 10);
		//赋值
		KUANG[x][y] = 1;
		kc[iRectangle].x = x;
		kc[iRectangle].y = y;
		iRectangle++;//选中框个数加1
	}
	if (iRectangle == 2)
	{
		CPen pen;
		pen.CreatePen(PS_SOLID, 1, RGB(240, 240, 240));//创建画笔
		CPen* OldPen = pDC->SelectObject(&pen);
		//清除选中框
		x = kc[0].x;
		y = kc[0].y;
		pDC->SetROP2(R2_NOT);
		pDC->MoveTo(x * 30 + 20 - 10, y * 30 + 20 - 5);
		pDC->LineTo(x * 30 + 20 - 10, y * 30 + 20 - 10);
		pDC->LineTo(x * 30 + 20 - 5, y * 30 + 20 - 10);

		pDC->MoveTo(x * 30 + 20 + 10, y * 30 + 20 - 5);
		pDC->LineTo(x * 30 + 20 + 10, y * 30 + 20 - 10);
		pDC->LineTo(x * 30 + 20 + 5, y * 30 + 20 - 10);

		pDC->MoveTo(x * 30 + 20 - 10, y * 30 + 20 + 5);
		pDC->LineTo(x * 30 + 20 - 10, y * 30 + 20 + 10);
		pDC->LineTo(x * 30 + 20 - 5, y * 30 + 20 + 10);

		pDC->MoveTo(x * 30 + 20 + 10, y * 30 + 20 + 5);
		pDC->LineTo(x * 30 + 20 + 10, y * 30 + 20 + 10);
		pDC->LineTo(x * 30 + 20 + 5, y * 30 + 20 + 10);
		//赋值
		KUANG[x][y] = 0;
		kc[0].x = kc[1].x;
		kc[0].y = kc[1].y;
		iRectangle = 1;//重置计数
	}
	pDC->SelectObject(OldPen);//恢复设备环境中原来的画笔
	pen.DeleteObject();//释放绘图资源
}

