function InitWebsocket() {
	if(typeof webui_hook_getWebSocketPort !== "function"){
		mdui.alert("框架初始化失败，请尝试重启NanBot<br>您看到的此错误是由于无法建立WS所产生的<br>若多次出现请联系开发者提交BUG");
		return;
	}
	var port = webui_hook_getWebSocketPort();
	ws = new WebSocket("ws://127.0.0.1:" + port + "/NanBot");
	ws.onopen = function() {
		Loading_start();
		ws.send(JSON.stringify({"mod":"init"}))
	};
	ws.onmessage = function(evt) {
		///alert(evt.data);
		webSocketDataDo(evt.data);
	};
	ws.onerror = function() {
		Loading_stop();
		mdui.alert("前端与后端的链接已丢失，请尝试重启软件。","发生了点意外...");
		webui_hook_ErrorInfoPost("Web Socket Error");
	};
	ws.onclose = function() {
		Loading_stop();
		mdui.alert("前端与后端的链接已丢失，请尝试重启软件。","发生了点意外...");
		webui_hook_ErrorInfoPost("Web Socket Error");
	};
}

function webSocketDataDo(data) {
	//console.log(data);
	var info = $.parseJSON(data);
	//var info = eval('(' + data + ')');;
	//alert(info.msg);
	switch (info.mod) {
		case "initDone":
			//alert("初始化完成");
			ws_back_initDone(info.status);
			break;
		case "ctips":
			ws_back_ctips(info.msg);
			break;
		case "GetMainInfoAndReg":
			ws_back_GetMainInfoAndReg(info.data);
			break;
		case "PluginList":
			ws_back_pluginList(info.data);
			break;
		case "showAlert":
			mdui.alert(info.msg,info.title);
			break;
		case "showTips":
			mdui.snackbar({message: info.msg});
			break;
		case "LogSync":
			ws_back_LogSync(info.data);
			break;
		case "TimePostLog":
			ws_back_TimePostLog(info.data);
			break;
			
		case "pluginStatus":
			ws_back_pluginStatus(info.data);
			break;
		case "pluginAdd":
			ws_back_plugininfo(info.data);
			break;
		default:
		
	}
}
function ws_back_initDone(status){
	ws_back_ctips("正在加载");
	Loading_stop();
	showpage("main");
}
function ws_back_ctips(msg){
	$("#loading_tips").html(msg);
}
function ws_back_GetMainInfoAndReg(data){
	//获取首页的基础信息数据
	
	if(data.qq !== undefined && data.qq !== null && data.qq !== ""){
		document.getElementById("main_avatar").src = "http://q.qlogo.cn/headimg_dl?bs=qq&dst_uin="+data.qq+"&spec=100";
	}
	if(data.nick !== undefined && data.nick !== null && data.nick !== ""){
		$("#main_nick").html(data.nick);
	}
	if(data.sign !== undefined && data.sign !== null && data.sign !== ""){
		$("#main_sign").html(data.sign);
	}
	
	$("#msg_rev").html(data.rev);
	$("#msg_send").html(data.send);
	$("#time_online").html(formatSeconds(data.online)); //在线秒数
	$("#msg_speed").html(data.speed + " / Min");
	var html = "";
	var sizeC = false;
	if(data.ad !== undefined && data.ad !== null && data.ad !== ""){
		$.each(data.ad, function(index, value) {
			html = html + '<p><a href="javascript:webui_hook_openUrl(\''+value.url+'\');">'+value.title+'</a></p>';
		});
		$("#main_ad").html(html);
		sizeC = true;
	}
	if(data.ad !== undefined && data.notice !== null && data.notice !== ""){
		html = "";
		//公告信息
		$.each(data.notice, function(index, value) {
			html = html + '<p><a href="javascript:mdui.alert(\''+value.content+'\');">'+value.title+'</a></p>';
		});
		$("#main_notice").html(html);
		mdui.mutation();
		sizeC = true;
	}
	if(sizeC){
		var h1 = $("#index_ad").height();
		var h2 = $("#index_no").height();
		if(h1<h2){
			$("#index_ad").css("height", h2);
		}else{
			$("#index_no").css("height", h1);
		}
	}
	Loading_stop();
}
function ws_back_LogSync(data){
	var now = 0;
	$("#log_table tbody").html("");
	for(var i = data.length - 1; i >=0 ; i--) { // 这里的i是代表数组的下标
	    ws_back_TimePostLog(data[i]);
		
	};
	mdui.mutation();
	Loading_stop();
	return;

}

function ws_back_TimePostLog(data){
	var showstr = data.content.substring(0,200);
	showstr = showstr.replace(/\\\"/g,"\"");
	if(data.content.length > 200){
		showstr = showstr + "...";
	}

	if($("#log_table tr").length > 200){
		$("#log_table tr:last").remove();
	}
	$("#log_table tbody").prepend("<tr><td>"+data.time+"</td><td>"+data.type+"</td><td>"+data.src+"</td><td><a href='javascript:webui_hook_copyText(\""+data.content+"\");'>[复制]</a> "+showstr+"</td></tr>");
}

function ws_back_pluginList(data){
	var now = 0;
	if(data === undefined || data.name === "" || data.name === null){
		Loading_stop();
		$("#pluginList").html("您没有安装任何插件...");
		return;
	}
	$("#pluginList").html(" ");
	$.each(data, function(index, value) {
		ws_back_plugininfo(value);
		now++;
		if(now === data.length){
			mdui.mutation();
			Loading_stop();
		}
	});
}
function ws_back_plugininfo(data){
	if(data.name === undefined || data.name === "" || data.name === null){
		return;
	}
	data.id = data.id.replace(/\./g,"_");
	var info = '';
	info = info + '	<div class="mdui-card mdui-hoverable" mdui-tooltip="{content: \''+data.describe+'\'}" style="width:300px;margin:10px;float:left;">';
	info = info + '		<div class="mdui-card-media">';
	info = info + '			<img src="./imgs/'+data.bg+'" width="300px" height="200px" />';
	info = info + '			<div class="mdui-card-media-covered">';
	info = info + '				<div class="mdui-card-primary" style="padding:10px 16px 10px 16px">';
	info = info + '					<div class="mdui-card-primary-title" style="font-size:20px;">'+data.name+'</div>';
	info = info + '					<div class="mdui-card-primary-subtitle">'+data.author+'<span style="float:right">'+data.vername+'</span></div>';
	info = info + '				</div>';
	info = info + '			</div>';
	info = info + '		</div>';
	info = info + '		<div class="mdui-card-actions">';
	info = info + '			<button class="mdui-btn mdui-btn-icon"  onclick="webui_hook_pluginSet(\''+data.id+'\');"><i class="mdui-icon material-icons">settings</i></button>';
	info = info + '			<button class="mdui-btn mdui-btn-icon"  onclick="pluginSet(2,\''+data.id+'\',this);"><i class="mdui-icon material-icons">refresh</i></button>';
	info = info + '			<button class="mdui-btn mdui-btn-icon"  onclick="pluginSet(3,\''+data.id+'\',this);"><i class="mdui-icon material-icons">info_outline</i></button>';
	info = info + '			<button class="mdui-btn mdui-btn-icon"  onclick="pluginSet(5,\''+data.id+'\',this);"><i class="mdui-icon material-icons">delete</i></button>';
	info = info + '			<label class="mdui-switch mdui-float-right">';
	if(data.status){
		info = info + '				<input type="checkbox" id="'+data.id+'" onchange="pluginSet(4,\''+data.id+'\',this)" checked/>';
	}else{
		info = info + '				<input type="checkbox" id="'+data.id+'" onchange="pluginSet(4,\''+data.id+'\',this)"/>';
	}
	info = info + '				<i class="mdui-switch-icon"></i>';
	info = info + '			</label>';
	info = info + '		</div>';
	info = info + '	</div>';
	$("#pluginList").append(info);
}

function ws_send_logSwitch(status){
	ws.send(JSON.stringify({"mod":"logSwitch", "status":status === true}));
}
function ws_send_getLogs(){
	Loading_start();
	ws.send(JSON.stringify({"mod":"getLogAll"}));
}

function ws_back_pluginStatus(data){
	document.getElementById(data.pid.replace(",","_")).checked = data.status;
}

